/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceContextIterator
implements Iterator {
    Node context;
    NamedNodeMap attributes = null;
    int attributesLength;
    int attributeIndex;
    Attr next = null;
    Attr last = null;
    boolean traverseStack = true;

    public NamespaceContextIterator(Node node) {
        this.context = node;
        this.findContextAttributes();
    }

    public NamespaceContextIterator(Node node, boolean bl) {
        this(node);
        this.traverseStack = bl;
    }

    protected void findContextAttributes() {
        while (this.context != null) {
            short s = this.context.getNodeType();
            if (s == 1) {
                this.attributes = this.context.getAttributes();
                this.attributesLength = this.attributes.getLength();
                this.attributeIndex = 0;
                return;
            }
            this.context = null;
        }
    }

    protected void findNext() {
        while (this.next == null && this.context != null) {
            while (this.attributeIndex < this.attributesLength) {
                Node node = this.attributes.item(this.attributeIndex);
                String string = node.getNodeName();
                if (string.startsWith("xmlns") && (string.length() == 5 || string.charAt(5) == ':')) {
                    this.next = (Attr)node;
                    ++this.attributeIndex;
                    return;
                }
                ++this.attributeIndex;
            }
            if (this.traverseStack) {
                this.context = this.context.getParentNode();
                this.findContextAttributes();
                continue;
            }
            this.context = null;
        }
    }

    public boolean hasNext() {
        this.findNext();
        return this.next != null;
    }

    public Object next() {
        return this.getNext();
    }

    public Attr nextNamespaceAttr() {
        return this.getNext();
    }

    protected Attr getNext() {
        this.findNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.last = this.next;
        this.next = null;
        return this.last;
    }

    public void remove() {
        if (this.last == null) {
            throw new IllegalStateException();
        }
        ((Element)this.context).removeAttributeNode(this.last);
    }
}

