/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.marshaller;

import com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.internal.bind.marshaller.DumbEscapeHandler;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl {
    private final HashMap<String, String> locallyDeclaredPrefix = new HashMap();
    private final Attributes EMPTY_ATTS = new AttributesImpl();
    private int elementLevel = 0;
    private Writer output;
    private String encoding;
    private boolean writeXmlDecl = true;
    private String header = null;
    private final CharacterEscapeHandler escapeHandler;
    private boolean startTagIsClosed = true;

    public XMLWriter(Writer writer, String string, CharacterEscapeHandler characterEscapeHandler) {
        this.init(writer, string);
        this.escapeHandler = characterEscapeHandler;
    }

    public XMLWriter(Writer writer, String string) {
        this(writer, string, DumbEscapeHandler.theInstance);
    }

    private void init(Writer writer, String string) {
        this.setOutput(writer, string);
    }

    public void reset() {
        this.elementLevel = 0;
        this.startTagIsClosed = true;
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void setOutput(Writer writer, String string) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
        this.encoding = string;
    }

    public void setXmlDecl(boolean bl) {
        this.writeXmlDecl = bl;
    }

    public void setHeader(String string) {
        this.header = string;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.locallyDeclaredPrefix.put(string, string2);
    }

    public void startDocument() throws SAXException {
        try {
            this.reset();
            if (this.writeXmlDecl) {
                String string = "";
                if (this.encoding != null) {
                    string = " encoding=\"" + this.encoding + '\"';
                }
                this.writeXmlDecl("<?xml version=\"1.0\"" + string + " standalone=\"yes\"?>");
            }
            if (this.header != null) {
                this.write(this.header);
            }
            super.startDocument();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void writeXmlDecl(String string) throws IOException {
        this.write(string);
    }

    public void endDocument() throws SAXException {
        try {
            super.endDocument();
            this.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write(">");
            }
            ++this.elementLevel;
            this.write('<');
            this.write(string3);
            this.writeAttributes(attributes);
            if (!this.locallyDeclaredPrefix.isEmpty()) {
                for (Map.Entry<String, String> entry : this.locallyDeclaredPrefix.entrySet()) {
                    String string4 = entry.getKey();
                    String string5 = entry.getValue();
                    if (string5 == null) {
                        string5 = "";
                    }
                    this.write(' ');
                    if ("".equals(string4)) {
                        this.write("xmlns=\"");
                    } else {
                        this.write("xmlns:");
                        this.write(string4);
                        this.write("=\"");
                    }
                    char[] cArray = string5.toCharArray();
                    this.writeEsc(cArray, 0, cArray.length, true);
                    this.write('\"');
                }
                this.locallyDeclaredPrefix.clear();
            }
            super.startElement(string, string2, string3, attributes);
            this.startTagIsClosed = false;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.startTagIsClosed) {
                this.write("</");
                this.write(string3);
                this.write('>');
            } else {
                this.write("/>");
                this.startTagIsClosed = true;
            }
            super.endElement(string, string2, string3);
            --this.elementLevel;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write('>');
                this.startTagIsClosed = true;
            }
            this.writeEsc(cArray, n, n2, false);
            super.characters(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.writeEsc(cArray, n, n2, false);
            super.ignorableWhitespace(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write('>');
                this.startTagIsClosed = true;
            }
            this.write("<?");
            this.write(string);
            this.write(' ');
            this.write(string2);
            this.write("?>");
            if (this.elementLevel < 1) {
                this.write('\n');
            }
            super.processingInstruction(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startElement(String string, String string2) throws SAXException {
        this.startElement(string, string2, "", this.EMPTY_ATTS);
    }

    public void startElement(String string) throws SAXException {
        this.startElement("", string, "", this.EMPTY_ATTS);
    }

    public void endElement(String string, String string2) throws SAXException {
        this.endElement(string, string2, "");
    }

    public void endElement(String string) throws SAXException {
        this.endElement("", string, "");
    }

    public void dataElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        this.startElement(string, string2, string3, attributes);
        this.characters(string4);
        this.endElement(string, string2, string3);
    }

    public void dataElement(String string, String string2, String string3) throws SAXException {
        this.dataElement(string, string2, "", this.EMPTY_ATTS, string3);
    }

    public void dataElement(String string, String string2) throws SAXException {
        this.dataElement("", string, "", this.EMPTY_ATTS, string2);
    }

    public void characters(String string) throws SAXException {
        try {
            if (!this.startTagIsClosed) {
                this.write('>');
                this.startTagIsClosed = true;
            }
            char[] cArray = string.toCharArray();
            this.characters(cArray, 0, cArray.length);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected final void write(char c) throws IOException {
        this.output.write(c);
    }

    protected final void write(String string) throws IOException {
        this.output.write(string);
    }

    private void writeAttributes(Attributes attributes) throws IOException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            char[] cArray = attributes.getValue(i).toCharArray();
            this.write(' ');
            this.write(attributes.getQName(i));
            this.write("=\"");
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeEsc(char[] cArray, int n, int n2, boolean bl) throws IOException {
        this.escapeHandler.escape(cArray, n, n2, bl, this.output);
    }
}

