/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.resolver.tools;

import com.sun.org.apache.xml.internal.resolver.Catalog;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.helpers.FileURL;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CatalogResolver
implements EntityResolver,
URIResolver {
    public boolean namespaceAware = true;
    public boolean validating = false;
    private Catalog catalog = null;
    private CatalogManager catalogManager = CatalogManager.getStaticManager();

    public CatalogResolver() {
        this.initializeCatalogs(false);
    }

    public CatalogResolver(boolean bl) {
        this.initializeCatalogs(bl);
    }

    public CatalogResolver(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.initializeCatalogs(!this.catalogManager.getUseStaticCatalog());
    }

    private void initializeCatalogs(boolean bl) {
        this.catalog = this.catalogManager.getCatalog();
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getResolvedEntity(String string, String string2) {
        String string3 = null;
        if (this.catalog == null) {
            this.catalogManager.debug.message(1, "Catalog resolution attempted with null catalog; ignored");
            return null;
        }
        if (string2 != null) {
            try {
                string3 = this.catalog.resolveSystem(string2);
            }
            catch (MalformedURLException malformedURLException) {
                this.catalogManager.debug.message(1, "Malformed URL exception trying to resolve", string);
                string3 = null;
            }
            catch (IOException iOException) {
                this.catalogManager.debug.message(1, "I/O exception trying to resolve", string);
                string3 = null;
            }
        }
        if (string3 == null) {
            if (string != null) {
                try {
                    string3 = this.catalog.resolvePublic(string, string2);
                }
                catch (MalformedURLException malformedURLException) {
                    this.catalogManager.debug.message(1, "Malformed URL exception trying to resolve", string);
                }
                catch (IOException iOException) {
                    this.catalogManager.debug.message(1, "I/O exception trying to resolve", string);
                }
            }
            if (string3 != null) {
                this.catalogManager.debug.message(2, "Resolved public", string, string3);
            }
        } else {
            this.catalogManager.debug.message(2, "Resolved system", string2, string3);
        }
        return string3;
    }

    public InputSource resolveEntity(String string, String string2) {
        String string3 = this.getResolvedEntity(string, string2);
        if (string3 != null) {
            try {
                InputSource inputSource = new InputSource(string3);
                inputSource.setPublicId(string);
                URL uRL = new URL(string3);
                InputStream inputStream = uRL.openStream();
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                this.catalogManager.debug.message(1, "Failed to create InputSource", string3);
                return null;
            }
        }
        return null;
    }

    public Source resolve(String string, String string2) throws TransformerException {
        Object object;
        String string3 = string;
        String string4 = null;
        int n = string.indexOf("#");
        if (n >= 0) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        String string5 = null;
        try {
            string5 = this.catalog.resolveURI(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string5 == null) {
            try {
                object = null;
                if (string2 == null) {
                    object = new URL(string3);
                    string5 = ((URL)object).toString();
                } else {
                    URL uRL = new URL(string2);
                    object = string.length() == 0 ? uRL : new URL(uRL, string3);
                    string5 = ((URL)object).toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                String string6 = this.makeAbsolute(string2);
                if (!string6.equals(string2)) {
                    return this.resolve(string, string6);
                }
                throw new TransformerException("Malformed URL " + string + "(base " + string2 + ")", malformedURLException);
            }
        }
        this.catalogManager.debug.message(2, "Resolved URI", string, string5);
        object = new SAXSource();
        ((SAXSource)object).setInputSource(new InputSource(string5));
        this.setEntityResolver((SAXSource)object);
        return object;
    }

    private void setEntityResolver(SAXSource sAXSource) throws TransformerException {
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            try {
                xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new TransformerException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
        }
        xMLReader.setEntityResolver(this);
        sAXSource.setXMLReader(xMLReader);
    }

    private String makeAbsolute(String string) {
        if (string == null) {
            string = "";
        }
        try {
            URL uRL = new URL(string);
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                URL uRL = FileURL.makeURL(string);
                return uRL.toString();
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
    }
}

