/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.util;

import com.sun.jmx.snmp.SnmpOid;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import sun.management.snmp.util.SnmpTableHandler;

public class SnmpCachedData
implements SnmpTableHandler {
    public static final Comparator oidComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((SnmpOid)object).compareTo((SnmpOid)object2);
        }

        public boolean equals(Object object, Object object2) {
            if (object == object2) {
                return true;
            }
            return object.equals(object2);
        }
    };
    public final long lastUpdated;
    public final SnmpOid[] indexes;
    public final Object[] datas;

    public SnmpCachedData(long l, SnmpOid[] snmpOidArray, Object[] objectArray) {
        this.lastUpdated = l;
        this.indexes = snmpOidArray;
        this.datas = objectArray;
    }

    public SnmpCachedData(long l, TreeMap treeMap) {
        this(l, treeMap, true);
    }

    public SnmpCachedData(long l, TreeMap treeMap, boolean bl) {
        int n = treeMap.size();
        this.lastUpdated = l;
        this.indexes = new SnmpOid[n];
        this.datas = new Object[n];
        if (bl) {
            treeMap.keySet().toArray(this.indexes);
            treeMap.values().toArray(this.datas);
        } else {
            treeMap.values().toArray(this.datas);
        }
    }

    public final int find(SnmpOid snmpOid) {
        return Arrays.binarySearch(this.indexes, snmpOid, oidComparator);
    }

    public Object getData(SnmpOid snmpOid) {
        int n = this.find(snmpOid);
        if (n < 0 || n >= this.datas.length) {
            return null;
        }
        return this.datas[n];
    }

    public SnmpOid getNext(SnmpOid snmpOid) {
        if (snmpOid == null) {
            if (this.indexes.length > 0) {
                return this.indexes[0];
            }
            return null;
        }
        int n = this.find(snmpOid);
        if (n > -1) {
            if (n < this.indexes.length - 1) {
                return this.indexes[n + 1];
            }
            return null;
        }
        int n2 = -n - 1;
        if (n2 > -1 && n2 < this.indexes.length) {
            return this.indexes[n2];
        }
        return null;
    }

    public boolean contains(SnmpOid snmpOid) {
        int n = this.find(snmpOid);
        return n > -1 && n < this.indexes.length;
    }
}

