/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.Util.LogManager;

public class Dumper {
    private Dumper() {
    }

    public static void dumpPackageSettings(PackageDescription packageData) {
        if (packageData.isLeaf()) {
            System.out.println("Name: " + packageData.getName() + " State: " + packageData.getSelectionState() + " " + packageData.getPackageName());
        } else {
            System.out.println("Nod-Name: " + packageData.getName() + " State: " + packageData.getSelectionState());
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            Dumper.dumpPackageSettings(child);
        }
    }

    public static void dumpModuleStates(PackageDescription packageData) {
        System.err.println("Name: " + packageData.getName() + " State: " + packageData.getSelectionState() + " " + packageData.getPackageName());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            Dumper.dumpModuleStates(child);
        }
    }

    private static String getStateString(int state) {
        String stateString = null;
        stateString = state == 0 ? "DONT_INSTALL" : (state == 1 ? "INSTALL" : (state == 2 ? "INSTALL_SOME" : (state == 3 ? "REMOVE" : (state == 4 ? "DONT_REMOVE" : (state == 5 ? "REMOVE_SOME" : (state == 6 ? "IGNORE" : (state == 7 ? "DONT_KNOW" : null)))))));
        return stateString;
    }

    private static void logModuleStatesHelper(PackageDescription packageData) {
        int state = packageData.getSelectionState();
        String stateStr = Dumper.getStateString(state);
        LogManager.addModulesLogfileComment("Name: " + packageData.getName() + " State: " + stateStr + " " + packageData.getPackageName());
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            Dumper.logModuleStatesHelper(child);
        }
    }

    public static void logModuleStates(PackageDescription packageData, String text) {
        LogManager.setModulesLogFileHeaderLine(text);
        Dumper.logModuleStatesHelper(packageData);
    }

    public static void logPackagesToInstall(Vector packages, String text) {
        PackageDescription packageData = null;
        LogManager.setModulesLogFileHeaderLine(text);
        for (int i = 0; i < packages.size(); ++i) {
            packageData = (PackageDescription)packages.get(i);
            LogManager.addModulesLogfileComment("Name: " + packageData.getName() + " " + packageData.getPackageName());
        }
    }

    public static void dumpInstallPackages(PackageDescription packageData) {
        if (packageData.isLeaf()) {
            if (packageData.getSelectionState() == 1) {
                System.out.println("Now installing: " + packageData.getPackageName());
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            Dumper.dumpInstallPackages(child);
        }
    }

    public static void dumpUninstallPackages(PackageDescription packageData) {
        if (packageData.isLeaf()) {
            if (packageData.getSelectionState() == 3) {
                System.out.println("Now uninstalling: " + packageData.getPackageName());
            }
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            Dumper.dumpUninstallPackages(child);
        }
    }

    public static void dumpAllRpmInfo(PackageDescription packageData) {
        if (packageData.getPackageName() != null && !packageData.getPackageName().equals("") && packageData.pkgExists()) {
            System.err.println("RPM data: " + packageData.getPkgRealName() + " : " + packageData.getPkgVersion() + " : " + packageData.getPkgRelease() + " : " + packageData.getPackageName());
        }
        Enumeration e = packageData.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            Dumper.dumpAllRpmInfo(child);
        }
    }

    public static void dumpNewInstallData() {
        InstallData data = InstallData.getInstance();
        System.err.println("PackagePath: " + data.getPackagePath());
        System.err.println("AdminFileReloc: " + data.getAdminFileNameReloc());
        System.err.println("AdminFileRelocNoDepends: " + data.getAdminFileNameRelocNoDepends());
        System.err.println("AdminFileNoReloc: " + data.getAdminFileNameNoReloc());
        System.err.println("AdminFileNoRelocNoDepends: " + data.getAdminFileNameNoRelocNoDepends());
        System.err.println("DatabasePath: " + data.getDatabasePath());
        System.err.println("InstallDir: " + data.getInstallDir());
        System.err.println("Original privileges: " + data.getStoredInstallationPrivileges());
        System.err.println("getuid.so File: " + data.getGetUidPath());
    }

    public static void dumpAllProperties() {
        Properties properties = System.getProperties();
        int size = properties.size();
        Iterator<Map.Entry<Object, Object>> m = properties.entrySet().iterator();
        boolean counter = false;
        while (m.hasNext()) {
            Map.Entry<Object, Object> entry = m.next();
            String env = entry.getKey() + "=" + entry.getValue();
            System.err.println(env);
        }
    }
}

