/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.bind.Util;
import com.sun.xml.internal.bind.v2.model.runtime.RuntimeTypeInfo;
import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.LifecycleMethods;
import com.sun.xml.internal.bind.v2.runtime.Messages;
import com.sun.xml.internal.bind.v2.runtime.Transducer;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.Loader;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallerImpl;
import com.sun.xml.internal.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaxBeanInfo<BeanT> {
    protected boolean isNilIncluded = false;
    protected short flag;
    private static final short FLAG_IS_ELEMENT = 1;
    private static final short FLAG_IS_IMMUTABLE = 2;
    private static final short FLAG_HAS_ELEMENT_ONLY_CONTENTMODEL = 4;
    private static final short FLAG_HAS_BEFORE_UNMARSHAL_METHOD = 8;
    private static final short FLAG_HAS_AFTER_UNMARSHAL_METHOD = 16;
    private static final short FLAG_HAS_BEFORE_MARSHAL_METHOD = 32;
    private static final short FLAG_HAS_AFTER_MARSHAL_METHOD = 64;
    private static final short FLAG_HAS_LIFECYCLE_EVENTS = 128;
    private LifecycleMethods lcm = null;
    public final Class<BeanT> jaxbType;
    private final Object typeName;
    private static final Class[] unmarshalEventParams = new Class[]{Unmarshaller.class, Object.class};
    private static Class[] marshalEventParams = new Class[]{Marshaller.class};
    private static final Logger logger = Util.getClassLogger();

    protected JaxBeanInfo(JAXBContextImpl jAXBContextImpl, RuntimeTypeInfo runtimeTypeInfo, Class<BeanT> clazz, QName[] qNameArray, boolean bl, boolean bl2, boolean bl3) {
        this(jAXBContextImpl, runtimeTypeInfo, clazz, (Object)qNameArray, bl, bl2, bl3);
    }

    protected JaxBeanInfo(JAXBContextImpl jAXBContextImpl, RuntimeTypeInfo runtimeTypeInfo, Class<BeanT> clazz, QName qName, boolean bl, boolean bl2, boolean bl3) {
        this(jAXBContextImpl, runtimeTypeInfo, clazz, (Object)qName, bl, bl2, bl3);
    }

    protected JaxBeanInfo(JAXBContextImpl jAXBContextImpl, RuntimeTypeInfo runtimeTypeInfo, Class<BeanT> clazz, boolean bl, boolean bl2, boolean bl3) {
        this(jAXBContextImpl, runtimeTypeInfo, clazz, (Object)null, bl, bl2, bl3);
    }

    private JaxBeanInfo(JAXBContextImpl jAXBContextImpl, RuntimeTypeInfo runtimeTypeInfo, Class<BeanT> clazz, Object object, boolean bl, boolean bl2, boolean bl3) {
        jAXBContextImpl.beanInfos.put(runtimeTypeInfo, this);
        this.jaxbType = clazz;
        this.typeName = object;
        this.flag = (short)((bl ? 1 : 0) | (bl2 ? 2 : 0) | (bl3 ? 128 : 0));
    }

    public final boolean hasBeforeUnmarshalMethod() {
        return (this.flag & 8) != 0;
    }

    public final boolean hasAfterUnmarshalMethod() {
        return (this.flag & 0x10) != 0;
    }

    public final boolean hasBeforeMarshalMethod() {
        return (this.flag & 0x20) != 0;
    }

    public final boolean hasAfterMarshalMethod() {
        return (this.flag & 0x40) != 0;
    }

    public final boolean isElement() {
        return (this.flag & 1) != 0;
    }

    public final boolean isImmutable() {
        return (this.flag & 2) != 0;
    }

    public final boolean hasElementOnlyContentModel() {
        return (this.flag & 4) != 0;
    }

    protected final void hasElementOnlyContentModel(boolean bl) {
        this.flag = bl ? (short)(this.flag | 4) : (short)(this.flag & 0xFFFFFFFB);
    }

    public boolean isNilIncluded() {
        return this.isNilIncluded;
    }

    public boolean lookForLifecycleMethods() {
        return (this.flag & 0x80) != 0;
    }

    public abstract String getElementNamespaceURI(BeanT var1);

    public abstract String getElementLocalName(BeanT var1);

    public Collection<QName> getTypeNames() {
        if (this.typeName == null) {
            return Collections.emptyList();
        }
        if (this.typeName instanceof QName) {
            return Collections.singletonList((QName)this.typeName);
        }
        return Arrays.asList((QName[])this.typeName);
    }

    public QName getTypeName(@NotNull BeanT BeanT) {
        if (this.typeName == null) {
            return null;
        }
        if (this.typeName instanceof QName) {
            return (QName)this.typeName;
        }
        return ((QName[])this.typeName)[0];
    }

    public abstract BeanT createInstance(UnmarshallingContext var1) throws IllegalAccessException, InvocationTargetException, InstantiationException, SAXException;

    public abstract boolean reset(BeanT var1, UnmarshallingContext var2) throws SAXException;

    public abstract String getId(BeanT var1, XMLSerializer var2) throws SAXException;

    public abstract void serializeBody(BeanT var1, XMLSerializer var2) throws SAXException, IOException, XMLStreamException;

    public abstract void serializeAttributes(BeanT var1, XMLSerializer var2) throws SAXException, IOException, XMLStreamException;

    public abstract void serializeRoot(BeanT var1, XMLSerializer var2) throws SAXException, IOException, XMLStreamException;

    public abstract void serializeURIs(BeanT var1, XMLSerializer var2) throws SAXException;

    public abstract Loader getLoader(JAXBContextImpl var1, boolean var2);

    public abstract Transducer<BeanT> getTransducer();

    protected void link(JAXBContextImpl jAXBContextImpl) {
    }

    public void wrapUp() {
    }

    protected final void setLifecycleFlags() {
        try {
            Class<BeanT> clazz = this.jaxbType;
            if (this.lcm == null) {
                this.lcm = new LifecycleMethods();
            }
            while (clazz != null) {
                for (Method method : clazz.getDeclaredMethods()) {
                    String string = method.getName();
                    if (this.lcm.beforeUnmarshal == null && string.equals("beforeUnmarshal") && this.match(method, unmarshalEventParams)) {
                        this.cacheLifecycleMethod(method, (short)8);
                    }
                    if (this.lcm.afterUnmarshal == null && string.equals("afterUnmarshal") && this.match(method, unmarshalEventParams)) {
                        this.cacheLifecycleMethod(method, (short)16);
                    }
                    if (this.lcm.beforeMarshal == null && string.equals("beforeMarshal") && this.match(method, marshalEventParams)) {
                        this.cacheLifecycleMethod(method, (short)32);
                    }
                    if (this.lcm.afterMarshal != null || !string.equals("afterMarshal") || !this.match(method, marshalEventParams)) continue;
                    this.cacheLifecycleMethod(method, (short)64);
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (SecurityException securityException) {
            logger.log(Level.WARNING, Messages.UNABLE_TO_DISCOVER_EVENTHANDLER.format(this.jaxbType.getName(), securityException));
        }
    }

    private boolean match(Method method, Class[] classArray) {
        return Arrays.equals(method.getParameterTypes(), classArray);
    }

    private void cacheLifecycleMethod(Method method, short s) {
        if (this.lcm == null) {
            this.lcm = new LifecycleMethods();
        }
        method.setAccessible(true);
        this.flag = (short)(this.flag | s);
        switch (s) {
            case 8: {
                this.lcm.beforeUnmarshal = method;
                break;
            }
            case 16: {
                this.lcm.afterUnmarshal = method;
                break;
            }
            case 32: {
                this.lcm.beforeMarshal = method;
                break;
            }
            case 64: {
                this.lcm.afterMarshal = method;
            }
        }
    }

    public final LifecycleMethods getLifecycleMethods() {
        return this.lcm;
    }

    public final void invokeBeforeUnmarshalMethod(UnmarshallerImpl unmarshallerImpl, Object object, Object object2) throws SAXException {
        Method method = this.getLifecycleMethods().beforeUnmarshal;
        this.invokeUnmarshallCallback(method, object, unmarshallerImpl, object2);
    }

    public final void invokeAfterUnmarshalMethod(UnmarshallerImpl unmarshallerImpl, Object object, Object object2) throws SAXException {
        Method method = this.getLifecycleMethods().afterUnmarshal;
        this.invokeUnmarshallCallback(method, object, unmarshallerImpl, object2);
    }

    private void invokeUnmarshallCallback(Method method, Object object, UnmarshallerImpl unmarshallerImpl, Object object2) throws SAXException {
        try {
            method.invoke(object, unmarshallerImpl, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            UnmarshallingContext.getInstance().handleError(illegalAccessException, false);
        }
        catch (InvocationTargetException invocationTargetException) {
            UnmarshallingContext.getInstance().handleError(invocationTargetException, false);
        }
    }
}

