/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import sun.awt.AppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Region {
    private static final Object UI_TO_REGION_MAP_KEY = new Object();
    private static final Object LOWER_CASE_NAME_MAP_KEY = new Object();
    public static final Region ARROW_BUTTON = new Region("ArrowButton", false);
    public static final Region BUTTON = new Region("Button", false);
    public static final Region CHECK_BOX = new Region("CheckBox", false);
    public static final Region CHECK_BOX_MENU_ITEM = new Region("CheckBoxMenuItem", false);
    public static final Region COLOR_CHOOSER = new Region("ColorChooser", false);
    public static final Region COMBO_BOX = new Region("ComboBox", false);
    public static final Region DESKTOP_PANE = new Region("DesktopPane", false);
    public static final Region DESKTOP_ICON = new Region("DesktopIcon", false);
    public static final Region EDITOR_PANE = new Region("EditorPane", false);
    public static final Region FILE_CHOOSER = new Region("FileChooser", false);
    public static final Region FORMATTED_TEXT_FIELD = new Region("FormattedTextField", false);
    public static final Region INTERNAL_FRAME = new Region("InternalFrame", false);
    public static final Region INTERNAL_FRAME_TITLE_PANE = new Region("InternalFrameTitlePane", false);
    public static final Region LABEL = new Region("Label", false);
    public static final Region LIST = new Region("List", false);
    public static final Region MENU = new Region("Menu", false);
    public static final Region MENU_BAR = new Region("MenuBar", false);
    public static final Region MENU_ITEM = new Region("MenuItem", false);
    public static final Region MENU_ITEM_ACCELERATOR = new Region("MenuItemAccelerator", true);
    public static final Region OPTION_PANE = new Region("OptionPane", false);
    public static final Region PANEL = new Region("Panel", false);
    public static final Region PASSWORD_FIELD = new Region("PasswordField", false);
    public static final Region POPUP_MENU = new Region("PopupMenu", false);
    public static final Region POPUP_MENU_SEPARATOR = new Region("PopupMenuSeparator", false);
    public static final Region PROGRESS_BAR = new Region("ProgressBar", false);
    public static final Region RADIO_BUTTON = new Region("RadioButton", false);
    public static final Region RADIO_BUTTON_MENU_ITEM = new Region("RadioButtonMenuItem", false);
    public static final Region ROOT_PANE = new Region("RootPane", false);
    public static final Region SCROLL_BAR = new Region("ScrollBar", false);
    public static final Region SCROLL_BAR_TRACK = new Region("ScrollBarTrack", true);
    public static final Region SCROLL_BAR_THUMB = new Region("ScrollBarThumb", true);
    public static final Region SCROLL_PANE = new Region("ScrollPane", false);
    public static final Region SEPARATOR = new Region("Separator", false);
    public static final Region SLIDER = new Region("Slider", false);
    public static final Region SLIDER_TRACK = new Region("SliderTrack", true);
    public static final Region SLIDER_THUMB = new Region("SliderThumb", true);
    public static final Region SPINNER = new Region("Spinner", false);
    public static final Region SPLIT_PANE = new Region("SplitPane", false);
    public static final Region SPLIT_PANE_DIVIDER = new Region("SplitPaneDivider", true);
    public static final Region TABBED_PANE = new Region("TabbedPane", false);
    public static final Region TABBED_PANE_TAB = new Region("TabbedPaneTab", true);
    public static final Region TABBED_PANE_TAB_AREA = new Region("TabbedPaneTabArea", true);
    public static final Region TABBED_PANE_CONTENT = new Region("TabbedPaneContent", true);
    public static final Region TABLE = new Region("Table", false);
    public static final Region TABLE_HEADER = new Region("TableHeader", false);
    public static final Region TEXT_AREA = new Region("TextArea", false);
    public static final Region TEXT_FIELD = new Region("TextField", false);
    public static final Region TEXT_PANE = new Region("TextPane", false);
    public static final Region TOGGLE_BUTTON = new Region("ToggleButton", false);
    public static final Region TOOL_BAR = new Region("ToolBar", false);
    public static final Region TOOL_BAR_CONTENT = new Region("ToolBarContent", true);
    public static final Region TOOL_BAR_DRAG_WINDOW = new Region("ToolBarDragWindow", false);
    public static final Region TOOL_TIP = new Region("ToolTip", false);
    public static final Region TOOL_BAR_SEPARATOR = new Region("ToolBarSeparator", false);
    public static final Region TREE = new Region("Tree", false);
    public static final Region TREE_CELL = new Region("TreeCell", true);
    public static final Region VIEWPORT = new Region("Viewport", false);
    private final String name;
    private final boolean subregion;

    private static Map<String, Region> getUItoRegionMap() {
        AppContext appContext = AppContext.getAppContext();
        HashMap<String, Region> hashMap = (HashMap<String, Region>)appContext.get(UI_TO_REGION_MAP_KEY);
        if (hashMap == null) {
            hashMap = new HashMap<String, Region>();
            hashMap.put("ArrowButtonUI", ARROW_BUTTON);
            hashMap.put("ButtonUI", BUTTON);
            hashMap.put("CheckBoxUI", CHECK_BOX);
            hashMap.put("CheckBoxMenuItemUI", CHECK_BOX_MENU_ITEM);
            hashMap.put("ColorChooserUI", COLOR_CHOOSER);
            hashMap.put("ComboBoxUI", COMBO_BOX);
            hashMap.put("DesktopPaneUI", DESKTOP_PANE);
            hashMap.put("DesktopIconUI", DESKTOP_ICON);
            hashMap.put("EditorPaneUI", EDITOR_PANE);
            hashMap.put("FileChooserUI", FILE_CHOOSER);
            hashMap.put("FormattedTextFieldUI", FORMATTED_TEXT_FIELD);
            hashMap.put("InternalFrameUI", INTERNAL_FRAME);
            hashMap.put("InternalFrameTitlePaneUI", INTERNAL_FRAME_TITLE_PANE);
            hashMap.put("LabelUI", LABEL);
            hashMap.put("ListUI", LIST);
            hashMap.put("MenuUI", MENU);
            hashMap.put("MenuBarUI", MENU_BAR);
            hashMap.put("MenuItemUI", MENU_ITEM);
            hashMap.put("OptionPaneUI", OPTION_PANE);
            hashMap.put("PanelUI", PANEL);
            hashMap.put("PasswordFieldUI", PASSWORD_FIELD);
            hashMap.put("PopupMenuUI", POPUP_MENU);
            hashMap.put("PopupMenuSeparatorUI", POPUP_MENU_SEPARATOR);
            hashMap.put("ProgressBarUI", PROGRESS_BAR);
            hashMap.put("RadioButtonUI", RADIO_BUTTON);
            hashMap.put("RadioButtonMenuItemUI", RADIO_BUTTON_MENU_ITEM);
            hashMap.put("RootPaneUI", ROOT_PANE);
            hashMap.put("ScrollBarUI", SCROLL_BAR);
            hashMap.put("ScrollPaneUI", SCROLL_PANE);
            hashMap.put("SeparatorUI", SEPARATOR);
            hashMap.put("SliderUI", SLIDER);
            hashMap.put("SpinnerUI", SPINNER);
            hashMap.put("SplitPaneUI", SPLIT_PANE);
            hashMap.put("TabbedPaneUI", TABBED_PANE);
            hashMap.put("TableUI", TABLE);
            hashMap.put("TableHeaderUI", TABLE_HEADER);
            hashMap.put("TextAreaUI", TEXT_AREA);
            hashMap.put("TextFieldUI", TEXT_FIELD);
            hashMap.put("TextPaneUI", TEXT_PANE);
            hashMap.put("ToggleButtonUI", TOGGLE_BUTTON);
            hashMap.put("ToolBarUI", TOOL_BAR);
            hashMap.put("ToolTipUI", TOOL_TIP);
            hashMap.put("ToolBarSeparatorUI", TOOL_BAR_SEPARATOR);
            hashMap.put("TreeUI", TREE);
            hashMap.put("ViewportUI", VIEWPORT);
            appContext.put(UI_TO_REGION_MAP_KEY, hashMap);
        }
        return hashMap;
    }

    private static Map<Region, String> getLowerCaseNameMap() {
        AppContext appContext = AppContext.getAppContext();
        HashMap hashMap = (HashMap)appContext.get(LOWER_CASE_NAME_MAP_KEY);
        if (hashMap == null) {
            hashMap = new HashMap();
            appContext.put(LOWER_CASE_NAME_MAP_KEY, hashMap);
        }
        return hashMap;
    }

    static Region getRegion(JComponent jComponent) {
        return Region.getUItoRegionMap().get(jComponent.getUIClassID());
    }

    static void registerUIs(UIDefaults uIDefaults) {
        for (String string : Region.getUItoRegionMap().keySet()) {
            uIDefaults.put(string, "javax.swing.plaf.synth.SynthLookAndFeel");
        }
    }

    private Region(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("You must specify a non-null name");
        }
        this.name = string;
        this.subregion = bl;
    }

    protected Region(String string, String string2, boolean bl) {
        this(string, bl);
        if (string2 != null) {
            Region.getUItoRegionMap().put(string2, this);
        }
    }

    public boolean isSubregion() {
        return this.subregion;
    }

    public String getName() {
        return this.name;
    }

    String getLowerCaseName() {
        Map<Region, String> map = Region.getLowerCaseNameMap();
        String string = map.get(this);
        if (string == null) {
            string = this.name.toLowerCase(Locale.ENGLISH);
            map.put(this, string);
        }
        return string;
    }

    public String toString() {
        return this.name;
    }
}

