/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.algorithm;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.internal.fastinfoset.algorithm.IntegerEncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class LongEncodingAlgorithm
extends IntegerEncodingAlgorithm {
    public int getPrimtiveLengthFromOctetLength(int n) throws EncodingAlgorithmException {
        if (n % 8 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfLong", new Object[]{8}));
        }
        return n / 8;
    }

    public int getOctetLengthFromPrimitiveLength(int n) {
        return n * 8;
    }

    public final Object decodeFromBytes(byte[] byArray, int n, int n2) throws EncodingAlgorithmException {
        long[] lArray = new long[this.getPrimtiveLengthFromOctetLength(n2)];
        this.decodeFromBytesToLongArray(lArray, 0, byArray, n, n2);
        return lArray;
    }

    public final Object decodeFromInputStream(InputStream inputStream) throws IOException {
        return this.decodeFromInputStreamToIntArray(inputStream);
    }

    public void encodeToOutputStream(Object object, OutputStream outputStream) throws IOException {
        if (!(object instanceof long[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotLongArray"));
        }
        long[] lArray = (long[])object;
        this.encodeToOutputStreamFromLongArray(lArray, outputStream);
    }

    public Object convertFromCharacters(char[] cArray, int n, int n2) {
        final CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        final ArrayList arrayList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(charBuffer, new BuiltInEncodingAlgorithm.WordListener(){

            public void word(int n, int n2) {
                String string = ((Object)charBuffer.subSequence(n, n2)).toString();
                arrayList.add(Long.valueOf(string));
            }
        });
        return this.generateArrayFromList(arrayList);
    }

    public void convertToCharacters(Object object, StringBuffer stringBuffer) {
        if (!(object instanceof long[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotLongArray"));
        }
        long[] lArray = (long[])object;
        this.convertToCharactersFromLongArray(lArray, stringBuffer);
    }

    public final void decodeFromBytesToLongArray(long[] lArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n3 / 8;
        for (int i = 0; i < n4; ++i) {
            lArray[n++] = (long)(byArray[n2++] & 0xFF) << 56 | (long)(byArray[n2++] & 0xFF) << 48 | (long)(byArray[n2++] & 0xFF) << 40 | (long)(byArray[n2++] & 0xFF) << 32 | (long)(byArray[n2++] & 0xFF) << 24 | (long)(byArray[n2++] & 0xFF) << 16 | (long)(byArray[n2++] & 0xFF) << 8 | (long)(byArray[n2++] & 0xFF);
        }
    }

    public final long[] decodeFromInputStreamToIntArray(InputStream inputStream) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        byte[] byArray = new byte[8];
        while (true) {
            int n;
            if ((n = inputStream.read(byArray)) != 8) {
                if (n == -1) break;
                while (n != 8) {
                    int n2 = inputStream.read(byArray, n, 8 - n);
                    if (n2 == -1) {
                        throw new EOFException();
                    }
                    n += n2;
                }
            }
            long l = ((long)byArray[0] << 56) + ((long)(byArray[1] & 0xFF) << 48) + ((long)(byArray[2] & 0xFF) << 40) + ((long)(byArray[3] & 0xFF) << 32) + ((long)(byArray[4] & 0xFF) << 24) + (long)((byArray[5] & 0xFF) << 16) + (long)((byArray[6] & 0xFF) << 8) + (long)((byArray[7] & 0xFF) << 0);
            arrayList.add(l);
        }
        return this.generateArrayFromList(arrayList);
    }

    public final void encodeToOutputStreamFromLongArray(long[] lArray, OutputStream outputStream) throws IOException {
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            outputStream.write((int)(l >>> 56 & 0xFFL));
            outputStream.write((int)(l >>> 48 & 0xFFL));
            outputStream.write((int)(l >>> 40 & 0xFFL));
            outputStream.write((int)(l >>> 32 & 0xFFL));
            outputStream.write((int)(l >>> 24 & 0xFFL));
            outputStream.write((int)(l >>> 16 & 0xFFL));
            outputStream.write((int)(l >>> 8 & 0xFFL));
            outputStream.write((int)(l & 0xFFL));
        }
    }

    public final void encodeToBytes(Object object, int n, int n2, byte[] byArray, int n3) {
        this.encodeToBytesFromLongArray((long[])object, n, n2, byArray, n3);
    }

    public final void encodeToBytesFromLongArray(long[] lArray, int n, int n2, byte[] byArray, int n3) {
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            long l = lArray[i];
            byArray[n3++] = (byte)(l >>> 56 & 0xFFL);
            byArray[n3++] = (byte)(l >>> 48 & 0xFFL);
            byArray[n3++] = (byte)(l >>> 40 & 0xFFL);
            byArray[n3++] = (byte)(l >>> 32 & 0xFFL);
            byArray[n3++] = (byte)(l >>> 24 & 0xFFL);
            byArray[n3++] = (byte)(l >>> 16 & 0xFFL);
            byArray[n3++] = (byte)(l >>> 8 & 0xFFL);
            byArray[n3++] = (byte)(l & 0xFFL);
        }
    }

    public final void convertToCharactersFromLongArray(long[] lArray, StringBuffer stringBuffer) {
        int n = lArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(Long.toString(lArray[i]));
            if (i == n) continue;
            stringBuffer.append(' ');
        }
    }

    public final long[] generateArrayFromList(List list) {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = (Long)list.get(i);
        }
        return lArray;
    }
}

