/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.io.File;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.SystemManager;

public class InfoDir {
    private InfoDir() {
    }

    private static String copySourceFile(String fileName) {
        InstallData data = InstallData.getInstance();
        File jarFile = data.getJarFilePath();
        String destFile = null;
        if (jarFile != null) {
            String sourceDir = jarFile.getParent();
            File sourceFileFile = new File(sourceDir, fileName);
            String sourceFile = sourceFileFile.getPath();
            File destDir = new File(data.getInstallDefaultDir(), data.getProductDir());
            File destFileFile = new File(destDir, fileName);
            destFile = destFileFile.getPath();
            boolean success = SystemManager.copy(sourceFile, destFile);
        }
        return destFile;
    }

    private static void copyInstallDirectoryWithExtension(File destBaseDir, String subDirName, String fileExtension) {
        InstallData data = InstallData.getInstance();
        File sourceDir = data.getInfoRoot(subDirName);
        if (sourceDir != null) {
            File destDir = new File(destBaseDir, subDirName);
            destDir.mkdir();
            SystemManager.copyAllFiles(sourceDir, destDir, fileExtension);
        }
    }

    private static void copyInstallDirectoryWithExtension(File destBaseDir, String subDirName, String fileExtension, String unixRights) {
        InstallData data = InstallData.getInstance();
        File sourceDir = data.getInfoRoot(subDirName);
        if (sourceDir != null) {
            File destDir = new File(destBaseDir, subDirName);
            destDir.mkdir();
            SystemManager.copyAllFiles(sourceDir, destDir, fileExtension);
            SystemManager.setUnixPrivilegesDirectory(destDir, fileExtension, unixRights);
        }
    }

    private static void copyInstallDirectoryDoubleSubdir(File destBaseDir, String dir1, String dir2) {
        InstallData data = InstallData.getInstance();
        File sourceDir1 = data.getInfoRoot(dir1);
        File sourceDir = new File(sourceDir1, dir2);
        destBaseDir.mkdir();
        File destDir1 = new File(destBaseDir, dir1);
        destDir1.mkdir();
        File destDir = new File(destDir1, dir2);
        destDir.mkdir();
        SystemManager.copyAllFiles(sourceDir, destDir);
    }

    private static File createUninstallDir() {
        InstallData data = InstallData.getInstance();
        File baseDir = new File(data.getInstallDefaultDir(), data.getProductDir());
        baseDir = new File(baseDir, data.getUninstallDirName());
        baseDir.mkdir();
        return baseDir;
    }

    private static void copyGetUidSoFile(File dir) {
        InstallData data = InstallData.getInstance();
        String uidFileSource = data.getGetUidPath();
        if (uidFileSource != null) {
            String fileName = "getuid.so";
            File destFile = new File(dir, fileName);
            String uidFileDest = destFile.getPath();
            boolean success = SystemManager.copy(uidFileSource, uidFileDest);
            data.setGetUidPath(uidFileDest);
        }
    }

    private static void copyJreFile(File dir) {
        InstallData data = InstallData.getInstance();
        String jrefilename = System.getProperty("JRE_FILE");
        if (jrefilename != null) {
            File jreFile = new File(jrefilename);
            if (!jreFile.exists()) {
                jreFile = new File(data.getPackagePath(), jrefilename);
            }
            if (jreFile.exists()) {
                String jreFileSource = jreFile.getPath();
                File destDir = new File(dir, "jre");
                destDir.mkdir();
                String onlyFileName = jreFile.getName();
                File destFile = new File(destDir, onlyFileName);
                if (!destFile.exists()) {
                    String jreFileDest = destFile.getPath();
                    boolean success = SystemManager.copy(jreFileSource, jreFileDest);
                }
            }
        }
    }

    private static void moveAdminFiles(File dir) {
        boolean success;
        File destFile;
        String fileName;
        File sourceFile;
        InstallData data = InstallData.getInstance();
        if (data.getAdminFileNameReloc() != null) {
            sourceFile = new File(data.getAdminFileNameReloc());
            fileName = sourceFile.getName();
            destFile = new File(dir, fileName);
            success = SystemManager.copy(sourceFile.getPath(), destFile.getPath());
            data.setAdminFileNameReloc(destFile.getPath());
            sourceFile.delete();
        }
        if (data.getAdminFileNameRelocNoDepends() != null) {
            sourceFile = new File(data.getAdminFileNameRelocNoDepends());
            fileName = sourceFile.getName();
            destFile = new File(dir, fileName);
            success = SystemManager.copy(sourceFile.getPath(), destFile.getPath());
            data.setAdminFileNameRelocNoDepends(destFile.getPath());
            sourceFile.delete();
        }
        if (data.getAdminFileNameNoReloc() != null) {
            sourceFile = new File(data.getAdminFileNameNoReloc());
            fileName = sourceFile.getName();
            destFile = new File(dir, fileName);
            success = SystemManager.copy(sourceFile.getPath(), destFile.getPath());
            data.setAdminFileNameNoReloc(destFile.getPath());
            sourceFile.delete();
        }
        if (data.getAdminFileNameNoRelocNoDepends() != null) {
            sourceFile = new File(data.getAdminFileNameNoRelocNoDepends());
            fileName = sourceFile.getName();
            destFile = new File(dir, fileName);
            success = SystemManager.copy(sourceFile.getPath(), destFile.getPath());
            data.setAdminFileNameNoRelocNoDepends(destFile.getPath());
            sourceFile.delete();
        }
    }

    private static void createInfoFile(File dir) {
        Vector<String> fileContent = new Vector<String>();
        String line = null;
        InstallData data = InstallData.getInstance();
        line = "PackagePath=" + data.getPackagePath();
        fileContent.add(line);
        line = "InstallationPrivileges=" + data.getInstallationPrivileges();
        fileContent.add(line);
        line = "AdminFileReloc=" + data.getAdminFileNameReloc();
        fileContent.add(line);
        line = "AdminFileRelocNoDepends=" + data.getAdminFileNameRelocNoDepends();
        fileContent.add(line);
        line = "AdminFileNoReloc=" + data.getAdminFileNameNoReloc();
        fileContent.add(line);
        line = "AdminFileNoRelocNoDepends=" + data.getAdminFileNameNoRelocNoDepends();
        fileContent.add(line);
        line = "InstallationDir=" + data.getInstallDir();
        fileContent.add(line);
        line = "DatabasePath=" + data.getDatabasePath();
        fileContent.add(line);
        line = "GetUidFile=" + data.getGetUidPath();
        fileContent.add(line);
        String infoFileName = "infoFile";
        File infoFile = new File(dir, infoFileName);
        SystemManager.saveCharFileVector(infoFile.getPath(), fileContent);
    }

    private static void removeSpecialFiles() {
        InstallData data = InstallData.getInstance();
        File jarFile = data.getJarFilePath();
        SystemManager.deleteFile(jarFile);
        String jarFilePath = jarFile.getParent();
        File setupFile = new File(jarFilePath, "setup");
        SystemManager.deleteFile(setupFile);
        if (!data.getAdminFileNameReloc().equals("null")) {
            SystemManager.deleteFile(new File(data.getAdminFileNameReloc()));
        }
        if (!data.getAdminFileNameRelocNoDepends().equals("null")) {
            SystemManager.deleteFile(new File(data.getAdminFileNameRelocNoDepends()));
        }
        if (!data.getAdminFileNameNoReloc().equals("null")) {
            SystemManager.deleteFile(new File(data.getAdminFileNameNoReloc()));
        }
        if (!data.getAdminFileNameNoRelocNoDepends().equals("null")) {
            SystemManager.deleteFile(new File(data.getAdminFileNameNoRelocNoDepends()));
        }
        if (!data.getGetUidPath().equals("null")) {
            SystemManager.deleteFile(new File(data.getGetUidPath()));
        }
    }

    private static void removeInforootSubdir(String dir1, String dir2) {
        InstallData data = InstallData.getInstance();
        File subdir1 = data.getInfoRoot(dir1);
        File subdir2 = new File(subdir1, dir2);
        if (subdir2 != null && subdir2.exists()) {
            SystemManager.removeDirectory(subdir2);
        }
    }

    private static void removeInforootSubdir(String dir) {
        InstallData data = InstallData.getInstance();
        File subdir = data.getInfoRoot(dir);
        if (subdir != null && subdir.exists()) {
            SystemManager.removeDirectory(subdir);
        }
    }

    private static void removeInforoot() {
        InstallData data = InstallData.getInstance();
        SystemManager.removeDirectory(data.getInfoRoot());
    }

    public static void prepareUninstallation() {
        InstallData data = InstallData.getInstance();
        File destDir = new File(data.getInstallDefaultDir(), data.getProductDir());
        boolean directoryExists = true;
        if (!destDir.exists()) {
            try {
                directoryExists = SystemManager.create_directory(destDir.getPath());
            }
            catch (SecurityException ex) {
                String message = ResourceManager.getString("String_ChooseDirectory_No_Write_Access") + ": " + destDir.getPath();
                String title = ResourceManager.getString("String_Error");
                Informer.showErrorMessage(message, title);
            }
        }
        if (directoryExists) {
            String setupPath = InfoDir.copySourceFile("setup");
            SystemManager.setUnixPrivileges(setupPath, "775");
            File jarFile = data.getJarFilePath();
            InfoDir.copySourceFile(jarFile.getName());
            File uninstallDir = InfoDir.createUninstallDir();
            InfoDir.copyInstallDirectoryWithExtension(uninstallDir, "xpd", "xpd");
            InfoDir.copyInstallDirectoryWithExtension(uninstallDir, "html", "html");
            InfoDir.copyInstallDirectoryWithExtension(uninstallDir, "images", "gif");
            InfoDir.copyInstallDirectoryDoubleSubdir(uninstallDir, "html", "images");
            InfoDir.copyGetUidSoFile(uninstallDir);
            InfoDir.copyJreFile(uninstallDir);
            InfoDir.moveAdminFiles(uninstallDir);
            InfoDir.createInfoFile(uninstallDir);
        }
    }

    public static void removeUninstallationFiles() {
        InfoDir.removeSpecialFiles();
        InfoDir.removeInforootSubdir("html", "images");
        InfoDir.removeInforootSubdir("html");
        InfoDir.removeInforootSubdir("xpd");
        InfoDir.removeInforootSubdir("images");
        InfoDir.removeInforootSubdir("jre");
        InfoDir.removeInforoot();
    }
}

