/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.util.ValueArray;
import com.sun.xml.internal.fastinfoset.util.ValueArrayResourceException;

public class QualifiedNameArray
extends ValueArray {
    public QualifiedName[] _array;
    private QualifiedNameArray _readOnlyArray;

    public QualifiedNameArray(int n, int n2) {
        this._array = new QualifiedName[n];
        this._maximumCapacity = n2;
    }

    public QualifiedNameArray() {
        this(10, Integer.MAX_VALUE);
    }

    public final void clear() {
        this._size = this._readOnlyArraySize;
    }

    public final QualifiedName[] getArray() {
        return this._array;
    }

    public final void setReadOnlyArray(ValueArray valueArray, boolean bl) {
        if (!(valueArray instanceof QualifiedNameArray)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{valueArray}));
        }
        this.setReadOnlyArray((QualifiedNameArray)valueArray, bl);
    }

    public final void setReadOnlyArray(QualifiedNameArray qualifiedNameArray, boolean bl) {
        if (qualifiedNameArray != null) {
            this._readOnlyArray = qualifiedNameArray;
            this._readOnlyArraySize = qualifiedNameArray.getSize();
            if (bl) {
                this.clear();
            }
            this._array = this.getCompleteArray();
            this._size = this._readOnlyArraySize;
        }
    }

    public final QualifiedName[] getCompleteArray() {
        if (this._readOnlyArray == null) {
            return this._array;
        }
        QualifiedName[] qualifiedNameArray = this._readOnlyArray.getCompleteArray();
        QualifiedName[] qualifiedNameArray2 = new QualifiedName[this._readOnlyArraySize + this._array.length];
        System.arraycopy(qualifiedNameArray, 0, qualifiedNameArray2, 0, this._readOnlyArraySize);
        return qualifiedNameArray2;
    }

    public final QualifiedName getNext() {
        return this._size == this._array.length ? null : this._array[this._size];
    }

    public final void add(QualifiedName qualifiedName) {
        if (this._size == this._array.length) {
            this.resize();
        }
        this._array[this._size++] = qualifiedName;
    }

    protected final void resize() {
        if (this._size == this._maximumCapacity) {
            throw new ValueArrayResourceException(CommonResourceBundle.getInstance().getString("message.arrayMaxCapacity"));
        }
        int n = this._size * 3 / 2 + 1;
        if (n > this._maximumCapacity) {
            n = this._maximumCapacity;
        }
        QualifiedName[] qualifiedNameArray = new QualifiedName[n];
        System.arraycopy(this._array, 0, qualifiedNameArray, 0, this._size);
        this._array = qualifiedNameArray;
    }
}

