/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.BIPUSH;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.CompoundInstruction;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionConstants;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.LDC;
import com.sun.org.apache.bcel.internal.generic.LDC2_W;
import com.sun.org.apache.bcel.internal.generic.SIPUSH;
import com.sun.org.apache.bcel.internal.generic.VariableLengthInstruction;

public final class PUSH
implements CompoundInstruction,
VariableLengthInstruction,
InstructionConstants {
    private Instruction instruction;

    public PUSH(ConstantPoolGen constantPoolGen, int n) {
        this.instruction = n >= -1 && n <= 5 ? INSTRUCTIONS[3 + n] : (n >= -128 && n <= 127 ? new BIPUSH((byte)n) : (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE ? new SIPUSH((short)n) : new LDC(constantPoolGen.addInteger(n))));
    }

    public PUSH(ConstantPoolGen constantPoolGen, boolean bl) {
        this.instruction = INSTRUCTIONS[3 + (bl ? 1 : 0)];
    }

    public PUSH(ConstantPoolGen constantPoolGen, float f) {
        this.instruction = (double)f == 0.0 ? FCONST_0 : ((double)f == 1.0 ? FCONST_1 : ((double)f == 2.0 ? FCONST_2 : new LDC(constantPoolGen.addFloat(f))));
    }

    public PUSH(ConstantPoolGen constantPoolGen, long l) {
        this.instruction = l == 0L ? LCONST_0 : (l == 1L ? LCONST_1 : new LDC2_W(constantPoolGen.addLong(l)));
    }

    public PUSH(ConstantPoolGen constantPoolGen, double d) {
        this.instruction = d == 0.0 ? DCONST_0 : (d == 1.0 ? DCONST_1 : new LDC2_W(constantPoolGen.addDouble(d)));
    }

    public PUSH(ConstantPoolGen constantPoolGen, String string) {
        this.instruction = string == null ? ACONST_NULL : new LDC(constantPoolGen.addString(string));
    }

    public PUSH(ConstantPoolGen constantPoolGen, Number number) {
        if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (int)number.intValue()).instruction;
        } else if (number instanceof Double) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (double)number.doubleValue()).instruction;
        } else if (number instanceof Float) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (float)number.floatValue()).instruction;
        } else if (number instanceof Long) {
            this.instruction = new PUSH((ConstantPoolGen)constantPoolGen, (long)number.longValue()).instruction;
        } else {
            throw new ClassGenException("What's this: " + number);
        }
    }

    public PUSH(ConstantPoolGen constantPoolGen, Character c) {
        this(constantPoolGen, (int)c.charValue());
    }

    public PUSH(ConstantPoolGen constantPoolGen, Boolean bl) {
        this(constantPoolGen, (boolean)bl);
    }

    public final InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public String toString() {
        return this.instruction.toString() + " (PUSH)";
    }
}

