/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;

class NameGenerator {
    private Map valueToName = new IdentityHashMap();
    private Map nameToCount = new HashMap();

    public void clear() {
        this.valueToName.clear();
        this.nameToCount.clear();
    }

    public static String unqualifiedClassName(Class clazz) {
        if (clazz.isArray()) {
            return NameGenerator.unqualifiedClassName(clazz.getComponentType()) + "Array";
        }
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public String instanceName(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Class) {
            return NameGenerator.unqualifiedClassName((Class)object);
        }
        String string = (String)this.valueToName.get(object);
        if (string != null) {
            return string;
        }
        Class<?> clazz = object.getClass();
        String string2 = NameGenerator.unqualifiedClassName(clazz);
        Object v = this.nameToCount.get(string2);
        int n = v == null ? 0 : (Integer)v + 1;
        this.nameToCount.put(string2, new Integer(n));
        string = string2 + n;
        this.valueToName.put(object, string);
        return string;
    }
}

