/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.W3CWsaClientTube;
import com.sun.xml.internal.ws.addressing.v200408.MemberSubmissionWsaClientTube;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.client.ClientPipelineHook;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.ClientSchemaValidationTube;
import com.sun.xml.internal.ws.developer.SchemaValidationFeature;
import com.sun.xml.internal.ws.handler.ClientLogicalHandlerTube;
import com.sun.xml.internal.ws.handler.ClientMessageHandlerTube;
import com.sun.xml.internal.ws.handler.ClientSOAPHandlerTube;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.protocol.soap.ClientMUTube;
import com.sun.xml.internal.ws.transport.DeferredTransportPipe;
import com.sun.xml.internal.ws.util.pipe.DumpTube;
import java.io.PrintStream;
import javax.xml.ws.soap.SOAPBinding;

public class ClientTubeAssemblerContext {
    @NotNull
    private final EndpointAddress address;
    @Nullable
    private final WSDLPort wsdlModel;
    @Nullable
    private final SEIModel seiModel;
    @NotNull
    private final WSService rootOwner;
    @NotNull
    private final WSBinding binding;
    @NotNull
    private final Container container;
    @NotNull
    private Codec codec;

    public ClientTubeAssemblerContext(@NotNull EndpointAddress endpointAddress, @Nullable WSDLPort wSDLPort, @NotNull WSService wSService, @NotNull WSBinding wSBinding) {
        this(endpointAddress, wSDLPort, wSService, wSBinding, Container.NONE);
    }

    public ClientTubeAssemblerContext(@NotNull EndpointAddress endpointAddress, @Nullable WSDLPort wSDLPort, @NotNull WSService wSService, @NotNull WSBinding wSBinding, @NotNull Container container) {
        this(endpointAddress, wSDLPort, wSService, wSBinding, container, ((BindingImpl)wSBinding).createCodec());
    }

    public ClientTubeAssemblerContext(@NotNull EndpointAddress endpointAddress, @Nullable WSDLPort wSDLPort, @NotNull WSService wSService, @NotNull WSBinding wSBinding, @NotNull Container container, Codec codec) {
        this(endpointAddress, wSDLPort, wSService, wSBinding, container, codec, null);
    }

    public ClientTubeAssemblerContext(@NotNull EndpointAddress endpointAddress, @Nullable WSDLPort wSDLPort, @NotNull WSService wSService, @NotNull WSBinding wSBinding, @NotNull Container container, Codec codec, SEIModel sEIModel) {
        this.address = endpointAddress;
        this.wsdlModel = wSDLPort;
        this.rootOwner = wSService;
        this.binding = wSBinding;
        this.container = container;
        this.codec = codec;
        this.seiModel = sEIModel;
    }

    @NotNull
    public EndpointAddress getAddress() {
        return this.address;
    }

    @Nullable
    public WSDLPort getWsdlModel() {
        return this.wsdlModel;
    }

    @NotNull
    public WSService getService() {
        return this.rootOwner;
    }

    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    @Nullable
    public SEIModel getSEIModel() {
        return this.seiModel;
    }

    public Container getContainer() {
        return this.container;
    }

    public Tube createDumpTube(String string, PrintStream printStream, Tube tube) {
        return new DumpTube(string, printStream, tube);
    }

    @NotNull
    public Tube createSecurityTube(@NotNull Tube tube) {
        ClientPipelineHook clientPipelineHook = this.container.getSPI(ClientPipelineHook.class);
        if (clientPipelineHook != null) {
            ClientPipeAssemblerContext clientPipeAssemblerContext = new ClientPipeAssemblerContext(this.address, this.wsdlModel, this.rootOwner, this.binding, this.container);
            return PipeAdapter.adapt(clientPipelineHook.createSecurityPipe(clientPipeAssemblerContext, PipeAdapter.adapt(tube)));
        }
        return tube;
    }

    public Tube createWsaTube(Tube tube) {
        if (this.binding instanceof SOAPBinding && AddressingVersion.isEnabled(this.binding) && this.wsdlModel != null) {
            if (AddressingVersion.fromBinding(this.binding) == AddressingVersion.MEMBER) {
                return new MemberSubmissionWsaClientTube(this.wsdlModel, this.binding, tube);
            }
            return new W3CWsaClientTube(this.wsdlModel, this.binding, tube);
        }
        return tube;
    }

    public Tube createHandlerTube(Tube tube) {
        HandlerTube handlerTube = null;
        if (this.binding instanceof SOAPBinding) {
            ClientMessageHandlerTube clientMessageHandlerTube;
            handlerTube = clientMessageHandlerTube = new ClientMessageHandlerTube(this.seiModel, this.binding, this.wsdlModel, tube);
            tube = handlerTube;
            ClientSOAPHandlerTube clientSOAPHandlerTube = new ClientSOAPHandlerTube(this.binding, tube, handlerTube);
            handlerTube = clientSOAPHandlerTube;
            tube = handlerTube;
        }
        return new ClientLogicalHandlerTube(this.binding, tube, handlerTube);
    }

    public Tube createClientMUTube(Tube tube) {
        if (this.binding instanceof SOAPBinding) {
            return new ClientMUTube(this.binding, tube);
        }
        return tube;
    }

    public Tube createValidationTube(Tube tube) {
        if (this.binding instanceof SOAPBinding && this.binding.isFeatureEnabled(SchemaValidationFeature.class) && this.wsdlModel != null) {
            return new ClientSchemaValidationTube(this.binding, this.wsdlModel, tube);
        }
        return tube;
    }

    public Tube createTransportTube() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new DeferredTransportPipe(classLoader, this);
    }

    @NotNull
    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(@NotNull Codec codec) {
        this.codec = codec;
    }
}

