/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.resources.EncodingMessages;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeAttachmentSet
implements AttachmentSet {
    private final MimeMultipartParser mpp;
    private Map<String, Attachment> atts = new HashMap<String, Attachment>();

    public MimeAttachmentSet(MimeMultipartParser mimeMultipartParser) {
        this.mpp = mimeMultipartParser;
    }

    @Override
    @Nullable
    public Attachment get(String string) {
        Attachment attachment = this.atts.get(string);
        if (attachment != null) {
            return attachment;
        }
        try {
            attachment = this.mpp.getAttachmentPart(string);
            if (attachment != null) {
                this.atts.put(string, attachment);
            }
        }
        catch (IOException iOException) {
            throw new WebServiceException(EncodingMessages.NO_SUCH_CONTENT_ID(string), iOException);
        }
        return attachment;
    }

    @Override
    public boolean isEmpty() {
        return this.atts.size() <= 0 && this.mpp.getAttachmentParts().isEmpty();
    }

    @Override
    public void add(Attachment attachment) {
        this.atts.put(attachment.getContentId(), attachment);
    }

    @Override
    public Iterator<Attachment> iterator() {
        Map<String, Attachment> map = this.mpp.getAttachmentParts();
        for (Map.Entry<String, Attachment> entry : map.entrySet()) {
            if (this.atts.get(entry.getKey()) != null) continue;
            this.atts.put(entry.getKey(), entry.getValue());
        }
        return this.atts.values().iterator();
    }
}

