/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import com.sun.jmx.trace.Trace;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpSendServer
extends Thread {
    private int intervalRange = 5000;
    private Vector readyPool;
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpSendServer";
    boolean isBeingDestroyed = false;

    public SnmpSendServer(ThreadGroup threadGroup, SnmpQManager snmpQManager) {
        super(threadGroup, "SnmpSendServer");
        this.snmpq = snmpQManager;
        this.start();
    }

    public synchronized void stopSendServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (this.isTraceOn()) {
            this.trace("run", "Thread Started");
        }
        while (true) {
            try {
                do {
                    this.prepareAndSendRequest();
                } while (!this.isBeingDestroyed);
            }
            catch (Exception exception) {
                if (!this.isDebugOn()) continue;
                this.debug("run", "Exception in send server");
                this.debug("run", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (this.isDebugOn()) {
                    this.debug("run", "Exiting... Fatal error");
                }
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!this.isDebugOn()) continue;
                this.debug("run", "Out of memory");
                continue;
            }
            catch (Error error) {
                if (this.isDebugOn()) {
                    this.debug("run", error);
                }
                throw error;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (this.isTraceOn()) {
                this.trace("prepareAndSendRequest", "Blocking for inform requests");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
            if (this.isBeingDestroyed) {
                return;
            }
        } else if (this.isDebugOn()) {
            this.debug("prepareAndSendRequest", "Inform requests from a previous block left unprocessed. Will try again");
        }
        if (this.isTraceOn()) {
            this.trace("prepareAndSendRequest", "List of inform requests to send : " + this.reqListToString(this.readyPool));
        }
        SnmpSendServer snmpSendServer = this;
        synchronized (snmpSendServer) {
            if (this.readyPool.size() < 2) {
                this.fireRequestList(this.readyPool);
                return;
            }
            while (!this.readyPool.isEmpty()) {
                SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.readyPool.lastElement();
                if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
                    this.fireRequest(snmpInformRequest);
                }
                this.readyPool.removeElementAt(this.readyPool.size() - 1);
            }
            this.readyPool.removeAllElements();
        }
    }

    void fireRequest(SnmpInformRequest snmpInformRequest) {
        if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
            if (this.isTraceOn()) {
                this.trace("fireRequest", "Firing inform request directly. -> " + snmpInformRequest.getRequestId());
            }
            snmpInformRequest.action();
        }
    }

    void fireRequestList(Vector vector) {
        while (!vector.isEmpty()) {
            SnmpInformRequest snmpInformRequest = (SnmpInformRequest)vector.lastElement();
            if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
                this.fireRequest(snmpInformRequest);
            }
            vector.removeElementAt(vector.size() - 1);
        }
    }

    final String reqListToString(Vector vector) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(vector.size() * 100);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (SnmpInformRequest)enumeration.nextElement();
            stringBuffer.append("InformRequestId -> ");
            stringBuffer.append(((SnmpInformRequest)object).getRequestId());
            stringBuffer.append(" / Destination -> ");
            stringBuffer.append(((SnmpInformRequest)object).getAddress());
            stringBuffer.append(". ");
        }
        object = stringBuffer.toString();
        stringBuffer = null;
        return object;
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 256);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 256, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 256, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 256, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

