/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;

public class DuplicateAttributeVerifier {
    public static final int MAP_SIZE = 256;
    public int _currentIteration;
    private Entry[] _map;
    public final Entry _poolHead;
    public Entry _poolCurrent;
    private Entry _poolTail;

    public DuplicateAttributeVerifier() {
        this._poolTail = this._poolHead = new Entry();
    }

    public final void clear() {
        this._currentIteration = 0;
        Entry entry = this._poolHead;
        while (entry != null) {
            entry.iteration = 0;
            entry = entry.poolNext;
        }
        this.reset();
    }

    public final void reset() {
        this._poolCurrent = this._poolHead;
        if (this._map == null) {
            this._map = new Entry[256];
        }
    }

    private final void increasePool(int n) {
        if (this._map == null) {
            this._map = new Entry[256];
            this._poolCurrent = this._poolHead;
        } else {
            Entry entry = this._poolTail;
            for (int i = 0; i < n; ++i) {
                Entry entry2 = new Entry();
                this._poolTail.poolNext = entry2;
                this._poolTail = entry2;
            }
            this._poolCurrent = entry.poolNext;
        }
    }

    public final void checkForDuplicateAttribute(int n, int n2) throws FastInfosetException {
        if (this._poolCurrent == null) {
            this.increasePool(16);
        }
        Entry entry = this._poolCurrent;
        this._poolCurrent = this._poolCurrent.poolNext;
        Entry entry2 = this._map[n];
        if (entry2 == null || entry2.iteration < this._currentIteration) {
            entry.hashNext = null;
            this._map[n] = entry;
            entry.iteration = this._currentIteration;
            entry.value = n2;
        } else {
            Entry entry3 = entry2;
            do {
                if (entry3.value != n2) continue;
                this.reset();
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.duplicateAttribute"));
            } while ((entry3 = entry3.hashNext) != null);
            entry.hashNext = entry2;
            this._map[n] = entry;
            entry.iteration = this._currentIteration;
            entry.value = n2;
        }
    }

    public static class Entry {
        private int iteration;
        private int value;
        private Entry hashNext;
        private Entry poolNext;
    }
}

