/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public final class JAXWSUtils {
    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getFileOrURLName(String string) {
        try {
            try {
                return JAXWSUtils.escapeSpace(new URL(string).toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                return new File(string).getCanonicalFile().toURL().toExternalForm();
            }
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static URL getFileOrURL(String string) throws IOException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return new File(string).toURL();
        }
    }

    private static String escapeSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String absolutize(String string) {
        try {
            URL uRL = new File(".").getCanonicalFile().toURL();
            return new URL(uRL, string).toExternalForm();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public static void checkAbsoluteness(String string) {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("system ID '" + string + "' isn't absolute", uRISyntaxException);
            }
        }
    }

    public static boolean matchQNames(QName qName, QName qName2) {
        if (qName == null || qName2 == null) {
            return false;
        }
        if (qName2.getNamespaceURI().equals(qName.getNamespaceURI())) {
            String string = qName2.getLocalPart().replaceAll("\\*", ".*");
            return Pattern.matches(string, qName.getLocalPart());
        }
        return false;
    }
}

