/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.SetupData;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.SetupData.DisplayPackageDescription;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.ProductDescription;
import org.openoffice.setup.SetupData.XMLPackageDescription;

public class SetupDataProvider {
    private static PackageDescription packageData;
    private static ProductDescription productData;

    private SetupDataProvider() {
    }

    public static PackageDescription getPackageDescription() {
        return packageData;
    }

    public static ProductDescription getProductDescription() {
        return productData;
    }

    public static String replaceMacros(String s) {
        return productData.replaceMacros(s);
    }

    public static String getString(String key) {
        return productData.get(key);
    }

    public static void setNewMacro(String key, String value) {
        productData.setNewMacro(key, value);
    }

    public static void dumpMacros() {
        productData.dumpMacros();
    }

    private static DefaultMutableTreeNode createTree(PackageDescription data, InstallData installData) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        node.setUserObject(new DisplayPackageDescription(data));
        Enumeration e = data.children();
        while (e.hasMoreElements()) {
            PackageDescription child = (PackageDescription)e.nextElement();
            if (installData.isUserInstallation() && !child.showInUserInstall()) {
                child.setIsHidden(true);
                child.setSelectionState(6);
            }
            if (child.isHidden()) continue;
            node.add(SetupDataProvider.createTree(child, installData));
        }
        return node;
    }

    public static DefaultMutableTreeNode createTree() {
        InstallData installData = InstallData.getInstance();
        return SetupDataProvider.createTree(SetupDataProvider.getPackageDescription(), installData);
    }

    static {
        XMLPackageDescription rawData = new XMLPackageDescription();
        rawData.read();
        packageData = new PackageDescription(rawData);
        productData = new ProductDescription(rawData);
    }
}

