/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.Util;

public class StackTraceElementCompositeData
extends LazyCompositeData {
    private final StackTraceElement ste;
    private static final CompositeType stackTraceElementCompositeType;
    private static final String CLASS_NAME = "className";
    private static final String METHOD_NAME = "methodName";
    private static final String FILE_NAME = "fileName";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String NATIVE_METHOD = "nativeMethod";
    private static final String[] stackTraceElementItemNames;

    private StackTraceElementCompositeData(StackTraceElement stackTraceElement) {
        this.ste = stackTraceElement;
    }

    public StackTraceElement getStackTraceElement() {
        return this.ste;
    }

    public static StackTraceElement from(CompositeData compositeData) {
        StackTraceElementCompositeData.validateCompositeData(compositeData);
        return new StackTraceElement(StackTraceElementCompositeData.getString(compositeData, CLASS_NAME), StackTraceElementCompositeData.getString(compositeData, METHOD_NAME), StackTraceElementCompositeData.getString(compositeData, FILE_NAME), StackTraceElementCompositeData.getInt(compositeData, LINE_NUMBER));
    }

    public static CompositeData toCompositeData(StackTraceElement stackTraceElement) {
        StackTraceElementCompositeData stackTraceElementCompositeData = new StackTraceElementCompositeData(stackTraceElement);
        return stackTraceElementCompositeData.getCompositeData();
    }

    protected CompositeData getCompositeData() {
        Object[] objectArray = new Object[]{this.ste.getClassName(), this.ste.getMethodName(), this.ste.getFileName(), new Integer(this.ste.getLineNumber()), new Boolean(this.ste.isNativeMethod())};
        try {
            return new CompositeDataSupport(stackTraceElementCompositeType, stackTraceElementItemNames, objectArray);
        }
        catch (OpenDataException openDataException) {
            throw Util.newInternalError(openDataException);
        }
    }

    public static void validateCompositeData(CompositeData compositeData) {
        if (compositeData == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!StackTraceElementCompositeData.isTypeMatched(stackTraceElementCompositeType, compositeData.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for StackTraceElement");
        }
    }

    static {
        try {
            stackTraceElementCompositeType = (CompositeType)MappedMXBeanType.toOpenType(StackTraceElement.class);
        }
        catch (OpenDataException openDataException) {
            throw Util.newInternalError(openDataException);
        }
        stackTraceElementItemNames = new String[]{CLASS_NAME, METHOD_NAME, FILE_NAME, LINE_NUMBER, NATIVE_METHOD};
    }
}

