/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.WebRowSetImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;

public class FilteredRowSetImpl
extends WebRowSetImpl
implements Serializable,
Cloneable,
FilteredRowSet {
    private Predicate p;
    private boolean onInsertRow = false;
    static final long serialVersionUID = 6178454588413509360L;

    public FilteredRowSetImpl() throws SQLException {
    }

    public FilteredRowSetImpl(Hashtable hashtable) throws SQLException {
        super(hashtable);
    }

    public void setFilter(Predicate predicate) throws SQLException {
        this.p = predicate;
    }

    public Predicate getFilter() {
        return this.p;
    }

    protected boolean internalNext() throws SQLException {
        boolean bl = false;
        for (int i = this.getRow(); i <= this.size(); ++i) {
            bl = super.internalNext();
            if (this.p == null) {
                return bl;
            }
            if (this.p.evaluate(this)) break;
        }
        return bl;
    }

    protected boolean internalPrevious() throws SQLException {
        boolean bl = false;
        for (int i = this.getRow(); i > 0; --i) {
            bl = super.internalPrevious();
            if (this.p == null) {
                return bl;
            }
            if (this.p.evaluate(this)) break;
        }
        return bl;
    }

    protected boolean internalFirst() throws SQLException {
        boolean bl = super.internalFirst();
        if (this.p == null) {
            return bl;
        }
        while (bl && !this.p.evaluate(this)) {
            bl = super.internalNext();
        }
        return bl;
    }

    protected boolean internalLast() throws SQLException {
        boolean bl = super.internalLast();
        if (this.p == null) {
            return bl;
        }
        while (bl && !this.p.evaluate(this)) {
            bl = super.internalPrevious();
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.relative").toString());
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (this.isAfterLast()) {
                    return false;
                }
                bl2 = this.internalNext();
            }
            bl = bl2;
        } else {
            for (int i = n; i < 0; ++i) {
                if (this.isBeforeFirst()) {
                    return false;
                }
                bl3 = this.internalPrevious();
            }
            bl = bl3;
        }
        if (n != 0) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl;
        boolean bl2 = false;
        if (n == 0 || this.getType() == 1003) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.absolute").toString());
        }
        if (n > 0) {
            bl2 = this.internalFirst();
            for (int i = 0; i < n - 1; ++i) {
                if (this.isAfterLast()) {
                    return false;
                }
                bl2 = this.internalNext();
            }
            bl = bl2;
        } else {
            bl2 = this.internalLast();
            int n2 = n;
            while (n2 + 1 < 0) {
                if (this.isBeforeFirst()) {
                    return false;
                }
                bl2 = this.internalPrevious();
                ++n2;
            }
            bl = bl2;
        }
        this.notifyCursorMoved();
        return bl;
    }

    public void moveToInsertRow() throws SQLException {
        this.onInsertRow = true;
        super.moveToInsertRow();
    }

    public void updateInt(int n, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)new Integer(n2), n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateInt(n, n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && this.p != null && !(bl2 = this.p.evaluate((Object)new Boolean(bl), n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBoolean(n, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)new Byte(by), n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateByte(n, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(int n, short s) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)new Short(s), n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateShort(n, s);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateLong(int n, long l) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)new Long(l), n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateLong(n, l);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(int n, float f) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)new Float(f), n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateFloat(n, f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(int n, double d) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)new Double(d), n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateDouble(n, d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)bigDecimal, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBigDecimal(n, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)string, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateString(n, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        boolean bl;
        String string = new String();
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = new Byte(byArray[i]);
            string = string.concat(byteArray[i].toString());
        }
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)string, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBytes(n, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)date, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateDate(n, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)time, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateTime(n, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)timestamp, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateTimestamp(n, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)inputStream, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateAsciiStream(n, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)reader, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateCharacterStream(n, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate((Object)inputStream, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateBinaryStream(n, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateObject(int n, Object object) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate(object, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateObject(n, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        boolean bl;
        if (this.onInsertRow && this.p != null && !(bl = this.p.evaluate(object, n))) {
            throw new SQLException(this.resBundle.handleGetObject("filteredrowsetimpl.notallowed").toString());
        }
        super.updateObject(n, object, n2);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void insertRow() throws SQLException {
        this.onInsertRow = false;
        super.insertRow();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

