/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.cert.CertPath;
import java.util.Date;

public final class Timestamp
implements Serializable {
    private static final long serialVersionUID = -5502683707821851294L;
    private Date timestamp;
    private CertPath signerCertPath;
    private transient int myhash = -1;

    public Timestamp(Date date, CertPath certPath) {
        if (date == null || certPath == null) {
            throw new NullPointerException();
        }
        this.timestamp = new Date(date.getTime());
        this.signerCertPath = certPath;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.getTime());
    }

    public CertPath getSignerCertPath() {
        return this.signerCertPath;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.timestamp.hashCode() + this.signerCertPath.hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Timestamp)) {
            return false;
        }
        Timestamp timestamp = (Timestamp)object;
        if (this == timestamp) {
            return true;
        }
        return this.timestamp.equals(timestamp.getTimestamp()) && this.signerCertPath.equals(timestamp.getSignerCertPath());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("timestamp: " + this.timestamp);
        stringBuffer.append("TSA: " + this.signerCertPath.getCertificates().get(0));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

