/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.ResourceManager;
import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.ContinuationDirContext;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.StateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryManager
extends NamingManager {
    DirectoryManager() {
    }

    public static DirContext getContinuationDirContext(CannotProceedException cannotProceedException) throws NamingException {
        Hashtable<String, CannotProceedException> hashtable = cannotProceedException.getEnvironment();
        hashtable = hashtable == null ? new Hashtable<String, CannotProceedException>(7) : (Hashtable<String, CannotProceedException>)hashtable.clone();
        hashtable.put("java.naming.spi.CannotProceedException", cannotProceedException);
        return new ContinuationDirContext(cannotProceedException, hashtable);
    }

    public static Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable, Attributes attributes) throws Exception {
        Object object2;
        ObjectFactoryBuilder objectFactoryBuilder = DirectoryManager.getObjectFactoryBuilder();
        if (objectFactoryBuilder != null) {
            ObjectFactory objectFactory = objectFactoryBuilder.createObjectFactory(object, hashtable);
            if (objectFactory instanceof DirObjectFactory) {
                return ((DirObjectFactory)objectFactory).getObjectInstance(object, name, context, hashtable, attributes);
            }
            return objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        Reference reference = null;
        if (object instanceof Reference) {
            reference = (Reference)object;
        } else if (object instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        }
        if (reference != null) {
            String string = reference.getFactoryClassName();
            if (string != null) {
                ObjectFactory objectFactory = DirectoryManager.getObjectFactoryFromReference(reference, string);
                if (objectFactory instanceof DirObjectFactory) {
                    return ((DirObjectFactory)objectFactory).getObjectInstance(reference, name, context, hashtable, attributes);
                }
                if (objectFactory != null) {
                    return objectFactory.getObjectInstance(reference, name, context, hashtable);
                }
                return object;
            }
            object2 = DirectoryManager.processURLAddrs(reference, name, context, hashtable);
            if (object2 != null) {
                return object2;
            }
        }
        return (object2 = DirectoryManager.createObjectFromFactories(object, name, context, hashtable, attributes)) != null ? object2 : object;
    }

    private static Object createObjectFromFactories(Object object, Name name, Context context, Hashtable hashtable, Attributes attributes) throws Exception {
        FactoryEnumeration factoryEnumeration = ResourceManager.getFactories("java.naming.factory.object", hashtable, context);
        if (factoryEnumeration == null) {
            return null;
        }
        Object object2 = null;
        while (object2 == null && factoryEnumeration.hasMore()) {
            ObjectFactory objectFactory = (ObjectFactory)factoryEnumeration.next();
            if (objectFactory instanceof DirObjectFactory) {
                object2 = ((DirObjectFactory)objectFactory).getObjectInstance(object, name, context, hashtable, attributes);
                continue;
            }
            object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        return object2;
    }

    public static DirStateFactory.Result getStateToBind(Object object, Name name, Context context, Hashtable<?, ?> hashtable, Attributes attributes) throws NamingException {
        FactoryEnumeration factoryEnumeration = ResourceManager.getFactories("java.naming.factory.state", hashtable, context);
        if (factoryEnumeration == null) {
            return new DirStateFactory.Result(object, attributes);
        }
        DirStateFactory.Result result = null;
        while (result == null && factoryEnumeration.hasMore()) {
            StateFactory stateFactory = (StateFactory)factoryEnumeration.next();
            if (stateFactory instanceof DirStateFactory) {
                result = ((DirStateFactory)stateFactory).getStateToBind(object, name, context, hashtable, attributes);
                continue;
            }
            Object object2 = stateFactory.getStateToBind(object, name, context, hashtable);
            if (object2 == null) continue;
            result = new DirStateFactory.Result(object2, attributes);
        }
        return result != null ? result : new DirStateFactory.Result(object, attributes);
    }
}

