/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import sun.security.jca.GetInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateFactory {
    private String type;
    private Provider provider;
    private CertificateFactorySpi certFacSpi;

    protected CertificateFactory(CertificateFactorySpi certificateFactorySpi, Provider provider, String string) {
        this.certFacSpi = certificateFactorySpi;
        this.provider = provider;
        this.type = string;
    }

    public static final CertificateFactory getInstance(String string) throws CertificateException {
        try {
            GetInstance.Instance instance = GetInstance.getInstance("CertificateFactory", CertificateFactorySpi.class, string);
            return new CertificateFactory((CertificateFactorySpi)instance.impl, instance.provider, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException(string + " not found", noSuchAlgorithmException);
        }
    }

    public static final CertificateFactory getInstance(String string, String string2) throws CertificateException, NoSuchProviderException {
        try {
            GetInstance.Instance instance = GetInstance.getInstance("CertificateFactory", CertificateFactorySpi.class, string, string2);
            return new CertificateFactory((CertificateFactorySpi)instance.impl, instance.provider, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException(string + " not found", noSuchAlgorithmException);
        }
    }

    public static final CertificateFactory getInstance(String string, Provider provider) throws CertificateException {
        try {
            GetInstance.Instance instance = GetInstance.getInstance("CertificateFactory", CertificateFactorySpi.class, string, provider);
            return new CertificateFactory((CertificateFactorySpi)instance.impl, instance.provider, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertificateException(string + " not found", noSuchAlgorithmException);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificate(inputStream);
    }

    public final Iterator<String> getCertPathEncodings() {
        return this.certFacSpi.engineGetCertPathEncodings();
    }

    public final CertPath generateCertPath(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(inputStream);
    }

    public final CertPath generateCertPath(InputStream inputStream, String string) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(inputStream, string);
    }

    public final CertPath generateCertPath(List<? extends Certificate> list) throws CertificateException {
        return this.certFacSpi.engineGenerateCertPath(list);
    }

    public final Collection<? extends Certificate> generateCertificates(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificates(inputStream);
    }

    public final CRL generateCRL(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRL(inputStream);
    }

    public final Collection<? extends CRL> generateCRLs(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRLs(inputStream);
    }
}

