/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.client;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.client.ClientTransportException;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.transport.Headers;
import com.sun.xml.internal.ws.transport.http.client.HttpClientTransport;
import com.sun.xml.internal.ws.transport.http.client.HttpResponseProperties;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTransportPipe
extends AbstractTubeImpl {
    private final Codec codec;
    private final WSBinding binding;
    public static boolean dump;

    public HttpTransportPipe(Codec codec, WSBinding wSBinding) {
        this.codec = codec;
        this.binding = wSBinding;
    }

    private HttpTransportPipe(HttpTransportPipe httpTransportPipe, TubeCloner tubeCloner) {
        this(httpTransportPipe.codec.copy(), httpTransportPipe.binding);
        tubeCloner.add(httpTransportPipe, this);
    }

    @Override
    public NextAction processException(@NotNull Throwable throwable) {
        throw new IllegalStateException("HttpTransportPipe's processException shouldn't be called.");
    }

    @Override
    public NextAction processRequest(@NotNull Packet packet) {
        return this.doReturnWith(this.process(packet));
    }

    @Override
    public NextAction processResponse(@NotNull Packet packet) {
        throw new IllegalStateException("HttpTransportPipe's processResponse shouldn't be called.");
    }

    @Override
    public Packet process(Packet packet) {
        try {
            Object object;
            Closeable closeable;
            Headers headers = new Headers();
            Map map = (Map)packet.invocationProperties.get("javax.xml.ws.http.request.headers");
            if (map != null) {
                headers.putAll(map);
            }
            HttpClientTransport httpClientTransport = new HttpClientTransport(packet, headers);
            packet.addSatellite(new HttpResponseProperties(httpClientTransport));
            ContentType contentType = this.codec.getStaticContentType(packet);
            if (contentType == null) {
                closeable = new ByteArrayBuffer();
                contentType = this.codec.encode(packet, (OutputStream)closeable);
                headers.put("Content-Length", Collections.singletonList(Integer.toString(((ByteArrayBuffer)closeable).size())));
                headers.put("Content-Type", Collections.singletonList(contentType.getContentType()));
                if (contentType.getAcceptHeader() != null) {
                    headers.put("Accept", Collections.singletonList(contentType.getAcceptHeader()));
                }
                if (this.binding instanceof SOAPBinding) {
                    this.writeSOAPAction(headers, contentType.getSOAPActionHeader(), packet);
                }
                if (dump) {
                    this.dump((ByteArrayBuffer)closeable, "HTTP request", headers);
                }
                ((ByteArrayBuffer)closeable).writeTo(httpClientTransport.getOutput());
            } else {
                headers.put("Content-Type", Collections.singletonList(contentType.getContentType()));
                if (contentType.getAcceptHeader() != null) {
                    headers.put("Accept", Collections.singletonList(contentType.getAcceptHeader()));
                }
                if (this.binding instanceof SOAPBinding) {
                    this.writeSOAPAction(headers, contentType.getSOAPActionHeader(), packet);
                }
                if (dump) {
                    closeable = new ByteArrayBuffer();
                    this.codec.encode(packet, (OutputStream)closeable);
                    this.dump((ByteArrayBuffer)closeable, "HTTP request - " + packet.endpointAddress, headers);
                    object = httpClientTransport.getOutput();
                    if (object != null) {
                        ((ByteArrayBuffer)closeable).writeTo((OutputStream)object);
                    }
                } else {
                    closeable = httpClientTransport.getOutput();
                    if (closeable != null) {
                        this.codec.encode(packet, (OutputStream)closeable);
                    }
                }
            }
            httpClientTransport.closeOutput();
            httpClientTransport.readResponseCodeAndMessage();
            closeable = httpClientTransport.getInput();
            if (dump) {
                object = new ByteArrayBuffer();
                if (closeable != null) {
                    ((ByteArrayBuffer)object).write((InputStream)closeable);
                    ((InputStream)closeable).close();
                }
                this.dump((ByteArrayBuffer)object, "HTTP response - " + packet.endpointAddress + " - " + httpClientTransport.statusCode, httpClientTransport.getHeaders());
                closeable = ((ByteArrayBuffer)object).newInputStream();
            }
            if (httpClientTransport.statusCode == 202 || packet.expectReply != null && !packet.expectReply.booleanValue()) {
                this.checkStatusCodeOneway((InputStream)closeable, httpClientTransport.statusCode, httpClientTransport.statusMessage);
                return packet.createClientResponse(null);
            }
            this.checkStatusCode((InputStream)closeable, httpClientTransport.statusCode, httpClientTransport.statusMessage);
            object = httpClientTransport.getContentType();
            if (object == null) {
                throw new WebServiceException("No Content-type in the header!");
            }
            Packet packet2 = packet.createClientResponse(null);
            packet2.wasTransportSecure = httpClientTransport.isSecure();
            this.codec.decode((InputStream)closeable, (String)object, packet2);
            return packet2;
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    private void checkStatusCode(InputStream inputStream, int n, String string) throws IOException {
        if (this.binding instanceof SOAPBinding && n != 200 && n != 500) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(n, string));
        }
    }

    private void checkStatusCodeOneway(InputStream inputStream, int n, String string) throws IOException {
        if (n != 202 && n != 200) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(n, string));
        }
    }

    private void writeSOAPAction(Map<String, List<String>> map, String string, Packet packet) {
        if (SOAPVersion.SOAP_12.equals((Object)this.binding.getSOAPVersion())) {
            return;
        }
        if (string != null) {
            map.put("SOAPAction", Collections.singletonList(string));
        } else {
            map.put("SOAPAction", Collections.singletonList("\"\""));
        }
    }

    @Override
    public void preDestroy() {
    }

    @Override
    public HttpTransportPipe copy(TubeCloner tubeCloner) {
        return new HttpTransportPipe(this, tubeCloner);
    }

    private void dump(ByteArrayBuffer byteArrayBuffer, String string, Map<String, List<String>> map) throws IOException {
        System.out.println("---[" + string + "]---");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (entry.getValue().isEmpty()) {
                System.out.println(entry.getValue());
                continue;
            }
            for (String string2 : entry.getValue()) {
                System.out.println(entry.getKey() + ": " + string2);
            }
        }
        byteArrayBuffer.writeTo(System.out);
        System.out.println("--------------------");
    }

    static {
        boolean bl;
        try {
            bl = Boolean.getBoolean(HttpTransportPipe.class.getName() + ".dump");
        }
        catch (Throwable throwable) {
            bl = false;
        }
        dump = bl;
    }
}

