/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateInfo;
import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import sun.misc.HexDumpEncoder;
import sun.security.x509.SerialNumber;

public class CertificateDialog {
    public static void showCertificates(JDialog jDialog, Certificate[] certificateArray, int n, int n2) {
        final JDialog jDialog2 = new JDialog(jDialog, ResourceManager.getMessage("cert.dialog.caption"), true);
        jDialog2.getContentPane().setLayout(new BorderLayout());
        jDialog2.getContentPane().add((Component)CertificateDialog.getComponents(jDialog, certificateArray, n, n2), "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(4));
        JButton jButton = new JButton(CertificateDialog.getMessage("cert.dialog.close"));
        jButton.setMnemonic(CertificateDialog.getAcceleratorKey("cert.dialog.close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog2.setVisible(false);
            }
        });
        jPanel.add(jButton);
        jDialog2.getContentPane().add((Component)jPanel, "South");
        jDialog2.pack();
        jDialog2.setLocationRelativeTo(jDialog);
        jDialog2.setResizable(false);
        if (!Trace.isAutomationEnabled()) {
            jDialog2.setVisible(true);
        }
    }

    private static JPanel getComponents(JDialog jDialog, Certificate[] certificateArray, int n, int n2) {
        if (certificateArray.length > n && certificateArray[n] instanceof X509Certificate) {
            final JTable jTable = new JTable();
            final JTextArea jTextArea = new JTextArea();
            Border border = BorderFactory.createEtchedBorder();
            final JTree jTree = CertificateDialog.buildCertChainTree(certificateArray, n, n2);
            jTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode != null) {
                        CertificateInfo certificateInfo = (CertificateInfo)defaultMutableTreeNode.getUserObject();
                        CertificateDialog.showCertificateInfo(certificateInfo.getCertificate(), jTable, jTextArea);
                    }
                }
            });
            CertificateDialog.showCertificateInfo((X509Certificate)certificateArray[n], jTable, jTextArea);
            jTable.setSelectionMode(0);
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = jTable.getSelectedRow();
                    if (n >= 0) {
                        String string = (String)jTable.getValueAt(n, 1);
                        jTextArea.setText(string);
                        jTextArea.repaint();
                    }
                }
            });
            jTextArea.setLineWrap(false);
            jTextArea.setEditable(false);
            jTextArea.setRows(10);
            jTextArea.setColumns(40);
            Font font = ResourceManager.getUIFont();
            Font font2 = new Font("Monospaced", 0, font.getSize());
            jTextArea.setFont(font2);
            int n3 = font.getSize();
            jTable.setRowSelectionInterval(8, 8);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            Dimension dimension = jTable.getPreferredScrollableViewportSize();
            int n4 = Math.max(145, 8 + 9 * n3);
            dimension.setSize(dimension.getWidth(), (double)n4);
            jTable.setPreferredScrollableViewportSize(dimension);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), jScrollPane.getBorder()));
            jPanel.add((Component)jScrollPane, "Center");
            jPanel.add((Component)new JScrollPane(jTextArea), "South");
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            dimension = jTree.getPreferredScrollableViewportSize();
            dimension.setSize(200.0, 100.0);
            jScrollPane = new JScrollPane(jTree);
            jScrollPane.setPreferredSize(dimension);
            jPanel2.add((Component)jScrollPane, "West");
            jPanel2.add((Component)jPanel, "East");
            return jPanel2;
        }
        return new JPanel();
    }

    private static String formatDNString(String string) {
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\'') {
                boolean bl3 = bl2 = !bl2;
            }
            if (c == ',' && !bl2) {
                stringBuffer.append(",\n");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static JTree buildCertChainTree(Certificate[] certificateArray, int n, int n2) {
        Serializable serializable;
        Serializable serializable2 = null;
        Serializable serializable3 = null;
        for (int i = n; i < certificateArray.length && i < n2; ++i) {
            serializable = new DefaultMutableTreeNode(new CertificateInfo((X509Certificate)certificateArray[i]));
            if (serializable2 == null) {
                serializable2 = serializable;
                serializable3 = serializable;
                continue;
            }
            serializable3.add((MutableTreeNode)((Object)serializable));
            serializable3 = serializable;
        }
        JTree jTree = new JTree((TreeNode)((Object)serializable2));
        serializable = new DefaultTreeCellRenderer();
        serializable.putClientProperty("html.disable", Boolean.TRUE);
        jTree.setCellRenderer((TreeCellRenderer)((Object)serializable));
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        return jTree;
    }

    private static void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            CertificateDialog.byte2hex(byArray[i], stringBuffer);
            if (i >= n - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    private static String getCertFingerPrint(String string, X509Certificate x509Certificate) throws Exception {
        byte[] byArray = x509Certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return CertificateDialog.toHexString(byArray2);
    }

    private static void showCertificateInfo(X509Certificate x509Certificate, JTable jTable, JTextArea jTextArea) {
        Object object;
        String string = "V" + x509Certificate.getVersion();
        String string2 = "[xxxxx-xxxxx]";
        String string3 = null;
        String string4 = null;
        try {
            object = new SerialNumber(x509Certificate.getSerialNumber());
            string2 = "[" + ((SerialNumber)object).getNumber() + "]";
            string3 = CertificateDialog.getCertFingerPrint("MD5", x509Certificate);
            string4 = CertificateDialog.getCertFingerPrint("SHA1", x509Certificate);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = "[" + x509Certificate.getSigAlgName() + "]";
        String string5 = CertificateDialog.formatDNString(((Object)x509Certificate.getIssuerDN()).toString());
        String string6 = "[From: " + x509Certificate.getNotBefore() + ",\n To: " + x509Certificate.getNotAfter() + "]";
        String string7 = CertificateDialog.formatDNString(((Object)x509Certificate.getSubjectDN()).toString());
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string8 = hexDumpEncoder.encodeBuffer(x509Certificate.getSignature());
        Object[][] objectArray = new Object[][]{{CertificateDialog.getMessage("cert.dialog.field.Version"), string}, {CertificateDialog.getMessage("cert.dialog.field.SerialNumber"), string2}, {CertificateDialog.getMessage("cert.dialog.field.SignatureAlg"), object}, {CertificateDialog.getMessage("cert.dialog.field.Issuer"), string5}, {CertificateDialog.getMessage("cert.dialog.field.Validity"), string6}, {CertificateDialog.getMessage("cert.dialog.field.Subject"), string7}, {CertificateDialog.getMessage("cert.dialog.field.Signature"), string8}, {CertificateDialog.getMessage("cert.dialog.field.md5Fingerprint"), string3}, {CertificateDialog.getMessage("cert.dialog.field.sha1Fingerprint"), string4}};
        Object[] objectArray2 = new String[]{CertificateDialog.getMessage("cert.dialog.field"), CertificateDialog.getMessage("cert.dialog.value")};
        jTable.setModel(new DefaultTableModel(objectArray, objectArray2){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        jTable.setRowSelectionInterval(8, 8);
        jTable.repaint();
        jTextArea.repaint();
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }
}

