/*
 * Decompiled with CFR 0.152.
 */
package com.sun.inputmethods.internal.thaiim;

import java.awt.im.InputMethodRequests;

public class ThaiRules {
    public static final char BASE = '\u0e00';
    public static final byte NON = 0;
    public static final byte CONS = 1;
    public static final byte LV = 2;
    public static final byte FV1 = 3;
    public static final byte FV2 = 4;
    public static final byte FV3 = 5;
    public static final byte FV4 = 6;
    public static final byte BV1 = 7;
    public static final byte BV2 = 8;
    public static final byte BD = 9;
    public static final byte TONE = 10;
    public static final byte AD1 = 11;
    public static final byte AD2 = 12;
    public static final byte AD3 = 13;
    public static final byte AV1 = 14;
    public static final byte AV2 = 15;
    public static final byte AV3 = 16;
    public static final byte STRICT = 0;
    public static final byte LOOSE = 1;
    public static final byte NOREPLACE = 2;
    public static final byte[] CHARTYPE = new byte[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 5, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3, 15, 3, 6, 14, 16, 15, 16, 7, 8, 9, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 4, 0, 12, 10, 10, 10, 10, 11, 13, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private InputMethodRequests requests;
    private static final int[] INPUTVALIDITY = new int[]{39, 131071, 2, 39, 39, 55, 39, 3111, 1063, 39, 111, 39, 39, 39, 3111, 1063, 9255};
    private static final int[] COMPOSABLE = new int[]{0, 131008, 0, 0, 0, 0, 0, 3072, 1024, 0, 64, 0, 0, 0, 3072, 1024, 9216};
    private static final int[] REPLACABLE = new int[]{0, 0, 0, 0, 0, 0, 129472, 127936, 129984, 131008, 15872, 114496, 131008, 65472, 127936, 129984, 121792};
    private static final int[] SWAPPABLE = new int[]{0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 115072, 16512, 0, 65536, 0, 0, 0};

    ThaiRules(InputMethodRequests inputMethodRequests) {
        this.requests = inputMethodRequests;
    }

    public static byte getCharType(char c) {
        int n = c - 3584;
        byte by = n < 0 || n >= CHARTYPE.length ? (byte)0 : CHARTYPE[n];
        return by;
    }

    private static boolean isValid(char c, char c2, int[] nArray) {
        return (nArray[ThaiRules.getCharType(c)] & 1 << ThaiRules.getCharType(c2)) != 0;
    }

    public static boolean isInputValid(char c, char c2) {
        return ThaiRules.isValid(c, c2, INPUTVALIDITY);
    }

    public static boolean isComposable(char c, char c2) {
        return ThaiRules.isValid(c, c2, COMPOSABLE);
    }

    public static boolean isSwappable(char c, char c2) {
        return ThaiRules.isValid(c, c2, SWAPPABLE);
    }

    public static boolean isReplacable(char c, char c2) {
        return ThaiRules.isValid(c, c2, REPLACABLE);
    }

    public static boolean isForward(char c) {
        return ThaiRules.getCharType(c) < 6;
    }

    public static boolean isDead(char c) {
        return ThaiRules.getCharType(c) > 5;
    }

    public boolean isInputValid(char c) {
        int n = this.requests.getInsertPositionOffset();
        if (n == 0) {
            byte by = ThaiRules.getCharType(c);
            return by < 3 || by == 5;
        }
        char c2 = this.requests.getCommittedText(n - 1, n, null).first();
        if (ThaiRules.isForward(c)) {
            if (ThaiRules.isInputValid(c2, c)) {
                if (ThaiRules.getCharType(c2) == 10 && ThaiRules.getCharType(c) == 3) {
                    if (n == 1) {
                        return true;
                    }
                    char c3 = this.requests.getCommittedText(n - 2, n - 1, null).first();
                    return ThaiRules.isInputValid(c3, c);
                }
                return true;
            }
            if (c2 == '\u0e32' && c == '\u0e30') {
                return true;
            }
            return c2 == '\u0e4d' && c == '\u0e32';
        }
        if (ThaiRules.isInputValid(c2, c)) {
            if (ThaiRules.getCharType(c2) == 10 && ThaiRules.getCharType(c) == 6) {
                return n != 1;
            }
            return true;
        }
        return false;
    }
}

