/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.rmi.runtime.Log;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectEndpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.security.action.GetPropertyAction;

public abstract class Transport {
    static final int logLevel = LogStream.parseLevel(Transport.getLogLevel());
    static final Log transportLog = Log.getLog("sun.rmi.transport.misc", "transport", logLevel);
    private static final ThreadLocal currentTransport = new ThreadLocal();
    private static final ObjID dgcID = new ObjID(2);

    private static String getLogLevel() {
        return AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.logLevel"));
    }

    public abstract Channel getChannel(Endpoint var1);

    public abstract void free(Endpoint var1);

    public void exportObject(Target target) throws RemoteException {
        target.setExportedTransport(this);
        ObjectTable.putTarget(target);
    }

    protected void targetUnexported() {
    }

    static Transport currentTransport() {
        return (Transport)currentTransport.get();
    }

    protected abstract void checkAcceptPermission(AccessControlContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serviceCall(final RemoteCall remoteCall) {
        Remote remote;
        Object object;
        try {
            object = ObjID.read(remoteCall.getInputStream());
        }
        catch (IOException iOException) {
            throw new MarshalException("unable to read objID", iOException);
        }
        Object object2 = ((ObjID)object).equals(dgcID) ? null : this;
        Target target = ObjectTable.getTarget(new ObjectEndpoint((ObjID)object, (Transport)object2));
        if (target == null || (remote = target.getImpl()) == null) {
            throw new NoSuchObjectException("no such object in table");
        }
        final Dispatcher dispatcher = target.getDispatcher();
        target.incrementCallCount();
        try {
            transportLog.log(Log.VERBOSE, "call dispatcher");
            final AccessControlContext accessControlContext = target.getAccessControlContext();
            ClassLoader classLoader = target.getContextClassLoader();
            Thread thread = Thread.currentThread();
            ClassLoader classLoader2 = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(classLoader);
                currentTransport.set(this);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            Transport.this.checkAcceptPermission(accessControlContext);
                            dispatcher.dispatch(remote, remoteCall);
                            return null;
                        }
                    }, accessControlContext);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            }
            finally {
                thread.setContextClassLoader(classLoader2);
                currentTransport.set(null);
            }
            target.decrementCallCount();
        }
        catch (IOException iOException) {
            try {
                transportLog.log(Log.BRIEF, "exception thrown by dispatcher: ", iOException);
                boolean bl = false;
                target.decrementCallCount();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    target.decrementCallCount();
                    throw throwable;
                }
                catch (RemoteException remoteException) {
                    if (UnicastServerRef.callLog.isLoggable(Log.BRIEF)) {
                        object = "";
                        try {
                            object = "[" + RemoteServer.getClientHost() + "] ";
                        }
                        catch (ServerNotActiveException serverNotActiveException) {
                            // empty catch block
                        }
                        object2 = (String)object + "exception: ";
                        UnicastServerRef.callLog.log(Log.BRIEF, (String)object2, remoteException);
                    }
                    try {
                        object = remoteCall.getResultStream(false);
                        UnicastServerRef.clearStackTraces(remoteException);
                        object.writeObject(remoteException);
                        remoteCall.releaseOutputStream();
                    }
                    catch (IOException iOException2) {
                        transportLog.log(Log.BRIEF, "exception thrown marshalling exception: ", iOException2);
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

