/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import sun.awt.NativeLibLoader;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.security.action.GetPropertyAction;

public class FontDescriptor
implements Cloneable {
    String nativeName;
    public CharsetEncoder encoder;
    String charsetName;
    private int[] exclusionRanges;
    public CharsetEncoder unicodeEncoder;
    boolean useUnicode;
    static boolean isLE;

    public FontDescriptor(String string, CharsetEncoder charsetEncoder, int[] nArray) {
        this.nativeName = string;
        this.encoder = charsetEncoder;
        this.exclusionRanges = nArray;
        this.useUnicode = false;
        Charset charset = charsetEncoder.charset();
        this.charsetName = charset instanceof HistoricallyNamedCharset ? ((HistoricallyNamedCharset)((Object)charset)).historicalName() : charset.name();
    }

    public String getNativeName() {
        return this.nativeName;
    }

    public CharsetEncoder getFontCharsetEncoder() {
        return this.encoder;
    }

    public String getFontCharsetName() {
        return this.charsetName;
    }

    public int[] getExclusionRanges() {
        return this.exclusionRanges;
    }

    public boolean isExcluded(char c) {
        int n = 0;
        while (n < this.exclusionRanges.length) {
            int n2 = this.exclusionRanges[n++];
            int n3 = this.exclusionRanges[n++];
            if (c < n2 || c > n3) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return super.toString() + " [" + this.nativeName + "|" + this.encoder + "]";
    }

    private static native void initIDs();

    public boolean useUnicode() {
        if (this.useUnicode && this.unicodeEncoder == null) {
            try {
                this.unicodeEncoder = isLE ? Charset.forName("UTF_16LE").newEncoder() : Charset.forName("UTF_16BE").newEncoder();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.useUnicode;
    }

    static {
        NativeLibLoader.loadLibraries();
        FontDescriptor.initIDs();
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.io.unicode.encoding", "UnicodeBig"));
        isLE = !"UnicodeBig".equals(string);
    }
}

