/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.audio.AudioDevice;

public class AudioPlayer
extends Thread {
    private AudioDevice devAudio;
    private static boolean DEBUG = false;
    public static final AudioPlayer player = AudioPlayer.getAudioPlayer();

    private static ThreadGroup getAudioThreadGroup() {
        if (DEBUG) {
            System.out.println("AudioPlayer.getAudioThreadGroup()");
        }
        ThreadGroup threadGroup = AudioPlayer.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    private static AudioPlayer getAudioPlayer() {
        if (DEBUG) {
            System.out.println("> AudioPlayer.getAudioPlayer()");
        }
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                AudioPlayer audioPlayer = new AudioPlayer();
                audioPlayer.setPriority(10);
                audioPlayer.setDaemon(true);
                audioPlayer.start();
                return audioPlayer;
            }
        };
        AudioPlayer audioPlayer = (AudioPlayer)AccessController.doPrivileged(privilegedAction);
        return audioPlayer;
    }

    private AudioPlayer() {
        super(AudioPlayer.getAudioThreadGroup(), "Audio Player");
        if (DEBUG) {
            System.out.println("> AudioPlayer private constructor");
        }
        this.devAudio = AudioDevice.device;
        this.devAudio.open();
        if (DEBUG) {
            System.out.println("< AudioPlayer private constructor completed");
        }
    }

    public synchronized void start(InputStream inputStream) {
        if (DEBUG) {
            System.out.println("> AudioPlayer.start");
            System.out.println("  InputStream = " + inputStream);
        }
        this.devAudio.openChannel(inputStream);
        this.notify();
        if (DEBUG) {
            System.out.println("< AudioPlayer.start completed");
        }
    }

    public synchronized void stop(InputStream inputStream) {
        if (DEBUG) {
            System.out.println("> AudioPlayer.stop");
        }
        this.devAudio.closeChannel(inputStream);
        if (DEBUG) {
            System.out.println("< AudioPlayer.stop completed");
        }
    }

    public void run() {
        this.devAudio.play();
        if (DEBUG) {
            System.out.println("AudioPlayer mixing loop.");
        }
        try {
            while (true) {
                Thread.sleep(5000L);
            }
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println("AudioPlayer exited.");
            }
            return;
        }
    }
}

