/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sun.font.FontManager;
import sun.font.FontStrikeDesc;
import sun.font.NativeFont;
import sun.font.NativeStrikeDisposer;
import sun.font.PhysicalStrike;
import sun.font.StrikeCache;
import sun.font.StrikeMetrics;

class NativeStrike
extends PhysicalStrike {
    NativeFont nativeFont;
    int numGlyphs;
    AffineTransform invertDevTx;
    AffineTransform fontTx;

    private int getNativePointSize() {
        double[] dArray = new double[4];
        this.desc.glyphTx.getMatrix(dArray);
        this.fontTx = new AffineTransform(dArray);
        if (!this.desc.devTx.isIdentity() && this.desc.devTx.getType() != 1) {
            try {
                this.invertDevTx = this.desc.devTx.createInverse();
                this.fontTx.concatenate(this.invertDevTx);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        Point2D.Float float_ = new Point2D.Float(1.0f, 1.0f);
        this.fontTx.deltaTransform(float_, float_);
        double d = Math.abs(float_.y);
        int n = this.fontTx.getType();
        if ((n & 0xFFFFFFFD) != 0 || this.fontTx.getScaleY() <= 0.0) {
            this.fontTx.scale(1.0 / d, 1.0 / d);
        } else {
            this.fontTx = null;
        }
        return (int)d;
    }

    NativeStrike(NativeFont nativeFont, FontStrikeDesc fontStrikeDesc) {
        super(nativeFont, fontStrikeDesc);
        int n;
        this.nativeFont = nativeFont;
        if (nativeFont.isBitmapDelegate && (((n = fontStrikeDesc.glyphTx.getType()) & 0xFFFFFFFD) != 0 || fontStrikeDesc.glyphTx.getScaleX() <= 0.0)) {
            this.numGlyphs = 0;
            return;
        }
        n = this.getNativePointSize();
        byte[] byArray = nativeFont.getPlatformNameBytes(n);
        double d = Math.abs(fontStrikeDesc.devTx.getScaleX());
        this.pScalerContext = this.createScalerContext(byArray, n, d);
        if (this.pScalerContext == 0L) {
            FontManager.deRegisterBadFont(nativeFont);
            this.pScalerContext = this.createNullScalerContext();
            this.numGlyphs = 0;
            if (FontManager.logging) {
                FontManager.logger.severe("Could not create native strike " + new String(byArray));
            }
            return;
        }
        this.numGlyphs = nativeFont.getMapper().getNumGlyphs();
        this.disposer = new NativeStrikeDisposer(nativeFont, fontStrikeDesc, this.pScalerContext);
    }

    private boolean usingIntGlyphImages() {
        if (this.intGlyphImages != null) {
            return true;
        }
        if (FontManager.longAddresses) {
            return false;
        }
        int n = this.getMaxGlyph(this.pScalerContext);
        if (n < this.numGlyphs) {
            n = this.numGlyphs;
        }
        this.intGlyphImages = new int[n];
        this.disposer.intGlyphImages = this.intGlyphImages;
        return true;
    }

    private long[] getLongGlyphImages() {
        if (this.longGlyphImages == null && FontManager.longAddresses) {
            int n = this.getMaxGlyph(this.pScalerContext);
            if (n < this.numGlyphs) {
                n = this.numGlyphs;
            }
            this.longGlyphImages = new long[n];
            this.disposer.longGlyphImages = this.longGlyphImages;
        }
        return this.longGlyphImages;
    }

    NativeStrike(NativeFont nativeFont, FontStrikeDesc fontStrikeDesc, boolean bl) {
        super(nativeFont, fontStrikeDesc);
        this.nativeFont = nativeFont;
        int n = (int)fontStrikeDesc.glyphTx.getScaleY();
        double d = fontStrikeDesc.devTx.getScaleX();
        byte[] byArray = nativeFont.getPlatformNameBytes(n);
        this.pScalerContext = this.createScalerContext(byArray, n, d);
        int n2 = nativeFont.getMapper().getNumGlyphs();
    }

    StrikeMetrics getFontMetrics() {
        if (this.strikeMetrics == null) {
            if (this.pScalerContext != 0L) {
                this.strikeMetrics = this.nativeFont.getFontMetrics(this.pScalerContext);
            }
            if (this.strikeMetrics != null && this.fontTx != null) {
                this.strikeMetrics.convertToUserSpace(this.fontTx);
            }
        }
        return this.strikeMetrics;
    }

    private native long createScalerContext(byte[] var1, int var2, double var3);

    private native int getMaxGlyph(long var1);

    private native long createNullScalerContext();

    void getGlyphImagePtrs(int[] nArray, long[] lArray, int n) {
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.getGlyphImagePtr(nArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getGlyphImagePtr(int n) {
        if (this.usingIntGlyphImages()) {
            long l = (long)this.intGlyphImages[n] & 0xFFFFFFFFL;
            if (l != 0L) {
                return l;
            }
            l = this.nativeFont.getGlyphImage(this.pScalerContext, n);
            NativeStrike nativeStrike = this;
            synchronized (nativeStrike) {
                if (this.intGlyphImages[n] == 0) {
                    this.intGlyphImages[n] = (int)l;
                    return l;
                }
                StrikeCache.freeIntPointer((int)l);
                return (long)this.intGlyphImages[n] & 0xFFFFFFFFL;
            }
        }
        long l = this.getLongGlyphImages()[n];
        if (l != 0L) {
            return l;
        }
        l = this.nativeFont.getGlyphImage(this.pScalerContext, n);
        NativeStrike nativeStrike = this;
        synchronized (nativeStrike) {
            if (this.longGlyphImages[n] == 0L) {
                this.longGlyphImages[n] = l;
                return l;
            }
            StrikeCache.freeLongPointer(l);
            return this.longGlyphImages[n];
        }
    }

    long getGlyphImagePtrNoCache(int n) {
        return this.nativeFont.getGlyphImageNoDefault(this.pScalerContext, n);
    }

    void getGlyphImageBounds(int n, Point2D.Float float_, Rectangle rectangle) {
    }

    Point2D.Float getGlyphMetrics(int n) {
        Point2D.Float float_ = new Point2D.Float(this.getGlyphAdvance(n), 0.0f);
        return float_;
    }

    float getGlyphAdvance(int n) {
        return this.nativeFont.getGlyphAdvance(this.pScalerContext, n);
    }

    Rectangle2D.Float getGlyphOutlineBounds(int n) {
        return this.nativeFont.getGlyphOutlineBounds(this.pScalerContext, n);
    }

    GeneralPath getGlyphOutline(int n, float f, float f2) {
        return new GeneralPath();
    }

    GeneralPath getGlyphVectorOutline(int[] nArray, float f, float f2) {
        return new GeneralPath();
    }
}

