/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.progress;

import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.progress.ProgressListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.jnlp.DownloadServiceListener;
import sun.awt.AppContext;

public class CustomProgress
implements DownloadServiceListener,
ProgressListener {
    private DownloadServiceListener _dsp = null;
    private ThreadGroup _appThreadGroup = null;
    boolean isLoaded = false;
    Exception exception = null;
    int rescaleBound = -1;
    private final ArrayList queue = new ArrayList();
    private Thread progressThread = null;
    private ProgressQueueChecker checker = null;
    private boolean disposed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillLoaded() throws IOException, JNLPException {
        CustomProgress customProgress = this;
        synchronized (customProgress) {
            while (!this.isLoaded) {
                block8: {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        AppContext appContext = AppContext.getAppContext();
                        if (appContext != null && !appContext.isDisposed()) break block8;
                        return;
                    }
                }
                if (this.exception == null) continue;
                if (this.exception instanceof IOException) {
                    throw (IOException)this.exception;
                }
                if (this.exception instanceof JNLPException) {
                    throw (JNLPException)this.exception;
                }
                throw new RuntimeException(this.exception);
            }
        }
    }

    public synchronized void markLoaded(Exception exception) {
        this.isLoaded = true;
        this.exception = exception;
        this.notifyAll();
    }

    public CustomProgress() {
        this.setupCleanupProcedure();
    }

    public void setListener(DownloadServiceListener downloadServiceListener) {
        this._dsp = downloadServiceListener;
    }

    public void setAppThreadGroup(ThreadGroup threadGroup) {
        this._appThreadGroup = threadGroup;
    }

    public DownloadServiceListener getListener() {
        return this._dsp;
    }

    private int rescale(int n) {
        if (this.rescaleBound == -1) {
            this.rescaleBound = n;
            return 0;
        }
        if (this.rescaleBound == 100) {
            return 100;
        }
        if (n < this.rescaleBound) {
            return 0;
        }
        int n2 = 100 * (n - this.rescaleBound) / (100 - this.rescaleBound);
        return n2;
    }

    public void upgradingArchive(final URL uRL, final String string, final int n, int n2) {
        if (this._dsp != null && this.isReady()) {
            final DownloadServiceListener downloadServiceListener = this._dsp;
            final int n3 = this.rescale(n2);
            this.doRun(new Runnable(){

                public void run() {
                    downloadServiceListener.upgradingArchive(uRL, string, n, n3);
                }
            });
        }
    }

    public void progress(final URL uRL, final String string, final long l, final long l2, int n) {
        if (this._dsp != null && this.isReady()) {
            final DownloadServiceListener downloadServiceListener = this._dsp;
            final int n2 = this.rescale(n);
            Runnable runnable = new Runnable(){

                public void run() {
                    downloadServiceListener.progress(uRL, string, l, l2, n2);
                }
            };
            this.doRun(runnable);
        }
    }

    public void validating(final URL uRL, final String string, final long l, final long l2, int n) {
        if (this._dsp != null && this.isReady()) {
            final DownloadServiceListener downloadServiceListener = this._dsp;
            final int n2 = this.rescale(n);
            Runnable runnable = new Runnable(){

                public void run() {
                    downloadServiceListener.validating(uRL, string, l, l2, n2);
                }
            };
            if (n < 100) {
                this.doRun(runnable);
            } else {
                this.forceRun(runnable);
            }
        }
    }

    public void downloadFailed(final URL uRL, final String string) {
        if (this._dsp != null) {
            final DownloadServiceListener downloadServiceListener = this._dsp;
            this.doRun(new Runnable(){

                public void run() {
                    downloadServiceListener.downloadFailed(uRL, string);
                }
            });
        }
    }

    public void done() {
    }

    public void extensionDownload(String string, int n) {
    }

    public void jreDownload(String string, URL uRL) {
    }

    public void setHeading(String string, boolean bl) {
    }

    public void setStatus(String string) {
    }

    public Component getOwner() {
        return null;
    }

    public void setVisible(boolean bl) {
    }

    public void setProgressBarVisible(boolean bl) {
    }

    public void setProgressBarValue(int n) {
    }

    public void showLaunchingApplication(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush() {
        while (true) {
            ArrayList arrayList = this.queue;
            synchronized (arrayList) {
                if (this.queue.isEmpty()) {
                    return;
                }
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                AppContext appContext = AppContext.getAppContext();
                if (appContext == null || appContext.isDisposed()) return;
                continue;
            }
            break;
        }
    }

    private void setupCleanupProcedure() {
        AppContext appContext = AppContext.getAppContext();
        if (appContext != null) {
            appContext.addPropertyChangeListener("disposed", new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    if (bl) {
                        ArrayList arrayList = CustomProgress.this.queue;
                        synchronized (arrayList) {
                            CustomProgress.this.queue.clear();
                            CustomProgress.this.queue.notifyAll();
                        }
                        CustomProgress.this.checker = null;
                        CustomProgress.this.progressThread = null;
                        CustomProgress.this.disposed = true;
                    }
                }
            });
        }
    }

    private boolean isReady() {
        return this._appThreadGroup != null;
    }

    private void doRun(Runnable runnable) {
        if (this.isReady()) {
            if (this.progressThread == null) {
                if (this.checker == null) {
                    this.checker = new ProgressQueueChecker();
                }
                this.progressThread = new Thread(this._appThreadGroup, this.checker, "javawsApplicationMain");
                this.progressThread.setName("ProgressChecker");
                this.progressThread.setDaemon(true);
                this.progressThread.start();
            }
            this.enQueue(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceRun(Runnable runnable) {
        if (this._appThreadGroup != null) {
            if (this.progressThread == null) {
                if (this.checker == null) {
                    this.checker = new ProgressQueueChecker();
                }
                this.progressThread = new Thread(this._appThreadGroup, this.checker, "javawsApplicationMain");
                this.progressThread.setDaemon(true);
                this.progressThread.start();
            }
            ArrayList arrayList = this.queue;
            synchronized (arrayList) {
                if (!this.disposed) {
                    this.queue.clear();
                    this.queue.add(runnable);
                    this.queue.notifyAll();
                }
            }
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enQueue(Runnable runnable) {
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            if (!this.disposed) {
                this.queue.add(runnable);
                this.queue.notifyAll();
            }
        }
    }

    private class ProgressQueueChecker
    implements Runnable {
        private ProgressQueueChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            var1_1 = null;
            while (true) {
                var2_2 = CustomProgress.access$000(CustomProgress.this);
                synchronized (var2_2) {
                    if (CustomProgress.access$000(CustomProgress.this).isEmpty()) {
                        try {
                            CustomProgress.access$000(CustomProgress.this).wait();
                        }
                        catch (InterruptedException var3_4) {
                            var4_6 = AppContext.getAppContext();
                            if (var4_6 != null && !var4_6.isDisposed()) ** GOTO lbl22
                            return;
                        }
                    } else {
                        try {
                            var1_1 = (Runnable)CustomProgress.access$000(CustomProgress.this).remove(0);
                        }
                        catch (ClassCastException var3_5) {
                            // empty catch block
                        }
                    }
                }
lbl22:
                // 4 sources

                if (var1_1 == null) continue;
                var1_1.run();
            }
        }
    }
}

