/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.ProxyGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{InvocationHandler.class};
    private static Map loaderToCache = new WeakHashMap();
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map proxyClasses = Collections.synchronizedMap(new WeakHashMap());
    protected InvocationHandler h;

    private Proxy() {
    }

    protected Proxy(InvocationHandler invocationHandler) {
        this.h = invocationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... classArray) throws IllegalArgumentException {
        HashMap<List<String>, Object> hashMap;
        Object object;
        HashMap<List<String>, Object> hashMap2;
        if (classArray.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        Class clazz = null;
        String[] stringArray = new String[classArray.length];
        HashSet hashSet = new HashSet();
        for (int i = 0; i < classArray.length; ++i) {
            hashMap2 = classArray[i].getName();
            object = null;
            try {
                object = Class.forName((String)((Object)hashMap2), false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (object != classArray[i]) {
                throw new IllegalArgumentException(classArray[i] + " is not visible from class loader");
            }
            if (!((Class)object).isInterface()) {
                throw new IllegalArgumentException(((Class)object).getName() + " is not an interface");
            }
            if (hashSet.contains(object)) {
                throw new IllegalArgumentException("repeated interface: " + ((Class)object).getName());
            }
            hashSet.add(object);
            stringArray[i] = hashMap2;
        }
        List<String> list = Arrays.asList(stringArray);
        object = loaderToCache;
        synchronized (object) {
            hashMap2 = (Map)loaderToCache.get(classLoader);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<List<String>, Object>();
                loaderToCache.put(classLoader, hashMap2);
            }
        }
        object = hashMap2;
        synchronized (object) {
            while (true) {
                Object v;
                if ((v = hashMap2.get(list)) instanceof Reference) {
                    clazz = (Class)((Reference)v).get();
                }
                if (clazz != null) {
                    return clazz;
                }
                if (v != pendingGenerationMarker) break;
                try {
                    hashMap2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            hashMap2.put(list, pendingGenerationMarker);
        }
        try {
            long l;
            Object object2;
            object = null;
            for (int i = 0; i < classArray.length; ++i) {
                String string;
                int n = classArray[i].getModifiers();
                if (Modifier.isPublic(n)) continue;
                object2 = classArray[i].getName();
                int n2 = ((String)object2).lastIndexOf(46);
                String string2 = string = n2 == -1 ? "" : ((String)object2).substring(0, n2 + 1);
                if (object == null) {
                    object = string;
                    continue;
                }
                if (string.equals(object)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (object == null) {
                object = "";
            }
            object2 = nextUniqueNumberLock;
            synchronized (object2) {
                l = nextUniqueNumber++;
            }
            object2 = (String)object + proxyClassNamePrefix + l;
            byte[] byArray = ProxyGenerator.generateProxyClass((String)object2, classArray);
            try {
                clazz = Proxy.defineClass0(classLoader, (String)object2, byArray, 0, byArray.length);
            }
            catch (ClassFormatError classFormatError) {
                throw new IllegalArgumentException(classFormatError.toString());
            }
            proxyClasses.put(clazz, null);
            Object var15_23 = null;
            hashMap = hashMap2;
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            HashMap<List<String>, Object> hashMap3 = hashMap2;
            synchronized (hashMap3) {
                if (clazz != null) {
                    hashMap2.put(list, new WeakReference<Class>(clazz));
                } else {
                    hashMap2.remove(list);
                }
                hashMap2.notifyAll();
            }
            throw throwable;
        }
        synchronized (hashMap) {
            if (clazz != null) {
                hashMap2.put(list, new WeakReference<Class>(clazz));
            } else {
                hashMap2.remove(list);
            }
            hashMap2.notifyAll();
        }
        return clazz;
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classArray, InvocationHandler invocationHandler) throws IllegalArgumentException {
        if (invocationHandler == null) {
            throw new NullPointerException();
        }
        Class<?> clazz = Proxy.getProxyClass(classLoader, classArray);
        try {
            Constructor<?> constructor = clazz.getConstructor(constructorParams);
            return constructor.newInstance(invocationHandler);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError(instantiationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError(invocationTargetException.toString());
        }
    }

    public static boolean isProxyClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(clazz);
    }

    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        return proxy.h;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);
}

