/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.txw2.output;

import com.sun.xml.internal.txw2.TxwException;
import com.sun.xml.internal.txw2.output.DataWriter;
import com.sun.xml.internal.txw2.output.SaxSerializer;
import com.sun.xml.internal.txw2.output.XMLWriter;
import com.sun.xml.internal.txw2.output.XmlSerializer;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.stream.StreamResult;

public class StreamSerializer
implements XmlSerializer {
    private final SaxSerializer serializer;
    private final XMLWriter writer;

    public StreamSerializer(OutputStream outputStream) {
        this(StreamSerializer.createWriter(outputStream));
    }

    public StreamSerializer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(StreamSerializer.createWriter(outputStream, string));
    }

    public StreamSerializer(Writer writer) {
        this(new StreamResult(writer));
    }

    public StreamSerializer(StreamResult streamResult) {
        final OutputStream[] outputStreamArray = new OutputStream[1];
        if (streamResult.getWriter() != null) {
            this.writer = StreamSerializer.createWriter(streamResult.getWriter());
        } else if (streamResult.getOutputStream() != null) {
            this.writer = StreamSerializer.createWriter(streamResult.getOutputStream());
        } else if (streamResult.getSystemId() != null) {
            String string = streamResult.getSystemId();
            string = this.convertURL(string);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                outputStreamArray[0] = fileOutputStream;
                this.writer = StreamSerializer.createWriter(fileOutputStream);
            }
            catch (IOException iOException) {
                throw new TxwException(iOException);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.serializer = new SaxSerializer(this.writer, this.writer, false){

            public void endDocument() {
                super.endDocument();
                if (outputStreamArray[0] != null) {
                    try {
                        outputStreamArray[0].close();
                    }
                    catch (IOException iOException) {
                        throw new TxwException(iOException);
                    }
                    outputStreamArray[0] = null;
                }
            }
        };
    }

    private StreamSerializer(XMLWriter xMLWriter) {
        this.writer = xMLWriter;
        this.serializer = new SaxSerializer(xMLWriter, xMLWriter, false);
    }

    private String convertURL(String string) {
        string = string.replace('\\', '/');
        string = string.replaceAll("//", "/");
        if ((string = string.replaceAll("//", "/")).startsWith("file:/")) {
            string = string.substring(6).indexOf(":") > 0 ? string.substring(6) : string.substring(5);
        }
        return string;
    }

    public void startDocument() {
        this.serializer.startDocument();
    }

    public void beginStartTag(String string, String string2, String string3) {
        this.serializer.beginStartTag(string, string2, string3);
    }

    public void writeAttribute(String string, String string2, String string3, StringBuilder stringBuilder) {
        this.serializer.writeAttribute(string, string2, string3, stringBuilder);
    }

    public void writeXmlns(String string, String string2) {
        this.serializer.writeXmlns(string, string2);
    }

    public void endStartTag(String string, String string2, String string3) {
        this.serializer.endStartTag(string, string2, string3);
    }

    public void endTag() {
        this.serializer.endTag();
    }

    public void text(StringBuilder stringBuilder) {
        this.serializer.text(stringBuilder);
    }

    public void cdata(StringBuilder stringBuilder) {
        this.serializer.cdata(stringBuilder);
    }

    public void comment(StringBuilder stringBuilder) {
        this.serializer.comment(stringBuilder);
    }

    public void endDocument() {
        this.serializer.endDocument();
    }

    public void flush() {
        this.serializer.flush();
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new TxwException(iOException);
        }
    }

    private static XMLWriter createWriter(Writer writer) {
        DataWriter dataWriter = new DataWriter(new BufferedWriter(writer));
        dataWriter.setIndentStep("  ");
        return dataWriter;
    }

    private static XMLWriter createWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        XMLWriter xMLWriter = StreamSerializer.createWriter(new OutputStreamWriter(outputStream, string));
        xMLWriter.setEncoding(string);
        return xMLWriter;
    }

    private static XMLWriter createWriter(OutputStream outputStream) {
        try {
            return StreamSerializer.createWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException);
        }
    }
}

