/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CPInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    protected int index;

    CPInstruction() {
    }

    protected CPInstruction(short s, int n) {
        super(s, (short)3);
        this.setIndex(n);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        dataOutputStream.writeShort(this.index);
    }

    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index;
    }

    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        String string = constantPool.constantToString(constant);
        if (constant instanceof ConstantClass) {
            string = string.replace('.', '/');
        }
        return Constants.OPCODE_NAMES[this.opcode] + " " + string;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.setIndex(byteSequence.readUnsignedShort());
        this.length = (short)3;
    }

    public final int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.index = n;
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        ConstantPool constantPool = constantPoolGen.getConstantPool();
        String string = constantPool.getConstantString(this.index, (byte)7);
        if (!string.startsWith("[")) {
            string = "L" + string + ";";
        }
        return Type.getType(string);
    }
}

