/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.Timestamp;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpVarBindList
extends Vector {
    public String identity = "VarBindList ";
    Timestamp timestamp;

    public SnmpVarBindList() {
        super(5, 5);
    }

    public SnmpVarBindList(int n) {
        super(n);
    }

    public SnmpVarBindList(String string) {
        super(5, 5);
        this.identity = string;
    }

    public SnmpVarBindList(SnmpVarBindList snmpVarBindList) {
        super(snmpVarBindList.size(), 5);
        snmpVarBindList.copyInto(this.elementData);
        this.elementCount = snmpVarBindList.size();
    }

    public SnmpVarBindList(Vector vector) {
        super(vector.size(), 5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            this.addElement((SnmpVarBind)snmpVarBind.clone());
        }
    }

    public SnmpVarBindList(String string, Vector vector) {
        this(vector);
        this.identity = string;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public final synchronized SnmpVarBind getVarBindAt(int n) {
        return (SnmpVarBind)this.elementAt(n);
    }

    public synchronized int getVarBindCount() {
        return this.size();
    }

    public synchronized Enumeration getVarBindList() {
        return this.elements();
    }

    public final synchronized void setVarBindList(Vector vector) {
        this.setVarBindList(vector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setVarBindList(Vector vector, boolean bl) {
        Vector vector2 = vector;
        synchronized (vector2) {
            int n = vector.size();
            this.setSize(n);
            vector.copyInto(this.elementData);
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i];
                    this.elementData[i] = snmpVarBind.clone();
                }
            }
        }
    }

    public synchronized void addVarBindList(SnmpVarBindList snmpVarBindList) {
        this.ensureCapacity(snmpVarBindList.size() + this.size());
        for (int i = 0; i < snmpVarBindList.size(); ++i) {
            this.addElement(snmpVarBindList.getVarBindAt(i));
        }
    }

    public synchronized boolean removeVarBindList(SnmpVarBindList snmpVarBindList) {
        boolean bl = true;
        for (int i = 0; i < snmpVarBindList.size(); ++i) {
            bl = this.removeElement(snmpVarBindList.getVarBindAt(i));
        }
        return bl;
    }

    public final synchronized void replaceVarBind(SnmpVarBind snmpVarBind, int n) {
        this.setElementAt(snmpVarBind, n);
    }

    public final synchronized void addVarBind(String[] stringArray, String string) throws SnmpStatusException {
        for (int i = 0; i < stringArray.length; ++i) {
            SnmpVarBind snmpVarBind = new SnmpVarBind(stringArray[i]);
            snmpVarBind.addInstance(string);
            this.addElement(snmpVarBind);
        }
    }

    public synchronized boolean removeVarBind(String[] stringArray, String string) throws SnmpStatusException {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            SnmpVarBind snmpVarBind = new SnmpVarBind(stringArray[i]);
            snmpVarBind.addInstance(string);
            int n = this.indexOfOid(snmpVarBind);
            try {
                this.removeElementAt(n);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                bl = false;
            }
        }
        return bl;
    }

    public synchronized void addVarBind(String[] stringArray) throws SnmpStatusException {
        this.addVarBind(stringArray, null);
    }

    public synchronized boolean removeVarBind(String[] stringArray) throws SnmpStatusException {
        return this.removeVarBind(stringArray, null);
    }

    public synchronized void addVarBind(String string) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = new SnmpVarBind(string);
        this.addVarBind(snmpVarBind);
    }

    public synchronized boolean removeVarBind(String string) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = new SnmpVarBind(string);
        int n = this.indexOfOid(snmpVarBind);
        try {
            this.removeElementAt(n);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public synchronized void addVarBind(SnmpVarBind snmpVarBind) {
        this.addElement(snmpVarBind);
    }

    public synchronized boolean removeVarBind(SnmpVarBind snmpVarBind) {
        return this.removeElement(snmpVarBind);
    }

    public synchronized void addInstance(String string) throws SnmpStatusException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ((SnmpVarBind)this.elementData[i]).addInstance(string);
        }
    }

    public final synchronized void concat(Vector vector) {
        this.ensureCapacity(this.size() + vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addElement(enumeration.nextElement());
        }
    }

    public synchronized boolean checkForValidValues() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i];
            if (snmpVarBind.isValidValue()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean checkForUnspecifiedValue() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i];
            if (!snmpVarBind.isUnspecifiedValue()) continue;
            return true;
        }
        return false;
    }

    public synchronized SnmpVarBindList splitAt(int n) {
        SnmpVarBindList snmpVarBindList = null;
        if (n > this.elementCount) {
            return snmpVarBindList;
        }
        snmpVarBindList = new SnmpVarBindList();
        int n2 = this.size();
        for (int i = n; i < n2; ++i) {
            snmpVarBindList.addElement(this.elementData[i]);
        }
        this.elementCount = n;
        this.trimToSize();
        return snmpVarBindList;
    }

    public synchronized int indexOfOid(SnmpVarBind snmpVarBind, int n, int n2) {
        SnmpOid snmpOid = snmpVarBind.getOid();
        for (int i = n; i < n2; ++i) {
            SnmpVarBind snmpVarBind2 = (SnmpVarBind)this.elementData[i];
            if (!snmpOid.equals(snmpVarBind2.getOid())) continue;
            return i;
        }
        return -1;
    }

    public synchronized int indexOfOid(SnmpVarBind snmpVarBind) {
        return this.indexOfOid(snmpVarBind, 0, this.size());
    }

    public synchronized int indexOfOid(SnmpOid snmpOid) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i];
            if (!snmpOid.equals(snmpVarBind.getOid())) continue;
            return i;
        }
        return -1;
    }

    public synchronized SnmpVarBindList cloneWithValue() {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        snmpVarBindList.setTimestamp(this.getTimestamp());
        snmpVarBindList.ensureCapacity(this.size());
        for (int i = 0; i < this.size(); ++i) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i];
            snmpVarBindList.addElement(snmpVarBind.clone());
        }
        return snmpVarBindList;
    }

    public synchronized SnmpVarBindList cloneWithoutValue() {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        int n = this.size();
        snmpVarBindList.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i];
            snmpVarBindList.addElement(snmpVarBind.cloneWithoutValue());
        }
        return snmpVarBindList;
    }

    public synchronized Object clone() {
        return this.cloneWithValue();
    }

    public synchronized Vector toVector(boolean bl) {
        int n = this.elementCount;
        if (!bl) {
            return (Vector)super.clone();
        }
        Vector<Object> vector = new Vector<Object>(n, 5);
        for (int i = 0; i < n; ++i) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i];
            vector.addElement(snmpVarBind.clone());
        }
        return vector;
    }

    public String oidListToString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        for (int i = 0; i < this.elementCount; ++i) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.elementData[i];
            stringBuffer.append(snmpVarBind.getOid().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public synchronized String varBindListToString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        for (int i = 0; i < this.elementCount; ++i) {
            stringBuffer.append(this.elementData[i].toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public void finalize() {
        this.removeAllElements();
    }
}

