/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_xmloff.hxx"
#include <xmloff/xmlimp.hxx>
#include <xmloff/nmspmap.hxx>
#include "xmloff/xmlnmspe.hxx"
#include <xmloff/xmltoken.hxx>
#include <xmloff/xmluconv.hxx>
#include "XMLTextFrameContext.hxx"
#include "XMLTextFrameHyperlinkContext.hxx"

// OD 2004-04-21 #i26791#
#include <txtparaimphint.hxx>

using ::rtl::OUString;
using ::rtl::OUStringBuffer;

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::text;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::beans;
using namespace ::xmloff::token;

TYPEINIT1( XMLTextFrameHyperlinkContext, SvXMLImportContext );

XMLTextFrameHyperlinkContext::XMLTextFrameHyperlinkContext(
		SvXMLImport& rImport,
		sal_uInt16 nPrfx, const OUString& rLName,
		const Reference< XAttributeList > & xAttrList,
		TextContentAnchorType eATyp ) :
	SvXMLImportContext( rImport, nPrfx, rLName ),
	eDefaultAnchorType( eATyp ),
	bMap( sal_False )
{
	OUString sShow;
	const SvXMLTokenMap& rTokenMap =
		GetImport().GetTextImport()->GetTextHyperlinkAttrTokenMap();

	sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	for( sal_Int16 i=0; i < nAttrCount; i++ )
	{
		const OUString& rAttrName = xAttrList->getNameByIndex( i );
		const OUString& rValue = xAttrList->getValueByIndex( i );

		OUString aLocalName;
		sal_uInt16 nPrefix =
			GetImport().GetNamespaceMap().GetKeyByAttrName( rAttrName,
															&aLocalName );
		switch( rTokenMap.Get( nPrefix, aLocalName ) )
		{
		case XML_TOK_TEXT_HYPERLINK_HREF:
			sHRef = GetImport().GetAbsoluteReference( rValue );
			break;
		case XML_TOK_TEXT_HYPERLINK_NAME:
			sName = rValue;
			break;
		case XML_TOK_TEXT_HYPERLINK_TARGET_FRAME:
			sTargetFrameName = rValue;
			break;
		case XML_TOK_TEXT_HYPERLINK_SHOW:
			sShow = rValue;
			break;
		case XML_TOK_TEXT_HYPERLINK_SERVER_MAP:
			{
				sal_Bool bTmp;
				if( rImport.GetMM100UnitConverter().convertBool( bTmp,
																  rValue ) )
				{
					bMap = bTmp;
				}
			}
			break;
		}
	}

	if( sShow.getLength() && !sTargetFrameName.getLength() )
	{
		if( IsXMLToken( sShow, XML_NEW ) )
			sTargetFrameName =
					OUString( RTL_CONSTASCII_USTRINGPARAM("_blank" ) );
		else if( IsXMLToken( sShow, XML_REPLACE ) )
			sTargetFrameName =
					OUString( RTL_CONSTASCII_USTRINGPARAM("_self" ) );
	}
}

XMLTextFrameHyperlinkContext::~XMLTextFrameHyperlinkContext()
{
}

void XMLTextFrameHyperlinkContext::EndElement()
{
}

SvXMLImportContext *XMLTextFrameHyperlinkContext::CreateChildContext(
		sal_uInt16 nPrefix,
		const OUString& rLocalName,
		const Reference< XAttributeList > & xAttrList )
{
	SvXMLImportContext *pContext = 0;
	XMLTextFrameContext *pTextFrameContext = 0;

	if( XML_NAMESPACE_DRAW == nPrefix )
	{
		if( IsXMLToken( rLocalName, XML_FRAME ) )
			pTextFrameContext = new XMLTextFrameContext( GetImport(), nPrefix,
												rLocalName, xAttrList,
												eDefaultAnchorType );
	}

	if( pTextFrameContext )
	{
		pTextFrameContext->SetHyperlink( sHRef, sName, sTargetFrameName, bMap );
		pContext = pTextFrameContext;
		xFrameContext = pContext;
	}
	else
		pContext = new SvXMLImportContext( GetImport(), nPrefix, rLocalName );

	return pContext;
}


TextContentAnchorType XMLTextFrameHyperlinkContext::GetAnchorType() const
{
	if( xFrameContext.Is() )
	{
		SvXMLImportContext *pContext = &xFrameContext;
		return PTR_CAST( XMLTextFrameContext, pContext ) ->GetAnchorType();
	}
	else
		return eDefaultAnchorType;

}

Reference < XTextContent > XMLTextFrameHyperlinkContext::GetTextContent() const
{
	Reference <XTextContent > xTxt;
	if( xFrameContext.Is() )
	{
		SvXMLImportContext *pContext = &xFrameContext;
		xTxt = PTR_CAST( XMLTextFrameContext, pContext )->GetTextContent();
	}

	return xTxt;
}

// --> OD 2004-08-24 #33242#
Reference < drawing::XShape > XMLTextFrameHyperlinkContext::GetShape() const
{
    Reference < drawing::XShape > xShape;
    if( xFrameContext.Is() )
    {
        SvXMLImportContext *pContext = &xFrameContext;
        xShape = PTR_CAST( XMLTextFrameContext, pContext )->GetShape();
    }

    return xShape;
}
// <--


