/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef INCLUDED_SLIDESHOW_PARAMETRICPOLYPOLYGON_HXX
#define INCLUDED_SLIDESHOW_PARAMETRICPOLYPOLYGON_HXX

#include <basegfx/polygon/b2dpolypolygon.hxx>
#include <boost/shared_ptr.hpp>


/* Definition of ParametricPolyPolygon interface */

namespace slideshow
{
    namespace internal
    {
        /** Interface defining a parametric poly-polygon.

        	This interface defines a poly-polygon, whose actual shape
        	is parameterized by a floating point value. This is
        	e.g. used to generically access the various clip polygon
        	generators for transition effects.

            Since for every parametric poly-polygon, there is a set of
            variations, which can easily be generated by simple
            transformations or change in parameter range sweep
            direction, objects implementing this interface only
            generate <em>one</em> prototypical instance of the
            parametric poly-polygon. Generally speaking, the main
            effect direction should be horizontal, it should make
            increasingly more area visible (transition 'in'), and when
            there is a designated direction given, that should be
            left-to-right.
         */
        class ParametricPolyPolygon
        {
        public:
            virtual ~ParametricPolyPolygon() {}

            /** Retrieve the poly-polygon for value t.

                @param t
                Current parameter value to retrieve the corresponding
                poly-polygon for. Permissible values for t must be in
                the range [0,1].

                @return a poly-polygon corresponding to the given
                parameter value. The poly-polygon is interpreted as
                living in the unit rectangle (i.e. [0,1]x[0,1]), but
                is not necessarily constrained to completely lie in
                this area (this very much depends on the actual effect
                to be generated). Although, from a performance
                perspective, it currently <em>is</em> advantageous to
                try to keep the poly-polygon within these bounds (at
                least if there are no hard reasons not to do so),
                because then reversion or out transformations are
                potentially faster to compute (see the
                TransitionInfo::meReverseMethod member in
                transitionfactory.cxx). Furthermore, if one of the
                polygon modifications involve subtraction (also see
                TransitionInfo::meReverseMethod), all generated
                polygons should be oriented clock-wise
                (i.e. traversing the polygon vertices with increasing
                vertex index should generate a clock-wise movement).
             */
            virtual ::basegfx::B2DPolyPolygon operator()( double t ) = 0;
        };

        typedef ::boost::shared_ptr< ParametricPolyPolygon > ParametricPolyPolygonSharedPtr;

    }
}

#endif /* INCLUDED_SLIDESHOW_PARAMETRICPOLYPOLYGON_HXX */
