/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/properties/circleproperties.hxx>
#include <svl/itemset.hxx>
#include <svl/style.hxx>
#include <svx/svddef.hxx>
#include <editeng/eeitem.hxx>
#include <svx/svdocirc.hxx>
#include <svx/sxcikitm.hxx>
#include <svx/sxciaitm.hxx>
#include <svx/sxciaitm.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace properties
	{
		// create a new itemset
		SfxItemSet& CircleProperties::CreateObjectSpecificItemSet(SfxItemPool& rPool)
		{
			return *(new SfxItemSet(rPool,

				// range from SdrAttrObj
				SDRATTR_START, SDRATTR_SHADOW_LAST,
				SDRATTR_MISC_FIRST, SDRATTR_MISC_LAST,
				SDRATTR_TEXTDIRECTION, SDRATTR_TEXTDIRECTION,

				// range from SdrCircObj
				SDRATTR_CIRC_FIRST, SDRATTR_CIRC_LAST,

				// range from SdrTextObj
				EE_ITEMS_START, EE_ITEMS_END,

				// end
				0, 0));
		}

		CircleProperties::CircleProperties(SdrObject& rObj)
		:	RectangleProperties(rObj)
		{
		}

		CircleProperties::CircleProperties(const CircleProperties& rProps, SdrObject& rObj)
		:	RectangleProperties(rProps, rObj)
		{
		}

		CircleProperties::~CircleProperties()
		{
		}
		
		BaseProperties& CircleProperties::Clone(SdrObject& rObj) const
		{
			return *(new CircleProperties(*this, rObj));
		}

		void CircleProperties::ItemSetChanged(const SfxItemSet& rSet)
		{
			SdrCircObj& rObj = (SdrCircObj&)GetSdrObject();

			// call parent
			RectangleProperties::ItemSetChanged(rSet);

			// local changes
			rObj.ImpSetAttrToCircInfo();
		}

		void CircleProperties::SetStyleSheet(SfxStyleSheet* pNewStyleSheet, sal_Bool bDontRemoveHardAttr)
		{
			SdrCircObj& rObj = (SdrCircObj&)GetSdrObject();

			// local changes
			rObj.SetXPolyDirty();

			// call parent
			RectangleProperties::SetStyleSheet(pNewStyleSheet, bDontRemoveHardAttr);

			// local changes
			rObj.ImpSetAttrToCircInfo();
		}

		void CircleProperties::ForceDefaultAttributes()
		{
			SdrCircObj& rObj = (SdrCircObj&)GetSdrObject();
			SdrCircKind eKindA = SDRCIRC_FULL;
			SdrObjKind eKind = rObj.GetCircleKind();

			if(eKind == OBJ_SECT)
			{
				eKindA = SDRCIRC_SECT;
			}
			else if(eKind == OBJ_CARC)
			{
				eKindA = SDRCIRC_ARC;
			}
			else if(eKind == OBJ_CCUT)
			{
				eKindA = SDRCIRC_CUT;
			}

			if(eKindA != SDRCIRC_FULL)
			{
				// force ItemSet
				GetObjectItemSet();

				mpItemSet->Put(SdrCircKindItem(eKindA));

				if(rObj.GetStartWink())
				{
					mpItemSet->Put(SdrCircStartAngleItem(rObj.GetStartWink()));
				}

				if(rObj.GetEndWink() != 36000)
				{
					mpItemSet->Put(SdrCircEndAngleItem(rObj.GetEndWink()));
				}
			}

			// call parent after SetObjectItem(SdrCircKindItem())
			// because ForceDefaultAttr() will call
			// ImpSetAttrToCircInfo() which needs a correct
			// SdrCircKindItem
			RectangleProperties::ForceDefaultAttributes();
		}
	} // end of namespace properties
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
