/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef SC_DRTXTOB_HXX
#define SC_DRTXTOB_HXX

#ifndef _SFX_HXX
#endif

#include <sfx2/shell.hxx>
#include <sfx2/module.hxx>
#include <tools/link.hxx>

#include "shellids.hxx"

sal_uInt16 ScGetFontWorkId();		// statt SvxFontWorkChildWindow::GetChildWindowId()

class ScViewData;
class TransferableDataHelper;
class TransferableClipboardListener;

class ScDrawTextObjectBar : public SfxShell
{
	ScViewData*			pViewData;
	TransferableClipboardListener* pClipEvtLstnr;
	sal_Bool				bPastePossible;

	DECL_LINK( ClipboardChanged, TransferableDataHelper* );

public:
	TYPEINFO();
	SFX_DECL_INTERFACE(SCID_DRAW_TEXT_SHELL)

		ScDrawTextObjectBar(ScViewData* pData);
		~ScDrawTextObjectBar();

	void StateDisableItems( SfxItemSet &rSet );

	void Execute( SfxRequest &rReq );
	void ExecuteTrans( SfxRequest& rReq );
	void GetState( SfxItemSet& rSet );
	void GetClipState( SfxItemSet& rSet );

	void ExecuteAttr( SfxRequest &rReq );
	void GetAttrState( SfxItemSet& rSet );
	void ExecuteToggle( SfxRequest &rReq );

	sal_Bool ExecuteCharDlg( const SfxItemSet& rArgs, SfxItemSet& rOutSet );
	sal_Bool ExecuteParaDlg( const SfxItemSet& rArgs, SfxItemSet& rOutSet );

	void ExecuteExtra( SfxRequest &rReq );
	void ExecFormText(SfxRequest& rReq);		// StarFontWork
	void GetFormTextState(SfxItemSet& rSet);

private:
	void ExecuteGlobal( SfxRequest &rReq );			// von Execute gerufen fuer ganze Objekte
	void GetGlobalClipState( SfxItemSet& rSet );
	void ExecutePasteContents( SfxRequest &rReq );
	sal_Bool IsNoteEdit();
};



#endif

