/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.util.Map;
import sun.management.snmp.jvminstr.JvmRTLibraryPathEntryImpl;
import sun.management.snmp.jvminstr.JvmRuntimeImpl;
import sun.management.snmp.jvmmib.JvmRTLibraryPathTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmRTLibraryPathTableMetaImpl
extends JvmRTLibraryPathTableMeta {
    private SnmpTableCache cache = new JvmRTLibraryPathTableCache(this, -1L);
    static final MibLogger log = new MibLogger(JvmRTLibraryPathTableMetaImpl.class);

    public JvmRTLibraryPathTableMetaImpl(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        super(snmpMib, snmpStandardObjectServer);
    }

    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        return this.getNextOid(null, object);
    }

    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        SnmpTableHandler snmpTableHandler;
        boolean bl = log.isDebugOn();
        if (bl) {
            log.debug("getNextOid", "previous=" + snmpOid);
        }
        if ((snmpTableHandler = this.getHandler(object)) == null) {
            if (bl) {
                log.debug("getNextOid", "handler is null!");
            }
            throw new SnmpStatusException(224);
        }
        SnmpOid snmpOid2 = snmpTableHandler.getNext(snmpOid);
        if (bl) {
            log.debug("*** **** **** **** getNextOid", "next=" + snmpOid2);
        }
        if (snmpOid2 == null) {
            throw new SnmpStatusException(224);
        }
        return snmpOid2;
    }

    protected boolean contains(SnmpOid snmpOid, Object object) {
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            return false;
        }
        return snmpTableHandler.contains(snmpOid);
    }

    public Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        Object object;
        String string;
        boolean bl = log.isDebugOn();
        if (bl) {
            log.debug("getEntry", "oid [" + snmpOid + "]");
        }
        if (snmpOid == null || snmpOid.getLength() != 1) {
            if (bl) {
                log.debug("getEntry", "Invalid oid [" + snmpOid + "]");
            }
            throw new SnmpStatusException(224);
        }
        Map map = JvmContextFactory.getUserData();
        String string2 = string = map == null ? null : "JvmRTLibraryPathTable.entry." + snmpOid.toString();
        if (map != null) {
            object = map.get(string);
            if (object != null) {
                if (bl) {
                    log.debug("getEntry", "Entry is already in the cache");
                }
                return object;
            }
            if (bl) {
                log.debug("getEntry", "Entry is not in the cache");
            }
        }
        if ((object = this.getHandler(map)) == null) {
            throw new SnmpStatusException(224);
        }
        Object object2 = object.getData(snmpOid);
        if (object2 == null) {
            throw new SnmpStatusException(224);
        }
        if (bl) {
            log.debug("getEntry", "data is a: " + object2.getClass().getName());
        }
        JvmRTLibraryPathEntryImpl jvmRTLibraryPathEntryImpl = new JvmRTLibraryPathEntryImpl((String)object2, (int)snmpOid.getOidArc(0));
        if (map != null && jvmRTLibraryPathEntryImpl != null) {
            map.put(string, jvmRTLibraryPathEntryImpl);
        }
        return jvmRTLibraryPathEntryImpl;
    }

    protected SnmpTableHandler getHandler(Object object) {
        SnmpTableHandler snmpTableHandler;
        Map map = object instanceof Map ? (Map)object : null;
        if (map != null && (snmpTableHandler = (SnmpTableHandler)map.get("JvmRTLibraryPathTable.handler")) != null) {
            return snmpTableHandler;
        }
        snmpTableHandler = this.cache.getTableHandler();
        if (map != null && snmpTableHandler != null) {
            map.put("JvmRTLibraryPathTable.handler", snmpTableHandler);
        }
        return snmpTableHandler;
    }

    private static class JvmRTLibraryPathTableCache
    extends SnmpTableCache {
        private JvmRTLibraryPathTableMetaImpl meta;

        JvmRTLibraryPathTableCache(JvmRTLibraryPathTableMetaImpl jvmRTLibraryPathTableMetaImpl, long l) {
            this.meta = jvmRTLibraryPathTableMetaImpl;
            this.validity = l;
        }

        public SnmpTableHandler getTableHandler() {
            Map map = JvmContextFactory.getUserData();
            return this.getTableDatas(map);
        }

        protected SnmpCachedData updateCachedDatas(Object object) {
            Object[] objectArray = JvmRuntimeImpl.getLibraryPath(object);
            long l = System.currentTimeMillis();
            int n = objectArray.length;
            SnmpOid[] snmpOidArray = new SnmpOid[n];
            for (int i = 0; i < n; ++i) {
                snmpOidArray[i] = new SnmpOid(i + 1);
            }
            return new SnmpCachedData(l, snmpOidArray, objectArray);
        }
    }
}

