/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class ProcessPath {
    public static final int PH_MODE_DRAW_CLIP = 0;
    public static final int PH_MODE_FILL_CLIP = 1;
    public static EndSubPathHandler noopEndSubPathHandler = new EndSubPathHandler(){

        public void processEndSubPath() {
        }
    };
    private static final float UPPER_BND = 8.5070587E37f;
    private static final float LOWER_BND = -8.5070587E37f;
    private static final int FWD_PREC = 7;
    private static final int MDP_PREC = 10;
    private static final int MDP_MULT = 1024;
    private static final int MDP_HALF_MULT = 512;
    private static final int UPPER_OUT_BND = 0x100000;
    private static final int LOWER_OUT_BND = -1048576;
    private static final float CALC_UBND = 1048576.0f;
    private static final float CALC_LBND = -1048576.0f;
    public static final int EPSFX = 1;
    public static final float EPSF = 9.765625E-4f;
    private static final int MDP_W_MASK = -1024;
    private static final int MDP_F_MASK = 1023;
    private static final int MAX_CUB_SIZE = 256;
    private static final int MAX_QUAD_SIZE = 1024;
    private static final int DF_CUB_STEPS = 3;
    private static final int DF_QUAD_STEPS = 2;
    private static final int DF_CUB_SHIFT = 6;
    private static final int DF_QUAD_SHIFT = 1;
    private static final int DF_CUB_COUNT = 8;
    private static final int DF_QUAD_COUNT = 4;
    private static final int DF_CUB_DEC_BND = 262144;
    private static final int DF_CUB_INC_BND = 32768;
    private static final int DF_QUAD_DEC_BND = 8192;
    private static final int DF_QUAD_INC_BND = 1024;
    private static final int CUB_A_SHIFT = 7;
    private static final int CUB_B_SHIFT = 11;
    private static final int CUB_C_SHIFT = 13;
    private static final int CUB_A_MDP_MULT = 128;
    private static final int CUB_B_MDP_MULT = 2048;
    private static final int CUB_C_MDP_MULT = 8192;
    private static final int QUAD_A_SHIFT = 7;
    private static final int QUAD_B_SHIFT = 9;
    private static final int QUAD_A_MDP_MULT = 128;
    private static final int QUAD_B_MDP_MULT = 512;
    private static final int CRES_MIN_CLIPPED = 0;
    private static final int CRES_MAX_CLIPPED = 1;
    private static final int CRES_NOT_CLIPPED = 3;
    private static final int CRES_INVISIBLE = 4;
    private static final int DF_MAX_POINT = 256;

    public static boolean fillPath(DrawHandler drawHandler, Path2D.Float float_, int n, int n2) {
        FillProcessHandler fillProcessHandler = new FillProcessHandler(drawHandler);
        if (!ProcessPath.doProcessPath(fillProcessHandler, float_, n, n2)) {
            return false;
        }
        ProcessPath.FillPolygon(fillProcessHandler, float_.getWindingRule());
        return true;
    }

    public static boolean drawPath(DrawHandler drawHandler, EndSubPathHandler endSubPathHandler, Path2D.Float float_, int n, int n2) {
        return ProcessPath.doProcessPath(new DrawProcessHandler(drawHandler, endSubPathHandler), float_, n, n2);
    }

    public static boolean drawPath(DrawHandler drawHandler, Path2D.Float float_, int n, int n2) {
        return ProcessPath.doProcessPath(new DrawProcessHandler(drawHandler, noopEndSubPathHandler), float_, n, n2);
    }

    private static float CLIP(float f, float f2, float f3, float f4, double d) {
        return (float)((double)f2 + (d - (double)f) * (double)(f4 - f2) / (double)(f3 - f));
    }

    private static int CLIP(int n, int n2, int n3, int n4, double d) {
        return (int)((double)n2 + (d - (double)n) * (double)(n4 - n2) / (double)(n3 - n));
    }

    private static boolean IS_CLIPPED(int n) {
        return n == 0 || n == 1;
    }

    private static int TESTANDCLIP(float f, float f2, float[] fArray, int n, int n2, int n3, int n4) {
        int n5 = 3;
        if (fArray[n] < f || fArray[n] > f2) {
            double d;
            if (fArray[n] < f) {
                if (fArray[n3] < f) {
                    return 4;
                }
                n5 = 0;
                d = f;
            } else {
                if (fArray[n3] > f2) {
                    return 4;
                }
                n5 = 1;
                d = f2;
            }
            fArray[n2] = ProcessPath.CLIP(fArray[n], fArray[n2], fArray[n3], fArray[n4], d);
            fArray[n] = (float)d;
        }
        return n5;
    }

    private static int TESTANDCLIP(int n, int n2, int[] nArray, int n3, int n4, int n5, int n6) {
        int n7 = 3;
        if (nArray[n3] < n || nArray[n3] > n2) {
            double d;
            if (nArray[n3] < n) {
                if (nArray[n5] < n) {
                    return 4;
                }
                n7 = 0;
                d = n;
            } else {
                if (nArray[n5] > n2) {
                    return 4;
                }
                n7 = 1;
                d = n2;
            }
            nArray[n4] = ProcessPath.CLIP(nArray[n3], nArray[n4], nArray[n5], nArray[n6], d);
            nArray[n3] = (int)d;
        }
        return n7;
    }

    private static int CLIPCLAMP(float f, float f2, float[] fArray, int n, int n2, int n3, int n4, int n5, int n6) {
        fArray[n5] = fArray[n];
        fArray[n6] = fArray[n2];
        int n7 = ProcessPath.TESTANDCLIP(f, f2, fArray, n, n2, n3, n4);
        if (n7 == 0) {
            fArray[n5] = fArray[n];
        } else if (n7 == 1) {
            fArray[n5] = fArray[n];
            n7 = 1;
        } else if (n7 == 4) {
            if (fArray[n] > f2) {
                n7 = 4;
            } else {
                fArray[n] = f;
                fArray[n3] = f;
                n7 = 3;
            }
        }
        return n7;
    }

    private static int CLIPCLAMP(int n, int n2, int[] nArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        nArray[n7] = nArray[n3];
        nArray[n8] = nArray[n4];
        int n9 = ProcessPath.TESTANDCLIP(n, n2, nArray, n3, n4, n5, n6);
        if (n9 == 0) {
            nArray[n7] = nArray[n3];
        } else if (n9 == 1) {
            nArray[n7] = nArray[n3];
            n9 = 1;
        } else if (n9 == 4) {
            if (nArray[n3] > n2) {
                n9 = 4;
            } else {
                nArray[n3] = n;
                nArray[n5] = n;
                n9 = 3;
            }
        }
        return n9;
    }

    private static void DrawMonotonicQuad(ProcessHandler processHandler, float[] fArray, boolean bl, int[] nArray) {
        int n = (int)(fArray[0] * 1024.0f);
        int n2 = (int)(fArray[1] * 1024.0f);
        int n3 = (int)(fArray[4] * 1024.0f);
        int n4 = (int)(fArray[5] * 1024.0f);
        int n5 = (n & 0x3FF) << 1;
        int n6 = (n2 & 0x3FF) << 1;
        int n7 = 4;
        int n8 = 1;
        int n9 = (int)((fArray[0] - 2.0f * fArray[2] + fArray[4]) * 128.0f);
        int n10 = (int)((fArray[1] - 2.0f * fArray[3] + fArray[5]) * 128.0f);
        int n11 = (int)((-2.0f * fArray[0] + 2.0f * fArray[2]) * 512.0f);
        int n12 = (int)((-2.0f * fArray[1] + 2.0f * fArray[3]) * 512.0f);
        int n13 = 2 * n9;
        int n14 = 2 * n10;
        int n15 = n9 + n11;
        int n16 = n10 + n12;
        int n17 = n;
        int n18 = n2;
        int n19 = Math.max(Math.abs(n13), Math.abs(n14));
        int n20 = n3 - n;
        int n21 = n4 - n2;
        int n22 = n & 0xFFFFFC00;
        int n23 = n2 & 0xFFFFFC00;
        while (n19 > 8192) {
            n15 = (n15 << 1) - n9;
            n16 = (n16 << 1) - n10;
            n7 <<= 1;
            n19 >>= 2;
            n5 <<= 2;
            n6 <<= 2;
            n8 += 2;
        }
        while (n7-- > 1) {
            n5 += n15;
            n6 += n16;
            n15 += n13;
            n16 += n14;
            int n24 = n17;
            int n25 = n18;
            n17 = n22 + (n5 >> n8);
            n18 = n23 + (n6 >> n8);
            if ((n3 - n17 ^ n20) < 0) {
                n17 = n3;
            }
            if ((n4 - n18 ^ n21) < 0) {
                n18 = n4;
            }
            processHandler.processFixedLine(n24, n25, n17, n18, nArray, bl, false);
        }
        processHandler.processFixedLine(n17, n18, n3, n4, nArray, bl, false);
    }

    private static void ProcessMonotonicQuad(ProcessHandler processHandler, float[] fArray, int[] nArray) {
        float f;
        float f2;
        float[] fArray2 = new float[6];
        float f3 = f2 = fArray[0];
        float f4 = f = fArray[1];
        for (int i = 2; i < 6; i += 2) {
            f3 = f3 > fArray[i] ? fArray[i] : f3;
            f2 = f2 < fArray[i] ? fArray[i] : f2;
            f4 = f4 > fArray[i + 1] ? fArray[i + 1] : f4;
            f = f < fArray[i + 1] ? fArray[i + 1] : f;
        }
        if (processHandler.clipMode == 0) {
            if (processHandler.dhnd.xMaxf < f3 || processHandler.dhnd.xMinf > f2 || processHandler.dhnd.yMaxf < f4 || processHandler.dhnd.yMinf > f) {
                return;
            }
        } else {
            if (processHandler.dhnd.yMaxf < f4 || processHandler.dhnd.yMinf > f || processHandler.dhnd.xMaxf < f3) {
                return;
            }
            if (processHandler.dhnd.xMinf > f2) {
                fArray[2] = fArray[4] = processHandler.dhnd.xMinf;
                fArray[0] = fArray[4];
            }
        }
        if (f2 - f3 > 1024.0f || f - f4 > 1024.0f) {
            fArray2[4] = fArray[4];
            fArray2[5] = fArray[5];
            fArray2[2] = (fArray[2] + fArray[4]) / 2.0f;
            fArray2[3] = (fArray[3] + fArray[5]) / 2.0f;
            fArray[2] = (fArray[0] + fArray[2]) / 2.0f;
            fArray[3] = (fArray[1] + fArray[3]) / 2.0f;
            fArray[4] = fArray2[0] = (fArray[2] + fArray2[2]) / 2.0f;
            fArray[5] = fArray2[1] = (fArray[3] + fArray2[3]) / 2.0f;
            ProcessPath.ProcessMonotonicQuad(processHandler, fArray, nArray);
            ProcessPath.ProcessMonotonicQuad(processHandler, fArray2, nArray);
        } else {
            ProcessPath.DrawMonotonicQuad(processHandler, fArray, processHandler.dhnd.xMinf >= f3 || processHandler.dhnd.xMaxf <= f2 || processHandler.dhnd.yMinf >= f4 || processHandler.dhnd.yMaxf <= f, nArray);
        }
    }

    private static void ProcessQuad(ProcessHandler processHandler, float[] fArray, int[] nArray) {
        double d;
        double d2;
        double d3;
        double[] dArray = new double[2];
        int n = 0;
        if ((fArray[0] > fArray[2] || fArray[2] > fArray[4]) && (fArray[0] < fArray[2] || fArray[2] < fArray[4]) && (d3 = (double)(fArray[0] - 2.0f * fArray[2] + fArray[4])) != 0.0 && (d2 = (d = (double)(fArray[0] - fArray[2])) / d3) < 1.0 && d2 > 0.0) {
            dArray[n++] = d2;
        }
        if ((fArray[1] > fArray[3] || fArray[3] > fArray[5]) && (fArray[1] < fArray[3] || fArray[3] < fArray[5]) && (d3 = (double)(fArray[1] - 2.0f * fArray[3] + fArray[5])) != 0.0 && (d2 = (d = (double)(fArray[1] - fArray[3])) / d3) < 1.0 && d2 > 0.0) {
            if (n > 0) {
                if (dArray[0] > d2) {
                    dArray[n++] = dArray[0];
                    dArray[0] = d2;
                } else if (dArray[0] < d2) {
                    dArray[n++] = d2;
                }
            } else {
                dArray[n++] = d2;
            }
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                ProcessPath.ProcessFirstMonotonicPartOfQuad(processHandler, fArray, nArray, (float)dArray[0]);
                break;
            }
            case 2: {
                ProcessPath.ProcessFirstMonotonicPartOfQuad(processHandler, fArray, nArray, (float)dArray[0]);
                d2 = dArray[1] - dArray[0];
                if (!(d2 > 0.0)) break;
                ProcessPath.ProcessFirstMonotonicPartOfQuad(processHandler, fArray, nArray, (float)(d2 / (1.0 - dArray[0])));
            }
        }
        ProcessPath.ProcessMonotonicQuad(processHandler, fArray, nArray);
    }

    private static void ProcessFirstMonotonicPartOfQuad(ProcessHandler processHandler, float[] fArray, int[] nArray, float f) {
        float[] fArray2 = new float[6];
        fArray2[0] = fArray[0];
        fArray2[1] = fArray[1];
        fArray2[2] = fArray[0] + f * (fArray[2] - fArray[0]);
        fArray2[3] = fArray[1] + f * (fArray[3] - fArray[1]);
        fArray[2] = fArray[2] + f * (fArray[4] - fArray[2]);
        fArray[3] = fArray[3] + f * (fArray[5] - fArray[3]);
        fArray[0] = fArray2[4] = fArray2[2] + f * (fArray[2] - fArray2[2]);
        fArray[1] = fArray2[5] = fArray2[3] + f * (fArray[3] - fArray2[3]);
        ProcessPath.ProcessMonotonicQuad(processHandler, fArray2, nArray);
    }

    private static void DrawMonotonicCubic(ProcessHandler processHandler, float[] fArray, boolean bl, int[] nArray) {
        int n = (int)(fArray[0] * 1024.0f);
        int n2 = (int)(fArray[1] * 1024.0f);
        int n3 = (int)(fArray[6] * 1024.0f);
        int n4 = (int)(fArray[7] * 1024.0f);
        int n5 = (n & 0x3FF) << 6;
        int n6 = (n2 & 0x3FF) << 6;
        int n7 = 32768;
        int n8 = 262144;
        int n9 = 8;
        int n10 = 6;
        int n11 = (int)((-fArray[0] + 3.0f * fArray[2] - 3.0f * fArray[4] + fArray[6]) * 128.0f);
        int n12 = (int)((-fArray[1] + 3.0f * fArray[3] - 3.0f * fArray[5] + fArray[7]) * 128.0f);
        int n13 = (int)((3.0f * fArray[0] - 6.0f * fArray[2] + 3.0f * fArray[4]) * 2048.0f);
        int n14 = (int)((3.0f * fArray[1] - 6.0f * fArray[3] + 3.0f * fArray[5]) * 2048.0f);
        int n15 = (int)((-3.0f * fArray[0] + 3.0f * fArray[2]) * 8192.0f);
        int n16 = (int)((-3.0f * fArray[1] + 3.0f * fArray[3]) * 8192.0f);
        int n17 = 6 * n11;
        int n18 = 6 * n12;
        int n19 = n17 + n13;
        int n20 = n18 + n14;
        int n21 = n11 + (n13 >> 1) + n15;
        int n22 = n12 + (n14 >> 1) + n16;
        int n23 = n;
        int n24 = n2;
        int n25 = n & 0xFFFFFC00;
        int n26 = n2 & 0xFFFFFC00;
        int n27 = n3 - n;
        int n28 = n4 - n2;
        while (n9 > 0) {
            while (Math.abs(n19) > n8 || Math.abs(n20) > n8) {
                n19 = (n19 << 1) - n17;
                n20 = (n20 << 1) - n18;
                n21 = (n21 << 2) - (n19 >> 1);
                n22 = (n22 << 2) - (n20 >> 1);
                n9 <<= 1;
                n8 <<= 3;
                n7 <<= 3;
                n5 <<= 3;
                n6 <<= 3;
                n10 += 3;
            }
            while ((n9 & 1) == 0 && n10 > 6 && Math.abs(n21) <= n7 && Math.abs(n22) <= n7) {
                n21 = (n21 >> 2) + (n19 >> 3);
                n22 = (n22 >> 2) + (n20 >> 3);
                n19 = n19 + n17 >> 1;
                n20 = n20 + n18 >> 1;
                n9 >>= 1;
                n8 >>= 3;
                n7 >>= 3;
                n5 >>= 3;
                n6 >>= 3;
                n10 -= 3;
            }
            if (--n9 > 0) {
                n5 += n21;
                n6 += n22;
                n21 += n19;
                n22 += n20;
                n19 += n17;
                n20 += n18;
                int n29 = n23;
                int n30 = n24;
                n23 = n25 + (n5 >> n10);
                n24 = n26 + (n6 >> n10);
                if ((n3 - n23 ^ n27) < 0) {
                    n23 = n3;
                }
                if ((n4 - n24 ^ n28) < 0) {
                    n24 = n4;
                }
                processHandler.processFixedLine(n29, n30, n23, n24, nArray, bl, false);
                continue;
            }
            processHandler.processFixedLine(n23, n24, n3, n4, nArray, bl, false);
        }
    }

    private static void ProcessMonotonicCubic(ProcessHandler processHandler, float[] fArray, int[] nArray) {
        float f;
        float f2;
        float[] fArray2 = new float[8];
        float f3 = f2 = fArray[0];
        float f4 = f = fArray[1];
        for (int i = 2; i < 8; i += 2) {
            f3 = f3 > fArray[i] ? fArray[i] : f3;
            f2 = f2 < fArray[i] ? fArray[i] : f2;
            f4 = f4 > fArray[i + 1] ? fArray[i + 1] : f4;
            f = f < fArray[i + 1] ? fArray[i + 1] : f;
        }
        if (processHandler.clipMode == 0) {
            if (processHandler.dhnd.xMaxf < f3 || processHandler.dhnd.xMinf > f2 || processHandler.dhnd.yMaxf < f4 || processHandler.dhnd.yMinf > f) {
                return;
            }
        } else {
            if (processHandler.dhnd.yMaxf < f4 || processHandler.dhnd.yMinf > f || processHandler.dhnd.xMaxf < f3) {
                return;
            }
            if (processHandler.dhnd.xMinf > f2) {
                fArray[4] = fArray[6] = processHandler.dhnd.xMinf;
                fArray[2] = fArray[6];
                fArray[0] = fArray[6];
            }
        }
        if (f2 - f3 > 256.0f || f - f4 > 256.0f) {
            fArray2[6] = fArray[6];
            fArray2[7] = fArray[7];
            fArray2[4] = (fArray[4] + fArray[6]) / 2.0f;
            fArray2[5] = (fArray[5] + fArray[7]) / 2.0f;
            float f5 = (fArray[2] + fArray[4]) / 2.0f;
            float f6 = (fArray[3] + fArray[5]) / 2.0f;
            fArray2[2] = (f5 + fArray2[4]) / 2.0f;
            fArray2[3] = (f6 + fArray2[5]) / 2.0f;
            fArray[2] = (fArray[0] + fArray[2]) / 2.0f;
            fArray[3] = (fArray[1] + fArray[3]) / 2.0f;
            fArray[4] = (fArray[2] + f5) / 2.0f;
            fArray[5] = (fArray[3] + f6) / 2.0f;
            fArray[6] = fArray2[0] = (fArray[4] + fArray2[2]) / 2.0f;
            fArray[7] = fArray2[1] = (fArray[5] + fArray2[3]) / 2.0f;
            ProcessPath.ProcessMonotonicCubic(processHandler, fArray, nArray);
            ProcessPath.ProcessMonotonicCubic(processHandler, fArray2, nArray);
        } else {
            ProcessPath.DrawMonotonicCubic(processHandler, fArray, processHandler.dhnd.xMinf > f3 || processHandler.dhnd.xMaxf < f2 || processHandler.dhnd.yMinf > f4 || processHandler.dhnd.yMaxf < f, nArray);
        }
    }

    private static void ProcessCubic(ProcessHandler processHandler, float[] fArray, int[] nArray) {
        int n;
        int n2;
        double[] dArray = new double[4];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[2];
        int n3 = 0;
        if ((fArray[0] > fArray[2] || fArray[2] > fArray[4] || fArray[4] > fArray[6]) && (fArray[0] < fArray[2] || fArray[2] < fArray[4] || fArray[4] < fArray[6])) {
            dArray2[2] = -fArray[0] + 3.0f * fArray[2] - 3.0f * fArray[4] + fArray[6];
            dArray2[1] = 2.0f * (fArray[0] - 2.0f * fArray[2] + fArray[4]);
            dArray2[0] = -fArray[0] + fArray[2];
            n2 = QuadCurve2D.solveQuadratic(dArray2, dArray3);
            for (n = 0; n < n2; ++n) {
                if (!(dArray3[n] > 0.0) || !(dArray3[n] < 1.0)) continue;
                dArray[n3++] = dArray3[n];
            }
        }
        if ((fArray[1] > fArray[3] || fArray[3] > fArray[5] || fArray[5] > fArray[7]) && (fArray[1] < fArray[3] || fArray[3] < fArray[5] || fArray[5] < fArray[7])) {
            dArray2[2] = -fArray[1] + 3.0f * fArray[3] - 3.0f * fArray[5] + fArray[7];
            dArray2[1] = 2.0f * (fArray[1] - 2.0f * fArray[3] + fArray[5]);
            dArray2[0] = -fArray[1] + fArray[3];
            n2 = QuadCurve2D.solveQuadratic(dArray2, dArray3);
            for (n = 0; n < n2; ++n) {
                if (!(dArray3[n] > 0.0) || !(dArray3[n] < 1.0)) continue;
                dArray[n3++] = dArray3[n];
            }
        }
        if (n3 > 0) {
            Arrays.sort(dArray, 0, n3);
            ProcessPath.ProcessFirstMonotonicPartOfCubic(processHandler, fArray, nArray, (float)dArray[0]);
            for (n2 = 1; n2 < n3; ++n2) {
                double d = dArray[n2] - dArray[n2 - 1];
                if (!(d > 0.0)) continue;
                ProcessPath.ProcessFirstMonotonicPartOfCubic(processHandler, fArray, nArray, (float)(d / (1.0 - dArray[n2 - 1])));
            }
        }
        ProcessPath.ProcessMonotonicCubic(processHandler, fArray, nArray);
    }

    private static void ProcessFirstMonotonicPartOfCubic(ProcessHandler processHandler, float[] fArray, int[] nArray, float f) {
        float[] fArray2 = new float[8];
        fArray2[0] = fArray[0];
        fArray2[1] = fArray[1];
        float f2 = fArray[2] + f * (fArray[4] - fArray[2]);
        float f3 = fArray[3] + f * (fArray[5] - fArray[3]);
        fArray2[2] = fArray[0] + f * (fArray[2] - fArray[0]);
        fArray2[3] = fArray[1] + f * (fArray[3] - fArray[1]);
        fArray2[4] = fArray2[2] + f * (f2 - fArray2[2]);
        fArray2[5] = fArray2[3] + f * (f3 - fArray2[3]);
        fArray[4] = fArray[4] + f * (fArray[6] - fArray[4]);
        fArray[5] = fArray[5] + f * (fArray[7] - fArray[5]);
        fArray[2] = f2 + f * (fArray[4] - f2);
        fArray[3] = f3 + f * (fArray[5] - f3);
        fArray[0] = fArray2[6] = fArray2[4] + f * (fArray[2] - fArray2[4]);
        fArray[1] = fArray2[7] = fArray2[5] + f * (fArray[3] - fArray2[5]);
        ProcessPath.ProcessMonotonicCubic(processHandler, fArray2, nArray);
    }

    private static void ProcessLine(ProcessHandler processHandler, float f, float f2, float f3, float f4, int[] nArray) {
        boolean bl = false;
        float[] fArray = new float[]{f, f2, f3, f4, 0.0f, 0.0f};
        float f5 = processHandler.dhnd.xMinf;
        float f6 = processHandler.dhnd.yMinf;
        float f7 = processHandler.dhnd.xMaxf;
        float f8 = processHandler.dhnd.yMaxf;
        int n = ProcessPath.TESTANDCLIP(f6, f8, fArray, 1, 0, 3, 2);
        if (n == 4) {
            return;
        }
        bl = ProcessPath.IS_CLIPPED(n);
        n = ProcessPath.TESTANDCLIP(f6, f8, fArray, 3, 2, 1, 0);
        if (n == 4) {
            return;
        }
        boolean bl2 = ProcessPath.IS_CLIPPED(n);
        boolean bl3 = bl = bl || bl2;
        if (processHandler.clipMode == 0) {
            n = ProcessPath.TESTANDCLIP(f5, f7, fArray, 0, 1, 2, 3);
            if (n == 4) {
                return;
            }
            bl = bl || ProcessPath.IS_CLIPPED(n);
            n = ProcessPath.TESTANDCLIP(f5, f7, fArray, 2, 3, 0, 1);
            if (n == 4) {
                return;
            }
            bl2 = bl2 || ProcessPath.IS_CLIPPED(n);
            bl = bl || bl2;
            int n2 = (int)(fArray[0] * 1024.0f);
            int n3 = (int)(fArray[1] * 1024.0f);
            int n4 = (int)(fArray[2] * 1024.0f);
            int n5 = (int)(fArray[3] * 1024.0f);
            processHandler.processFixedLine(n2, n3, n4, n5, nArray, bl, bl2);
        } else {
            int n6;
            int n7;
            n = ProcessPath.CLIPCLAMP(f5, f7, fArray, 0, 1, 2, 3, 4, 5);
            int n8 = (int)(fArray[0] * 1024.0f);
            int n9 = (int)(fArray[1] * 1024.0f);
            if (n == 0) {
                n7 = (int)(fArray[4] * 1024.0f);
                n6 = (int)(fArray[5] * 1024.0f);
                processHandler.processFixedLine(n7, n6, n8, n9, nArray, false, bl2);
            } else if (n == 4) {
                return;
            }
            n = ProcessPath.CLIPCLAMP(f5, f7, fArray, 2, 3, 0, 1, 4, 5);
            bl2 = bl2 || n == 1;
            int n10 = (int)(fArray[2] * 1024.0f);
            int n11 = (int)(fArray[3] * 1024.0f);
            processHandler.processFixedLine(n8, n9, n10, n11, nArray, false, bl2);
            if (n == 0) {
                n7 = (int)(fArray[4] * 1024.0f);
                n6 = (int)(fArray[5] * 1024.0f);
                processHandler.processFixedLine(n10, n11, n7, n6, nArray, false, bl2);
            }
        }
    }

    private static boolean doProcessPath(ProcessHandler processHandler, Path2D.Float float_, float f, float f2) {
        float[] fArray = new float[8];
        float[] fArray2 = new float[8];
        float[] fArray3 = new float[]{0.0f, 0.0f};
        float[] fArray4 = new float[2];
        int[] nArray = new int[5];
        boolean bl = false;
        boolean bl2 = false;
        nArray[0] = 0;
        processHandler.dhnd.adjustBounds(-1048576, -1048576, 0x100000, 0x100000);
        if (processHandler.dhnd.strokeControl == 2) {
            fArray3[0] = -0.5f;
            fArray3[1] = -0.5f;
            f = (float)((double)f - 0.5);
            f2 = (float)((double)f2 - 0.5);
        }
        PathIterator pathIterator = float_.getPathIterator(null);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (bl && !bl2) {
                        if (processHandler.clipMode == 1 && (fArray2[0] != fArray3[0] || fArray2[1] != fArray3[1])) {
                            ProcessPath.ProcessLine(processHandler, fArray2[0], fArray2[1], fArray3[0], fArray3[1], nArray);
                        }
                        processHandler.processEndSubPath();
                    }
                    fArray2[0] = fArray[0] + f;
                    fArray2[1] = fArray[1] + f2;
                    if (fArray2[0] < 8.5070587E37f && fArray2[0] > -8.5070587E37f && fArray2[1] < 8.5070587E37f && fArray2[1] > -8.5070587E37f) {
                        bl = true;
                        bl2 = false;
                        fArray3[0] = fArray2[0];
                        fArray3[1] = fArray2[1];
                    } else {
                        bl2 = true;
                    }
                    nArray[0] = 0;
                    break;
                }
                case 1: {
                    float f3 = fArray2[2] = fArray[0] + f;
                    float f4 = fArray2[3] = fArray[1] + f2;
                    if (!(f3 < 8.5070587E37f) || !(f3 > -8.5070587E37f) || !(f4 < 8.5070587E37f) || !(f4 > -8.5070587E37f)) break;
                    if (bl2) {
                        fArray2[0] = fArray3[0] = f3;
                        fArray2[1] = fArray3[1] = f4;
                        bl = true;
                        bl2 = false;
                        break;
                    }
                    ProcessPath.ProcessLine(processHandler, fArray2[0], fArray2[1], fArray2[2], fArray2[3], nArray);
                    fArray2[0] = f3;
                    fArray2[1] = f4;
                    break;
                }
                case 2: {
                    fArray2[2] = fArray[0] + f;
                    fArray2[3] = fArray[1] + f2;
                    float f3 = fArray2[4] = fArray[2] + f;
                    float f4 = fArray2[5] = fArray[3] + f2;
                    if (!(f3 < 8.5070587E37f) || !(f3 > -8.5070587E37f) || !(f4 < 8.5070587E37f) || !(f4 > -8.5070587E37f)) break;
                    if (bl2) {
                        fArray2[0] = fArray3[0] = f3;
                        fArray2[1] = fArray3[1] = f4;
                        bl = true;
                        bl2 = false;
                        break;
                    }
                    if (fArray2[2] < 8.5070587E37f && fArray2[2] > -8.5070587E37f && fArray2[3] < 8.5070587E37f && fArray2[3] > -8.5070587E37f) {
                        ProcessPath.ProcessQuad(processHandler, fArray2, nArray);
                    } else {
                        ProcessPath.ProcessLine(processHandler, fArray2[0], fArray2[1], fArray2[4], fArray2[5], nArray);
                    }
                    fArray2[0] = f3;
                    fArray2[1] = f4;
                    break;
                }
                case 3: {
                    fArray2[2] = fArray[0] + f;
                    fArray2[3] = fArray[1] + f2;
                    fArray2[4] = fArray[2] + f;
                    fArray2[5] = fArray[3] + f2;
                    float f3 = fArray2[6] = fArray[4] + f;
                    float f4 = fArray2[7] = fArray[5] + f2;
                    if (!(f3 < 8.5070587E37f) || !(f3 > -8.5070587E37f) || !(f4 < 8.5070587E37f) || !(f4 > -8.5070587E37f)) break;
                    if (bl2) {
                        fArray2[0] = fArray3[0] = fArray2[6];
                        fArray2[1] = fArray3[1] = fArray2[7];
                        bl = true;
                        bl2 = false;
                        break;
                    }
                    if (fArray2[2] < 8.5070587E37f && fArray2[2] > -8.5070587E37f && fArray2[3] < 8.5070587E37f && fArray2[3] > -8.5070587E37f && fArray2[4] < 8.5070587E37f && fArray2[4] > -8.5070587E37f && fArray2[5] < 8.5070587E37f && fArray2[5] > -8.5070587E37f) {
                        ProcessPath.ProcessCubic(processHandler, fArray2, nArray);
                    } else {
                        ProcessPath.ProcessLine(processHandler, fArray2[0], fArray2[1], fArray2[6], fArray2[7], nArray);
                    }
                    fArray2[0] = f3;
                    fArray2[1] = f4;
                    break;
                }
                case 4: {
                    if (!bl || bl2) break;
                    bl2 = false;
                    if (fArray2[0] != fArray3[0] || fArray2[1] != fArray3[1]) {
                        ProcessPath.ProcessLine(processHandler, fArray2[0], fArray2[1], fArray3[0], fArray3[1], nArray);
                        fArray2[0] = fArray3[0];
                        fArray2[1] = fArray3[1];
                    }
                    processHandler.processEndSubPath();
                }
            }
            pathIterator.next();
        }
        if (bl & !bl2) {
            if (processHandler.clipMode == 1 && (fArray2[0] != fArray3[0] || fArray2[1] != fArray3[1])) {
                ProcessPath.ProcessLine(processHandler, fArray2[0], fArray2[1], fArray3[0], fArray3[1], nArray);
            }
            processHandler.processEndSubPath();
        }
        return true;
    }

    private static void FillPolygon(FillProcessHandler fillProcessHandler, int n) {
        int n2 = fillProcessHandler.dhnd.xMax - 1;
        FillData fillData = fillProcessHandler.fd;
        int n3 = fillData.plgYMin;
        int n4 = fillData.plgYMax;
        int n5 = (n4 - n3 >> 10) + 4;
        int n6 = n3 - 1 & 0xFFFFFC00;
        int n7 = n == 1 ? -1 : 1;
        List<Point> list = fillData.plgPnts;
        int n8 = list.size();
        if (n8 <= 1) {
            return;
        }
        Point[] pointArray = new Point[n5];
        Point point = list.get(0);
        point.prev = null;
        for (int i = 0; i < n8 - 1; ++i) {
            point = list.get(i);
            Point point2 = list.get(i + 1);
            int n9 = point.y - n6 - 1 >> 10;
            point.nextByY = pointArray[n9];
            pointArray[n9] = point;
            point.next = point2;
            point2.prev = point;
        }
        Point point3 = list.get(n8 - 1);
        int n10 = point3.y - n6 - 1 >> 10;
        point3.nextByY = pointArray[n10];
        pointArray[n10] = point3;
        ActiveEdgeList activeEdgeList = new ActiveEdgeList();
        int n11 = n6 + 1024;
        for (int i = 0; n11 <= n4 && i < n5; n11 += 1024, ++i) {
            int n12;
            Point point4 = pointArray[i];
            while (point4 != null) {
                if (point4.prev != null && !point4.prev.lastPoint) {
                    if (point4.prev.edge != null && point4.prev.y <= n11) {
                        activeEdgeList.delete(point4.prev.edge);
                        point4.prev.edge = null;
                    } else if (point4.prev.y > n11) {
                        activeEdgeList.insert(point4.prev, n11);
                    }
                }
                if (!point4.lastPoint && point4.next != null) {
                    if (point4.edge != null && point4.next.y <= n11) {
                        activeEdgeList.delete(point4.edge);
                        point4.edge = null;
                    } else if (point4.next.y > n11) {
                        activeEdgeList.insert(point4, n11);
                    }
                }
                point4 = point4.nextByY;
            }
            if (activeEdgeList.isEmpty()) continue;
            activeEdgeList.sort();
            int n13 = 0;
            boolean bl = false;
            int n14 = n12 = fillProcessHandler.dhnd.xMin;
            Edge edge = activeEdgeList.head;
            while (edge != null) {
                if (((n13 += edge.dir) & n7) != 0 && !bl) {
                    n14 = edge.x + 1024 - 1 >> 10;
                    bl = true;
                }
                if ((n13 & n7) == 0 && bl) {
                    n12 = edge.x - 1 >> 10;
                    if (n14 <= n12) {
                        fillProcessHandler.dhnd.drawScanline(n14, n12, n11 >> 10);
                    }
                    bl = false;
                }
                edge.x += edge.dx;
                edge = edge.next;
            }
            if (!bl || n14 > n2) continue;
            fillProcessHandler.dhnd.drawScanline(n14, n2, n11 >> 10);
        }
    }

    private static class ActiveEdgeList {
        Edge head;

        private ActiveEdgeList() {
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public void insert(Point point, int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            Point point2 = point.next;
            int n6 = point.x;
            int n7 = point.y;
            int n8 = point2.x;
            int n9 = point2.y;
            if (n7 == n9) {
                return;
            }
            int n10 = n8 - n6;
            int n11 = n9 - n7;
            if (n7 < n9) {
                n5 = n6;
                n4 = n - n7;
                n3 = -1;
            } else {
                n5 = n8;
                n4 = n - n9;
                n3 = 1;
            }
            if ((float)n10 > 1048576.0f || (float)n10 < -1048576.0f) {
                n2 = (int)((double)n10 * 1024.0 / (double)n11);
                n5 += (int)((double)n10 * (double)n4 / (double)n11);
            } else {
                n2 = (n10 << 10) / n11;
                n5 += n10 * n4 / n11;
            }
            Edge edge = new Edge(point, n5, n2, n3);
            edge.next = this.head;
            edge.prev = null;
            if (this.head != null) {
                this.head.prev = edge;
            }
            this.head = point.edge = edge;
        }

        public void delete(Edge edge) {
            Edge edge2 = edge.prev;
            Edge edge3 = edge.next;
            if (edge2 != null) {
                edge2.next = edge3;
            } else {
                this.head = edge3;
            }
            if (edge3 != null) {
                edge3.prev = edge2;
            }
        }

        public void sort() {
            Edge edge;
            Edge edge2;
            Edge edge3 = null;
            boolean bl = true;
            while (edge3 != this.head.next && bl) {
                Edge edge4 = edge2 = this.head;
                edge = edge2.next;
                bl = false;
                while (edge2 != edge3) {
                    if (edge2.x >= edge.x) {
                        Edge edge5;
                        bl = true;
                        if (edge2 == this.head) {
                            edge5 = edge.next;
                            edge.next = edge2;
                            edge2.next = edge5;
                            this.head = edge;
                            edge4 = edge;
                        } else {
                            edge5 = edge.next;
                            edge.next = edge2;
                            edge2.next = edge5;
                            edge4.next = edge;
                            edge4 = edge;
                        }
                    } else {
                        edge4 = edge2;
                        edge2 = edge2.next;
                    }
                    if ((edge = edge2.next) != edge3) continue;
                    edge3 = edge2;
                }
            }
            edge2 = this.head;
            edge = null;
            while (edge2 != null) {
                edge2.prev = edge;
                edge = edge2;
                edge2 = edge2.next;
            }
        }
    }

    public static abstract class DrawHandler {
        public int xMin;
        public int yMin;
        public int xMax;
        public int yMax;
        public float xMinf;
        public float yMinf;
        public float xMaxf;
        public float yMaxf;
        public int strokeControl;

        public DrawHandler(int n, int n2, int n3, int n4, int n5) {
            this.setBounds(n, n2, n3, n4, n5);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            this.xMin = n;
            this.yMin = n2;
            this.xMax = n3;
            this.yMax = n4;
            this.xMinf = (float)n - 0.5f;
            this.yMinf = (float)n2 - 0.5f;
            this.xMaxf = (float)n3 - 0.5f - 9.765625E-4f;
            this.yMaxf = (float)n4 - 0.5f - 9.765625E-4f;
        }

        public void setBounds(int n, int n2, int n3, int n4, int n5) {
            this.strokeControl = n5;
            this.setBounds(n, n2, n3, n4);
        }

        public void adjustBounds(int n, int n2, int n3, int n4) {
            if (this.xMin > n) {
                n = this.xMin;
            }
            if (this.xMax < n3) {
                n3 = this.xMax;
            }
            if (this.yMin > n2) {
                n2 = this.yMin;
            }
            if (this.yMax < n4) {
                n4 = this.yMax;
            }
            this.setBounds(n, n2, n3, n4);
        }

        public DrawHandler(int n, int n2, int n3, int n4) {
            this(n, n2, n3, n4, 0);
        }

        public abstract void drawLine(int var1, int var2, int var3, int var4);

        public abstract void drawPixel(int var1, int var2);

        public abstract void drawScanline(int var1, int var2, int var3);
    }

    private static class DrawProcessHandler
    extends ProcessHandler {
        EndSubPathHandler processESP;

        public DrawProcessHandler(DrawHandler drawHandler, EndSubPathHandler endSubPathHandler) {
            super(drawHandler, 0);
            this.dhnd = drawHandler;
            this.processESP = endSubPathHandler;
        }

        public void processEndSubPath() {
            this.processESP.processEndSubPath();
        }

        void PROCESS_LINE(int n, int n2, int n3, int n4, boolean bl, int[] nArray) {
            int n5 = n >> 10;
            int n6 = n3 >> 10;
            int n7 = n2 >> 10;
            int n8 = n4 >> 10;
            if ((n5 ^ n6 | n7 ^ n8) == 0) {
                if (bl && (this.dhnd.yMin > n7 || this.dhnd.yMax <= n7 || this.dhnd.xMin > n5 || this.dhnd.xMax <= n5)) {
                    return;
                }
                if (nArray[0] == 0) {
                    nArray[0] = 1;
                    nArray[1] = n5;
                    nArray[2] = n7;
                    nArray[3] = n5;
                    nArray[4] = n7;
                    this.dhnd.drawPixel(n5, n7);
                } else if (!(n5 == nArray[3] && n7 == nArray[4] || n5 == nArray[1] && n7 == nArray[2])) {
                    this.dhnd.drawPixel(n5, n7);
                    nArray[3] = n5;
                    nArray[4] = n7;
                }
                return;
            }
            if ((!bl || this.dhnd.yMin <= n7 && this.dhnd.yMax > n7 && this.dhnd.xMin <= n5 && this.dhnd.xMax > n5) && nArray[0] == 1 && (nArray[1] == n5 && nArray[2] == n7 || nArray[3] == n5 && nArray[4] == n7)) {
                this.dhnd.drawPixel(n5, n7);
            }
            this.dhnd.drawLine(n5, n7, n6, n8);
            if (nArray[0] == 0) {
                nArray[0] = 1;
                nArray[1] = n5;
                nArray[2] = n7;
                nArray[3] = n5;
                nArray[4] = n7;
            }
            if (nArray[1] == n6 && nArray[2] == n8 || nArray[3] == n6 && nArray[4] == n8) {
                if (bl && (this.dhnd.yMin > n8 || this.dhnd.yMax <= n8 || this.dhnd.xMin > n6 || this.dhnd.xMax <= n6)) {
                    return;
                }
                this.dhnd.drawPixel(n6, n8);
            }
            nArray[3] = n6;
            nArray[4] = n8;
        }

        void PROCESS_POINT(int n, int n2, boolean bl, int[] nArray) {
            int n3 = n >> 10;
            int n4 = n2 >> 10;
            if (bl && (this.dhnd.yMin > n4 || this.dhnd.yMax <= n4 || this.dhnd.xMin > n3 || this.dhnd.xMax <= n3)) {
                return;
            }
            if (nArray[0] == 0) {
                nArray[0] = 1;
                nArray[1] = n3;
                nArray[2] = n4;
                nArray[3] = n3;
                nArray[4] = n4;
                this.dhnd.drawPixel(n3, n4);
            } else if (!(n3 == nArray[3] && n4 == nArray[4] || n3 == nArray[1] && n4 == nArray[2])) {
                this.dhnd.drawPixel(n3, n4);
                nArray[3] = n3;
                nArray[4] = n4;
            }
        }

        public void processFixedLine(int n, int n2, int n3, int n4, int[] nArray, boolean bl, boolean bl2) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = n ^ n3 | n2 ^ n4;
            if ((n9 & 0xFFFFFC00) == 0) {
                if (n9 == 0) {
                    this.PROCESS_POINT(n + 512, n2 + 512, bl, nArray);
                }
                return;
            }
            if (n == n3 || n2 == n4) {
                n8 = n + 512;
                n7 = n3 + 512;
                n6 = n2 + 512;
                n5 = n4 + 512;
            } else {
                int n10;
                int n11;
                int n12;
                int n13 = n3 - n;
                int n14 = n4 - n2;
                int n15 = n & 0xFFFFFC00;
                int n16 = n2 & 0xFFFFFC00;
                int n17 = n3 & 0xFFFFFC00;
                int n18 = n4 & 0xFFFFFC00;
                if (n15 == n || n16 == n2) {
                    n8 = n + 512;
                    n6 = n2 + 512;
                } else {
                    n12 = n < n3 ? n15 + 1024 : n15;
                    n11 = n2 < n4 ? n16 + 1024 : n16;
                    n10 = n2 + (n12 - n) * n14 / n13;
                    if (n10 >= n16 && n10 <= n16 + 1024) {
                        n8 = n12;
                        n6 = n10 + 512;
                    } else {
                        n10 = n + (n11 - n2) * n13 / n14;
                        n8 = n10 + 512;
                        n6 = n11;
                    }
                }
                if (n17 == n3 || n18 == n4) {
                    n7 = n3 + 512;
                    n5 = n4 + 512;
                } else {
                    n12 = n > n3 ? n17 + 1024 : n17;
                    n11 = n2 > n4 ? n18 + 1024 : n18;
                    n10 = n4 + (n12 - n3) * n14 / n13;
                    if (n10 >= n18 && n10 <= n18 + 1024) {
                        n7 = n12;
                        n5 = n10 + 512;
                    } else {
                        n10 = n3 + (n11 - n4) * n13 / n14;
                        n7 = n10 + 512;
                        n5 = n11;
                    }
                }
            }
            this.PROCESS_LINE(n8, n6, n7, n5, bl, nArray);
        }
    }

    private static class Edge {
        int x;
        int dx;
        Point p;
        int dir;
        Edge prev;
        Edge next;

        public Edge(Point point, int n, int n2, int n3) {
            this.p = point;
            this.x = n;
            this.dx = n2;
            this.dir = n3;
        }
    }

    public static interface EndSubPathHandler {
        public void processEndSubPath();
    }

    private static class FillData {
        List<Point> plgPnts = new Vector<Point>(256);
        public int plgYMin;
        public int plgYMax;

        public void addPoint(int n, int n2, boolean bl) {
            if (this.plgPnts.size() == 0) {
                this.plgYMin = this.plgYMax = n2;
            } else {
                this.plgYMin = this.plgYMin > n2 ? n2 : this.plgYMin;
                this.plgYMax = this.plgYMax < n2 ? n2 : this.plgYMax;
            }
            this.plgPnts.add(new Point(n, n2, bl));
        }

        public boolean isEmpty() {
            return this.plgPnts.size() == 0;
        }

        public boolean isEnded() {
            return this.plgPnts.get((int)(this.plgPnts.size() - 1)).lastPoint;
        }

        public boolean setEnded() {
            this.plgPnts.get((int)(this.plgPnts.size() - 1)).lastPoint = true;
            return true;
        }
    }

    private static class FillProcessHandler
    extends ProcessHandler {
        FillData fd = new FillData();

        public void processFixedLine(int n, int n2, int n3, int n4, int[] nArray, boolean bl, boolean bl2) {
            if (bl) {
                int[] nArray2 = new int[]{n, n2, n3, n4, 0, 0};
                int n5 = (int)(this.dhnd.xMinf * 1024.0f);
                int n6 = (int)(this.dhnd.xMaxf * 1024.0f);
                int n7 = (int)(this.dhnd.yMinf * 1024.0f);
                int n8 = (int)(this.dhnd.yMaxf * 1024.0f);
                int n9 = ProcessPath.TESTANDCLIP(n7, n8, nArray2, 1, 0, 3, 2);
                if (n9 == 4) {
                    return;
                }
                n9 = ProcessPath.TESTANDCLIP(n7, n8, nArray2, 3, 2, 1, 0);
                if (n9 == 4) {
                    return;
                }
                boolean bl3 = ProcessPath.IS_CLIPPED(n9);
                n9 = ProcessPath.CLIPCLAMP(n5, n6, nArray2, 0, 1, 2, 3, 4, 5);
                if (n9 == 0) {
                    this.processFixedLine(nArray2[4], nArray2[5], nArray2[0], nArray2[1], nArray, false, bl3);
                } else if (n9 == 4) {
                    return;
                }
                n9 = ProcessPath.CLIPCLAMP(n5, n6, nArray2, 2, 3, 0, 1, 4, 5);
                bl3 = bl3 || n9 == 1;
                this.processFixedLine(nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray, false, bl3);
                if (n9 == 0) {
                    this.processFixedLine(nArray2[2], nArray2[3], nArray2[4], nArray2[5], nArray, false, bl3);
                }
                return;
            }
            if (this.fd.isEmpty() || this.fd.isEnded()) {
                this.fd.addPoint(n, n2, false);
            }
            this.fd.addPoint(n3, n4, false);
            if (bl2) {
                this.fd.setEnded();
            }
        }

        FillProcessHandler(DrawHandler drawHandler) {
            super(drawHandler, 1);
        }

        public void processEndSubPath() {
            if (!this.fd.isEmpty()) {
                this.fd.setEnded();
            }
        }
    }

    private static class Point {
        public int x;
        public int y;
        public boolean lastPoint;
        public Point prev;
        public Point next;
        public Point nextByY;
        public Edge edge;

        public Point(int n, int n2, boolean bl) {
            this.x = n;
            this.y = n2;
            this.lastPoint = bl;
        }
    }

    public static abstract class ProcessHandler
    implements EndSubPathHandler {
        DrawHandler dhnd;
        int clipMode;

        public ProcessHandler(DrawHandler drawHandler, int n) {
            this.dhnd = drawHandler;
            this.clipMode = n;
        }

        public abstract void processFixedLine(int var1, int var2, int var3, int var4, int[] var5, boolean var6, boolean var7);
    }
}

