/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Desktop;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;

public class XDesktopPeer
implements DesktopPeer {
    private static boolean nativeLibraryLoaded = false;

    static boolean isDesktopSupported() {
        return nativeLibraryLoaded;
    }

    public boolean isSupported(Desktop.Action action) {
        return action != Desktop.Action.PRINT && action != Desktop.Action.EDIT;
    }

    public void open(File file) throws IOException {
        try {
            this.launch(file.toURI());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(file.toString());
        }
    }

    public void edit(File file) throws IOException {
        throw new UnsupportedOperationException("The current platform doesn't support the EDIT action.");
    }

    public void print(File file) throws IOException {
        throw new UnsupportedOperationException("The current platform doesn't support the PRINT action.");
    }

    public void mail(URI uRI) throws IOException {
        this.launch(uRI);
    }

    public void browse(URI uRI) throws IOException {
        this.launch(uRI);
    }

    private void launch(URI uRI) throws IOException {
        if (!nativeLibraryLoaded) {
            throw new IOException("Failed to load native libraries.");
        }
        byte[] byArray = (uRI.toString() + '\u0000').getBytes();
        boolean bl = this.gnome_url_show(byArray);
        if (!bl) {
            throw new IOException("Failed to show URI:" + uRI);
        }
    }

    private native boolean gnome_url_show(byte[] var1);

    private static native boolean init();

    static {
        nativeLibraryLoaded = XDesktopPeer.init();
    }
}

