/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.normalizer.Trie;
import sun.text.normalizer.UCharacterProperty;

public class CharTrie
extends Trie {
    private char m_initialValue_;
    private char[] m_data_;
    private FriendAgent m_friendAgent_;

    public CharTrie(InputStream inputStream, Trie.DataManipulate dataManipulate) throws IOException {
        super(inputStream, dataManipulate);
        if (!this.isCharTrie()) {
            throw new IllegalArgumentException("Data given does not belong to a char trie.");
        }
        this.m_friendAgent_ = new FriendAgent();
    }

    public void putIndexData(UCharacterProperty uCharacterProperty) {
        uCharacterProperty.setIndexData(this.m_friendAgent_);
    }

    public final char getCodePointValue(int n) {
        int n2 = this.getCodePointOffset(n);
        return n2 >= 0 ? this.m_data_[n2] : this.m_initialValue_;
    }

    public final char getLeadValue(char c) {
        return this.m_data_[this.getLeadOffset(c)];
    }

    public final char getSurrogateValue(char c, char c2) {
        int n = this.getSurrogateOffset(c, c2);
        if (n > 0) {
            return this.m_data_[n];
        }
        return this.m_initialValue_;
    }

    public final char getTrailValue(int n, char c) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n2 = this.m_dataManipulate_.getFoldingOffset(n);
        if (n2 > 0) {
            return this.m_data_[this.getRawOffset(n2, (char)(c & 0x3FF))];
        }
        return this.m_initialValue_;
    }

    protected final void unserialize(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = this.m_dataOffset_ + this.m_dataLength_;
        this.m_index_ = new char[n];
        for (int i = 0; i < n; ++i) {
            this.m_index_[i] = dataInputStream.readChar();
        }
        this.m_data_ = this.m_index_;
        this.m_initialValue_ = this.m_data_[this.m_dataOffset_];
    }

    protected final int getSurrogateOffset(char c, char c2) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n = this.m_dataManipulate_.getFoldingOffset(this.getLeadValue(c));
        if (n > 0) {
            return this.getRawOffset(n, (char)(c2 & 0x3FF));
        }
        return -1;
    }

    protected final int getValue(int n) {
        return this.m_data_[n];
    }

    protected final int getInitialValue() {
        return this.m_initialValue_;
    }

    public class FriendAgent {
        public char[] getPrivateIndex() {
            return CharTrie.this.m_index_;
        }

        public char[] getPrivateData() {
            return CharTrie.this.m_data_;
        }

        public int getPrivateInitialValue() {
            return CharTrie.this.m_initialValue_;
        }
    }
}

