/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.NamedWeakReference;
import com.sun.naming.internal.VersionHelper;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public final class ResourceManager {
    private static final String PROVIDER_RESOURCE_FILE_NAME = "jndiprovider.properties";
    private static final String APP_RESOURCE_FILE_NAME = "jndi.properties";
    private static final String JRELIB_PROPERTY_FILE_NAME = "jndi.properties";
    private static final String[] listProperties = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state", "java.naming.factory.control"};
    private static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static final WeakHashMap propertiesCache = new WeakHashMap(11);
    private static final WeakHashMap factoryCache = new WeakHashMap(11);
    private static final WeakHashMap urlFactoryCache = new WeakHashMap(11);
    private static final WeakReference NO_FACTORY = new WeakReference<Object>(null);

    private ResourceManager() {
    }

    public static Hashtable getInitialEnvironment(Hashtable hashtable) throws NamingException {
        String[] stringArray = VersionHelper.PROPS;
        if (hashtable == null) {
            hashtable = new Hashtable(11);
        }
        Applet applet = (Applet)hashtable.get("java.naming.applet");
        String[] stringArray2 = helper.getJndiProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = hashtable.get(stringArray[i]);
            if (object != null) continue;
            if (applet != null) {
                object = applet.getParameter(stringArray[i]);
            }
            if (object == null) {
                String string = object = stringArray2 != null ? stringArray2[i] : helper.getJndiProperty(i);
            }
            if (object == null) continue;
            hashtable.put(stringArray[i], object);
        }
        ResourceManager.mergeTables(hashtable, ResourceManager.getApplicationResources());
        return hashtable;
    }

    public static String getProperty(String string, Hashtable hashtable, Context context, boolean bl) throws NamingException {
        String string2;
        String string3 = string2 = hashtable != null ? (String)hashtable.get(string) : null;
        if (context == null || string2 != null && !bl) {
            return string2;
        }
        String string4 = (String)ResourceManager.getProviderResource(context).get(string);
        if (string2 == null) {
            return string4;
        }
        if (string4 == null || !bl) {
            return string2;
        }
        return string2 + ":" + string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryEnumeration getFactories(String string, Hashtable hashtable, Context context) throws NamingException {
        String string2 = ResourceManager.getProperty(string, hashtable, context, true);
        if (string2 == null) {
            return null;
        }
        ClassLoader classLoader = helper.getContextClassLoader();
        HashMap hashMap = null;
        AbstractMap abstractMap = factoryCache;
        synchronized (abstractMap) {
            hashMap = (HashMap)factoryCache.get(classLoader);
            if (hashMap == null) {
                hashMap = new HashMap(11);
                factoryCache.put(classLoader, hashMap);
            }
        }
        abstractMap = hashMap;
        synchronized (abstractMap) {
            ArrayList<NamedWeakReference> arrayList = (ArrayList<NamedWeakReference>)hashMap.get(string2);
            if (arrayList != null) {
                return arrayList.size() == 0 ? null : new FactoryEnumeration(arrayList, classLoader);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            arrayList = new ArrayList<NamedWeakReference>(5);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string3 = stringTokenizer.nextToken();
                    Class clazz = helper.loadClass(string3, classLoader);
                    arrayList.add(new NamedWeakReference(clazz, string3));
                }
                catch (Exception exception) {}
            }
            hashMap.put(string2, arrayList);
            return new FactoryEnumeration(arrayList, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFactory(String string, Hashtable hashtable, Context context, String string2, String string3) throws NamingException {
        String string4 = ResourceManager.getProperty(string, hashtable, context, true);
        string4 = string4 != null ? string4 + ":" + string3 : string3;
        ClassLoader classLoader = helper.getContextClassLoader();
        String string5 = string2 + " " + string4;
        HashMap<String, WeakReference> hashMap = null;
        AbstractMap abstractMap = urlFactoryCache;
        synchronized (abstractMap) {
            hashMap = (HashMap<String, WeakReference>)urlFactoryCache.get(classLoader);
            if (hashMap == null) {
                hashMap = new HashMap<String, WeakReference>(11);
                urlFactoryCache.put(classLoader, hashMap);
            }
        }
        abstractMap = hashMap;
        synchronized (abstractMap) {
            Object t = null;
            WeakReference weakReference = (WeakReference)hashMap.get(string5);
            if (weakReference == NO_FACTORY) {
                return null;
            }
            if (weakReference != null && (t = (Object)weakReference.get()) != null) {
                return t;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
            while (t == null && stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken() + string2;
                try {
                    t = helper.loadClass(string6, classLoader).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    NamingException namingException = new NamingException("Cannot instantiate " + string6);
                    namingException.setRootCause(instantiationException);
                    throw namingException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    NamingException namingException = new NamingException("Cannot access " + string6);
                    namingException.setRootCause(illegalAccessException);
                    throw namingException;
                }
                catch (Exception exception) {
                }
            }
            hashMap.put(string5, t != null ? new WeakReference<Object>(t) : NO_FACTORY);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getProviderResource(Object object) throws NamingException {
        if (object == null) {
            return new Hashtable(1);
        }
        WeakHashMap weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Class<?> clazz = object.getClass();
            Hashtable hashtable = (Hashtable)propertiesCache.get(clazz);
            if (hashtable != null) {
                return hashtable;
            }
            hashtable = new Properties();
            InputStream inputStream = helper.getResourceAsStream(clazz, PROVIDER_RESOURCE_FILE_NAME);
            if (inputStream != null) {
                try {
                    ((Properties)hashtable).load(inputStream);
                }
                catch (IOException iOException) {
                    ConfigurationException configurationException = new ConfigurationException("Error reading provider resource file for " + clazz);
                    configurationException.setRootCause(iOException);
                    throw configurationException;
                }
            }
            propertiesCache.put(clazz, hashtable);
            return hashtable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getApplicationResources() throws NamingException {
        ClassLoader classLoader = helper.getContextClassLoader();
        WeakHashMap weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Properties properties = (Hashtable)propertiesCache.get(classLoader);
            if (properties != null) {
                return properties;
            }
            try {
                Object object;
                NamingEnumeration namingEnumeration = helper.getResources(classLoader, "jndi.properties");
                while (namingEnumeration.hasMore()) {
                    object = new Properties();
                    ((Properties)object).load((InputStream)namingEnumeration.next());
                    if (properties == null) {
                        properties = object;
                        continue;
                    }
                    ResourceManager.mergeTables(properties, (Hashtable)object);
                }
                object = helper.getJavaHomeLibStream("jndi.properties");
                if (object != null) {
                    Properties properties2 = new Properties();
                    properties2.load((InputStream)object);
                    if (properties == null) {
                        properties = properties2;
                    } else {
                        ResourceManager.mergeTables(properties, properties2);
                    }
                }
            }
            catch (IOException iOException) {
                ConfigurationException configurationException = new ConfigurationException("Error reading application resource file");
                configurationException.setRootCause(iOException);
                throw configurationException;
            }
            if (properties == null) {
                properties = new Hashtable(11);
            }
            propertiesCache.put(classLoader, properties);
            return properties;
        }
    }

    private static void mergeTables(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v == null) {
                hashtable.put(string, hashtable2.get(string));
                continue;
            }
            if (!ResourceManager.isListProperty(string)) continue;
            String string2 = (String)hashtable2.get(string);
            hashtable.put(string, (String)v + ":" + string2);
        }
    }

    private static boolean isListProperty(String string) {
        string = string.intern();
        for (int i = 0; i < listProperties.length; ++i) {
            if (string != listProperties[i]) continue;
            return true;
        }
        return false;
    }
}

