/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/


#ifndef _FILINSREQ_HXX_
#define _FILINSREQ_HXX_

#include <cppuhelper/weak.hxx>
#include <ucbhelper/macros.hxx>
#include <rtl/ustring.hxx>
#include <com/sun/star/uno/XInterface.hpp>
#include <com/sun/star/lang/XTypeProvider.hpp>
#include <com/sun/star/task/XInteractionAbort.hpp>
#include <com/sun/star/ucb/XInteractionSupplyName.hpp>
#include <com/sun/star/task/XInteractionRequest.hpp>


namespace fileaccess {


	class shell;

	
	class XInteractionSupplyNameImpl
		: public cppu::OWeakObject,
		  public com::sun::star::lang::XTypeProvider,
		  public com::sun::star::ucb::XInteractionSupplyName
	{
	public:

		XInteractionSupplyNameImpl()
			: m_bSelected(false)
		{
		}
		
		virtual com::sun::star::uno::Any SAL_CALL
		queryInterface(
			const com::sun::star::uno::Type& rType )
			throw( com::sun::star::uno::RuntimeException);
		
		virtual void SAL_CALL
		acquire(
			void )
			throw();
		
		virtual void SAL_CALL
		release(
			void )
			throw();


		// XTypeProvider

		XTYPEPROVIDER_DECL()
		
	    
		virtual void SAL_CALL select()
			throw (::com::sun::star::uno::RuntimeException)
		{
			m_bSelected = true;
		}

	    void SAL_CALL setName(const ::rtl::OUString& Name)
			throw(::com::sun::star::uno::RuntimeException)
		{
			m_aNewName = Name;
		}
		
		rtl::OUString getName() const
		{
			return m_aNewName;
		}
		
		bool isSelected() const
		{
			return m_bSelected;
		}
		
	private:

		bool          m_bSelected;
		rtl::OUString m_aNewName;
	};



	class XInteractionAbortImpl
		: public cppu::OWeakObject,
		  public com::sun::star::lang::XTypeProvider,
		  public com::sun::star::task::XInteractionAbort
	{
	public:
		
		XInteractionAbortImpl()
			: m_bSelected(false)
		{
		}
		
		virtual com::sun::star::uno::Any SAL_CALL
		queryInterface(
			const com::sun::star::uno::Type& rType )
			throw( com::sun::star::uno::RuntimeException);
		
		virtual void SAL_CALL
		acquire(
			void )
			throw();
		
		virtual void SAL_CALL
		release(
			void )
			throw();


		// XTypeProvider

		XTYPEPROVIDER_DECL()
		
	    
	    virtual void SAL_CALL select()
			throw (::com::sun::star::uno::RuntimeException)
		{
			m_bSelected = true;
		}

		
		bool isSelected() const
		{
			return m_bSelected;
		}
		
	private:

		bool          m_bSelected;
	};

	
	
	class XInteractionRequestImpl
		: public cppu::OWeakObject,
		  public com::sun::star::lang::XTypeProvider,
		  public com::sun::star::task::XInteractionRequest
	{
	public:
		
		XInteractionRequestImpl(
            const rtl::OUString& aClashingName,
            const com::sun::star::uno::Reference<
            com::sun::star::uno::XInterface>& xOrigin,
			shell* pShell,
			sal_Int32 CommandId);
		
		virtual com::sun::star::uno::Any SAL_CALL
		queryInterface(
			const com::sun::star::uno::Type& rType )
			throw( com::sun::star::uno::RuntimeException);
		
		virtual void SAL_CALL
		acquire(
			void )
			throw();
		
		virtual void SAL_CALL
		release(
			void )
			throw();


		// XTypeProvider

		XTYPEPROVIDER_DECL()

		::com::sun::star::uno::Any SAL_CALL getRequest(  )
			throw (::com::sun::star::uno::RuntimeException);
		
		com::sun::star::uno::Sequence< 
            com::sun::star::uno::Reference< 
            com::sun::star::task::XInteractionContinuation > > SAL_CALL
		getContinuations(  )
			throw (::com::sun::star::uno::RuntimeException)
		{
			return m_aSeq;
		}
		
		bool aborted() const
		{
			return p2->isSelected();
		}

		rtl::OUString newName() const 
		{
			if( p1->isSelected() )
				return p1->getName();
			else
				return rtl::OUString();
		} 
		
	private:
		
		XInteractionSupplyNameImpl* p1;
		XInteractionAbortImpl* p2;
		sal_Int32 m_nErrorCode,m_nMinorError;
        
		com::sun::star::uno::Sequence<
            com::sun::star::uno::Reference< 
            com::sun::star::task::XInteractionContinuation > > m_aSeq;
        
        rtl::OUString m_aClashingName;
        com::sun::star::uno::Reference<
            com::sun::star::uno::XInterface> m_xOrigin;
	};
	
}


#endif
