/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef CONNECTIVITY_USTRINGDESCRIPTION_IMPL_HXX
#define CONNECTIVITY_USTRINGDESCRIPTION_IMPL_HXX

#define IMPLEMENT_CONSTASCII_USTRING(name)	\
UStringDescription name(connectivity::dbtools::get##name)

UStringDescription::UStringDescription(PVFN _fCharFkt)
{ 
	pZeroTerminatedName = (*_fCharFkt)(); 
	nLength = 0;
	const sal_Char*	pIter = pZeroTerminatedName;
	while((*pIter++) != '\0')
		++nLength;
}
// -------------------------------------------------------------------------
UStringDescription::~UStringDescription()
{
}

IMPLEMENT_CONSTASCII_USTRING(PROPERTY_QUERYTIMEOUT			);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_MAXFIELDSIZE			);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_MAXROWS				);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_CURSORNAME			);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_RESULTSETCONCURRENCY	);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_RESULTSETTYPE			);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_FETCHDIRECTION		);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_FETCHSIZE				);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ESCAPEPROCESSING		);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_USEBOOKMARKS			);

IMPLEMENT_CONSTASCII_USTRING(PROPERTY_NAME);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_TYPE);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_TYPENAME);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_PRECISION);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_SCALE);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISNULLABLE);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISAUTOINCREMENT);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISROWVERSION);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_DESCRIPTION);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_DEFAULTVALUE);

IMPLEMENT_CONSTASCII_USTRING(PROPERTY_REFERENCEDTABLE);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_UPDATERULE);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_DELETERULE);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_CATALOG);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISUNIQUE);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISPRIMARYKEYINDEX);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISCLUSTERED);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISASCENDING);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_SCHEMANAME);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_CATALOGNAME);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_COMMAND);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_CHECKOPTION);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_PASSWORD);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_RELATEDCOLUMN);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISSEARCHABLE);

IMPLEMENT_CONSTASCII_USTRING(STAT_INVALID_INDEX);

IMPLEMENT_CONSTASCII_USTRING(PROPERTY_FUNCTION);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_TABLENAME);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_REALNAME);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_DBASEPRECISIONCHANGED);
IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISCURRENCY);

IMPLEMENT_CONSTASCII_USTRING(PROPERTY_ISBOOKMARKABLE);
//============================================================
//= error messages
//============================================================
IMPLEMENT_CONSTASCII_USTRING(ERRORMSG_SEQUENCE);
IMPLEMENT_CONSTASCII_USTRING(SQLSTATE_SEQUENCE);
IMPLEMENT_CONSTASCII_USTRING(SQLSTATE_GENERAL);
//============================================================
//= different 
//============================================================
IMPLEMENT_CONSTASCII_USTRING(STR_DELIMITER);

#endif // CONNECTIVITY_USTRINGDESCRIPTION_IMPL_HXX

