/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"

#ifndef _CONNECTIVITY_ADABAS_KEYCOLUMN_HXX_
#include "adabas/BKeyColumn.hxx"
#endif

using namespace connectivity::adabas;
namespace starbeans		= ::com::sun::star::beans;
// -------------------------------------------------------------------------
OKeyColumn::OKeyColumn() : OColumn()
{
	construct();
}
// -------------------------------------------------------------------------
OKeyColumn::OKeyColumn(		const ::rtl::OUString& _ReferencedColumn,
							const ::rtl::OUString& _Name,			
							const ::rtl::OUString& _TypeName,
							const ::rtl::OUString& _DefaultValue,
							sal_Int32		_IsNullable,
							sal_Int32		_Precision,
							sal_Int32		_Scale,
							sal_Int32		_Type,
							sal_Bool		_IsAutoIncrement
						) : OColumn(_Name,	
							_TypeName,      
							_DefaultValue,
							_IsNullable,
							_Precision,
							_Scale,
							_Type,
							_IsAutoIncrement)
						,	m_ReferencedColumn(_ReferencedColumn)
{
	construct();
}

// -------------------------------------------------------------------------
void OKeyColumn::construct()
{
	sal_Int32 nAttrib = isNew() ? 0 : starbeans::PropertyAttribute::READONLY;
	registerProperty(OMetaConnection::getPropMap().getNameByIndex(PROPERTY_ID_RELATEDCOLUMN),	PROPERTY_ID_RELATEDCOLUMN,	nAttrib,&m_ReferencedColumn,	::getCppuType(reinterpret_cast< ::rtl::OUString*>(NULL)));
}

