/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef DSAPI_TK_HTML_HXX
#define DSAPI_TK_HTML_HXX


// USED SERVICES
	// BASE CLASSES
#include <s2_dsapi/dsapitok.hxx>
	// COMPONENTS
	// PARAMETERS

namespace csi
{
namespace dsapi
{


class Tok_HtmlTag : public Token
{
  public:
	// Spring and Fall
						Tok_HtmlTag(
							const char *		i_sTag,
							bool				i_bIsParagraphStarter )
												:	sTag(i_sTag),
													bIsParagraphStarter(i_bIsParagraphStarter)
												{}
	// OPERATIONS
	virtual void		Trigger(
							TokenInterpreter &	io_rInterpreter ) const;
	// INQUIRY
	virtual const char*	Text() const;
	bool				IsParagraphStarter() const
												{ return bIsParagraphStarter; }

  private:
	String 				sTag;
	bool				bIsParagraphStarter;
};


}   // namespace dsapi
}   // namespace csi


#endif

