/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: IfFunctionTest.java 7205 2008-12-11 18:20:27Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.pentaho.reporting.libraries.formula.function.logical;

import java.math.BigDecimal;

import org.pentaho.reporting.libraries.formula.FormulaTestBase;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;

/**
 * @author Cedric Pronzato
 */
public class IfFunctionTest extends FormulaTestBase
{
  public void testDefault() throws Exception
  {
    runDefaultTest();
  }

  public Object[][] createDataTest()
  {
    return new Object[][]
        {
            {"IF(FALSE();7;8)", new BigDecimal(8)},
            {"IF(TRUE();7;8)", new BigDecimal(7)},
            {"IF(TRUE();\"HI\";8)", "HI"},
            {"IF(1;7;8)", new BigDecimal(7)},
            {"IF(5;7;8)", new BigDecimal(7)},
            {"IF(0;7;8)", new BigDecimal(8)},
            {"IF(TRUE();[.B4];8)", new BigDecimal(2)},
            {"IF(TRUE();[.B4]+5;8)", new BigDecimal(7)},
            {"IF(\"x\";7;8)", LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE},
            {"IF(\"1\";7;8)", LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE},
            {"IF(\"\";7;8)", LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE},
            {"IF(FALSE();7)", Boolean.FALSE},
            {"IF(FALSE();7;)", Boolean.FALSE},
            {"IF(FALSE();;7)", new BigDecimal(7)},
            //TODO { "IF(FALSE();7;)", new BigDecimal(0) }, we will not allow this syntax
            {"IF(TRUE();4;1/0)", new BigDecimal(4)},
            {"IF(FALSE();1/0;5)", new BigDecimal(5)},
        };
  }
}
