 /*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: rtfkeywd.cxx,v $
 * $Revision: 1.18.134.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svtools.hxx"

/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil -*- */

#include "rtfkeywd.hxx"
#include "rtftoken.h"
#include "tools/string.hxx"

#include <string.h>
#include <ctype.h>
#include <stdlib.h>

// die Tabelle muss noch sortiert werden
struct RTF_TokenEntry
{
	union{
		const sal_Char* sToken;
		const String* pUToken;
	};
	int nToken;
};

// Flag: RTF-Token Tabelle wurde schon sortiert
static int __FAR_DATA bSortKeyWords = FALSE;

static RTF_TokenEntry __FAR_DATA aRTFTokenTab[] = {
{{OOO_STRING_SVTOOLS_RTF_IGNORE},        RTF_IGNOREFLAG},
{{OOO_STRING_SVTOOLS_RTF_RTF},           RTF_RTF},
{{OOO_STRING_SVTOOLS_RTF_ANSI},          RTF_ANSITYPE},
{{OOO_STRING_SVTOOLS_RTF_MAC},           RTF_MACTYPE},
{{OOO_STRING_SVTOOLS_RTF_PC},            RTF_PCTYPE},
{{OOO_STRING_SVTOOLS_RTF_PCA},           RTF_PCATYPE},
{{OOO_STRING_SVTOOLS_RTF_NEXTCSET},      RTF_NEXTTYPE},
{{OOO_STRING_SVTOOLS_RTF_STYLESHEET},    RTF_STYLESHEET},
{{OOO_STRING_SVTOOLS_RTF_SBASEDON},      RTF_SBASEDON},
{{OOO_STRING_SVTOOLS_RTF_SNEXT},         RTF_SNEXT},
{{OOO_STRING_SVTOOLS_RTF_FONTTBL},       RTF_FONTTBL},
{{OOO_STRING_SVTOOLS_RTF_DEFF},          RTF_DEFF},
{{OOO_STRING_SVTOOLS_RTF_FNIL},          RTF_FNIL},
{{OOO_STRING_SVTOOLS_RTF_FROMAN},        RTF_FROMAN},
{{OOO_STRING_SVTOOLS_RTF_FSWISS},        RTF_FSWISS},
{{OOO_STRING_SVTOOLS_RTF_FMODERN},       RTF_FMODERN},
{{OOO_STRING_SVTOOLS_RTF_FSCRIPT},       RTF_FSCRIPT},
{{OOO_STRING_SVTOOLS_RTF_FDECOR},        RTF_FDECOR},
{{OOO_STRING_SVTOOLS_RTF_FTECH},         RTF_FTECH},
{{OOO_STRING_SVTOOLS_RTF_FCHARSET},		RTF_FCHARSET},
{{OOO_STRING_SVTOOLS_RTF_FALT},			RTF_FALT},
{{OOO_STRING_SVTOOLS_RTF_FPRQ},			RTF_FPRQ},
{{OOO_STRING_SVTOOLS_RTF_COLORTBL},      RTF_COLORTBL},
{{OOO_STRING_SVTOOLS_RTF_RED},           RTF_RED},
{{OOO_STRING_SVTOOLS_RTF_GREEN},         RTF_GREEN},
{{OOO_STRING_SVTOOLS_RTF_BLUE},          RTF_BLUE},
{{OOO_STRING_SVTOOLS_RTF_CF},            RTF_CF},
{{OOO_STRING_SVTOOLS_RTF_CB},            RTF_CB},
{{OOO_STRING_SVTOOLS_RTF_INFO},          RTF_INFO},
{{OOO_STRING_SVTOOLS_RTF_TITLE},         RTF_TITLE},
{{OOO_STRING_SVTOOLS_RTF_SUBJECT},       RTF_SUBJECT},
{{OOO_STRING_SVTOOLS_RTF_AUTHOR},        RTF_AUTHOR},
{{OOO_STRING_SVTOOLS_RTF_OPERATOR},      RTF_OPERATOR},
{{OOO_STRING_SVTOOLS_RTF_KEYWORDS},      RTF_KEYWORDS},
{{OOO_STRING_SVTOOLS_RTF_COMMENT},       RTF_COMMENT},
{{OOO_STRING_SVTOOLS_RTF_VERSION},       RTF_VERSION},
{{OOO_STRING_SVTOOLS_RTF_DOCCOMM},       RTF_DOCCOMM},
{{OOO_STRING_SVTOOLS_RTF_VERN},          RTF_VERN},
{{OOO_STRING_SVTOOLS_RTF_CREATIM},       RTF_CREATIM},
{{OOO_STRING_SVTOOLS_RTF_REVTIM},        RTF_REVTIM},
{{OOO_STRING_SVTOOLS_RTF_PRINTIM},       RTF_PRINTIM},
{{OOO_STRING_SVTOOLS_RTF_BUPTIM},        RTF_BUPTIM},
{{OOO_STRING_SVTOOLS_RTF_EDMINS},        RTF_EDMINS},
{{OOO_STRING_SVTOOLS_RTF_NOFPAGES},      RTF_NOFPAGES},
{{OOO_STRING_SVTOOLS_RTF_NOFWORDS},      RTF_NOFWORDS},
{{OOO_STRING_SVTOOLS_RTF_NOFCHARS},      RTF_NOFCHARS},
{{OOO_STRING_SVTOOLS_RTF_ID},            RTF_ID},
{{OOO_STRING_SVTOOLS_RTF_YR},            RTF_YR},
{{OOO_STRING_SVTOOLS_RTF_MO},            RTF_MO},
{{OOO_STRING_SVTOOLS_RTF_DY},            RTF_DY},
{{OOO_STRING_SVTOOLS_RTF_HR},            RTF_HR},
{{OOO_STRING_SVTOOLS_RTF_MIN},           RTF_MIN},
{{OOO_STRING_SVTOOLS_RTF_ANNOTATION},    RTF_ANNOTATION},
{{OOO_STRING_SVTOOLS_RTF_ATNID},         RTF_ATNID},
{{OOO_STRING_SVTOOLS_RTF_FOOTNOTE},      RTF_FOOTNOTE},
{{OOO_STRING_SVTOOLS_RTF_FOOTER},        RTF_FOOTER},
{{OOO_STRING_SVTOOLS_RTF_FOOTERL},       RTF_FOOTERL},
{{OOO_STRING_SVTOOLS_RTF_FOOTERR},       RTF_FOOTERR},
{{OOO_STRING_SVTOOLS_RTF_FOOTERF},       RTF_FOOTERF},
{{OOO_STRING_SVTOOLS_RTF_HEADER},        RTF_HEADER},
{{OOO_STRING_SVTOOLS_RTF_HEADERL},       RTF_HEADERL},
{{OOO_STRING_SVTOOLS_RTF_HEADERR},       RTF_HEADERR},
{{OOO_STRING_SVTOOLS_RTF_HEADERF},       RTF_HEADERF},
{{OOO_STRING_SVTOOLS_RTF_XE},            RTF_XE},
{{OOO_STRING_SVTOOLS_RTF_BXE},           RTF_BXE},
{{OOO_STRING_SVTOOLS_RTF_IXE},           RTF_IXE},
{{OOO_STRING_SVTOOLS_RTF_RXE},           RTF_RXE},
{{OOO_STRING_SVTOOLS_RTF_TXE},           RTF_TXE},
{{OOO_STRING_SVTOOLS_RTF_TC},            RTF_TC},
{{OOO_STRING_SVTOOLS_RTF_TCF},           RTF_TCF},
{{OOO_STRING_SVTOOLS_RTF_TCL},           RTF_TCL},
{{OOO_STRING_SVTOOLS_RTF_BKMKSTART},     RTF_BKMKSTART},
{{OOO_STRING_SVTOOLS_RTF_BKMKEND},       RTF_BKMKEND},
{{OOO_STRING_SVTOOLS_RTF_PICT},          RTF_PICT},
{{OOO_STRING_SVTOOLS_RTF_PICW},          RTF_PICW},
{{OOO_STRING_SVTOOLS_RTF_PICH},          RTF_PICH},
{{OOO_STRING_SVTOOLS_RTF_WBMBITSPIXEL},  RTF_WBMBITSPIXEL},
{{OOO_STRING_SVTOOLS_RTF_WBMPLANES},     RTF_WBMPLANES},
{{OOO_STRING_SVTOOLS_RTF_WBMWIDTHBYTES}, RTF_WBMWIDTHBYTES},
{{OOO_STRING_SVTOOLS_RTF_PICWGOAL},      RTF_PICWGOAL},
{{OOO_STRING_SVTOOLS_RTF_PICHGOAL},      RTF_PICHGOAL},
{{OOO_STRING_SVTOOLS_RTF_BIN},           RTF_BIN},
{{OOO_STRING_SVTOOLS_RTF_PICSCALEX},     RTF_PICSCALEX},
{{OOO_STRING_SVTOOLS_RTF_PICSCALEY},     RTF_PICSCALEY},
{{OOO_STRING_SVTOOLS_RTF_PICSCALED},     RTF_PICSCALED},
{{OOO_STRING_SVTOOLS_RTF_WBITMAP},       RTF_WBITMAP},
{{OOO_STRING_SVTOOLS_RTF_WMETAFILE},     RTF_WMETAFILE},
{{OOO_STRING_SVTOOLS_RTF_MACPICT},       RTF_MACPICT},
{{OOO_STRING_SVTOOLS_RTF_PICCROPT},      RTF_PICCROPT},
{{OOO_STRING_SVTOOLS_RTF_PICCROPB},      RTF_PICCROPB},
{{OOO_STRING_SVTOOLS_RTF_PICCROPL},      RTF_PICCROPL},
{{OOO_STRING_SVTOOLS_RTF_PICCROPR},      RTF_PICCROPR},
{{OOO_STRING_SVTOOLS_RTF_FIELD},         RTF_FIELD},
{{OOO_STRING_SVTOOLS_RTF_FLDDIRTY},      RTF_FLDDIRTY},
{{OOO_STRING_SVTOOLS_RTF_FLDEDIT},       RTF_FLDEDIT},
{{OOO_STRING_SVTOOLS_RTF_FLDLOCK},       RTF_FLDLOCK},
{{OOO_STRING_SVTOOLS_RTF_FLDPRIV},       RTF_FLDPRIV},
{{OOO_STRING_SVTOOLS_RTF_FLDINST},       RTF_FLDINST},
{{OOO_STRING_SVTOOLS_RTF_FLDRSLT},       RTF_FLDRSLT},
{{OOO_STRING_SVTOOLS_RTF_PAPERW},        RTF_PAPERW},
{{OOO_STRING_SVTOOLS_RTF_PAPERH},        RTF_PAPERH},
{{OOO_STRING_SVTOOLS_RTF_MARGL},         RTF_MARGL},
{{OOO_STRING_SVTOOLS_RTF_MARGR},         RTF_MARGR},
{{OOO_STRING_SVTOOLS_RTF_MARGT},         RTF_MARGT},
{{OOO_STRING_SVTOOLS_RTF_MARGB},         RTF_MARGB},
{{OOO_STRING_SVTOOLS_RTF_FACINGP},       RTF_FACINGP},
{{OOO_STRING_SVTOOLS_RTF_GUTTER},        RTF_GUTTER},
{{OOO_STRING_SVTOOLS_RTF_DEFTAB},        RTF_DEFTAB},
{{OOO_STRING_SVTOOLS_RTF_WIDOWCTRL},     RTF_WIDOWCTRL},
{{OOO_STRING_SVTOOLS_RTF_HYPHHOTZ},      RTF_HYPHHOTZ},
{{OOO_STRING_SVTOOLS_RTF_FTNSEP},        RTF_FTNSEP},
{{OOO_STRING_SVTOOLS_RTF_FTNSEPC},       RTF_FTNSEPC},
{{OOO_STRING_SVTOOLS_RTF_FTNCN},         RTF_FTNCN},
{{OOO_STRING_SVTOOLS_RTF_ENDNOTES},      RTF_ENDNOTES},
{{OOO_STRING_SVTOOLS_RTF_ENDDOC},        RTF_ENDDOC},
{{OOO_STRING_SVTOOLS_RTF_FTNTJ},         RTF_FTNTJ},
{{OOO_STRING_SVTOOLS_RTF_FTNBJ},         RTF_FTNBJ},
{{OOO_STRING_SVTOOLS_RTF_FTNSTART},      RTF_FTNSTART},
{{OOO_STRING_SVTOOLS_RTF_FTNRESTART},    RTF_FTNRESTART},
{{OOO_STRING_SVTOOLS_RTF_PGNSTART},      RTF_PGNSTART},
{{OOO_STRING_SVTOOLS_RTF_LINESTART},     RTF_LINESTART},
{{OOO_STRING_SVTOOLS_RTF_LANDSCAPE},     RTF_LANDSCAPE},
{{OOO_STRING_SVTOOLS_RTF_FRACWIDTH},     RTF_FRACWIDTH},
{{OOO_STRING_SVTOOLS_RTF_NEXTFILE},      RTF_NEXTFILE},
{{OOO_STRING_SVTOOLS_RTF_TEMPLATE},      RTF_TEMPLATE},
{{OOO_STRING_SVTOOLS_RTF_MAKEBACKUP},    RTF_MAKEBACKUP},
{{OOO_STRING_SVTOOLS_RTF_DEFFORMAT},     RTF_DEFFORMAT},
{{OOO_STRING_SVTOOLS_RTF_REVISIONS},     RTF_REVISIONS},
{{OOO_STRING_SVTOOLS_RTF_MARGMIRROR},    RTF_MARGMIRROR},
{{OOO_STRING_SVTOOLS_RTF_REVPROP},       RTF_REVPROP},
{{OOO_STRING_SVTOOLS_RTF_REVBAR},        RTF_REVBAR},
{{OOO_STRING_SVTOOLS_RTF_SECTD},         RTF_SECTD},
{{OOO_STRING_SVTOOLS_RTF_SBKNONE},       RTF_SBKNONE},
{{OOO_STRING_SVTOOLS_RTF_SBKCOL},        RTF_SBKCOL},
{{OOO_STRING_SVTOOLS_RTF_SBKPAGE},       RTF_SBKPAGE},
{{OOO_STRING_SVTOOLS_RTF_SBKEVEN},       RTF_SBKEVEN},
{{OOO_STRING_SVTOOLS_RTF_SBKODD},        RTF_SBKODD},
{{OOO_STRING_SVTOOLS_RTF_PGNSTARTS},     RTF_PGNSTARTS},
{{OOO_STRING_SVTOOLS_RTF_PGNCONT},       RTF_PGNCONT},
{{OOO_STRING_SVTOOLS_RTF_PGNRESTART},    RTF_PGNRESTART},
{{OOO_STRING_SVTOOLS_RTF_PGNDEC},        RTF_PGNDEC},
{{OOO_STRING_SVTOOLS_RTF_PGNUCRM},       RTF_PGNUCRM},
{{OOO_STRING_SVTOOLS_RTF_PGNLCRM},       RTF_PGNLCRM},
{{OOO_STRING_SVTOOLS_RTF_PGNUCLTR},      RTF_PGNUCLTR},
{{OOO_STRING_SVTOOLS_RTF_PGNLCLTR},      RTF_PGNLCLTR},
{{OOO_STRING_SVTOOLS_RTF_PGNX},          RTF_PGNX},
{{OOO_STRING_SVTOOLS_RTF_PGNY},          RTF_PGNY},
{{OOO_STRING_SVTOOLS_RTF_HEADERY},       RTF_HEADERY},
{{OOO_STRING_SVTOOLS_RTF_FOOTERY},       RTF_FOOTERY},
{{OOO_STRING_SVTOOLS_RTF_LINEMOD},       RTF_LINEMOD},
{{OOO_STRING_SVTOOLS_RTF_LINEX},         RTF_LINEX},
{{OOO_STRING_SVTOOLS_RTF_LINESTARTS},    RTF_LINESTARTS},
{{OOO_STRING_SVTOOLS_RTF_LINERESTART},   RTF_LINERESTART},
{{OOO_STRING_SVTOOLS_RTF_LINEPPAGE},     RTF_LINEPAGE},
{{OOO_STRING_SVTOOLS_RTF_LINECONT},      RTF_LINECONT},
{{OOO_STRING_SVTOOLS_RTF_VERTALT},       RTF_VERTALT},
{{OOO_STRING_SVTOOLS_RTF_VERTALB},       RTF_VERTALB},
{{OOO_STRING_SVTOOLS_RTF_VERTALC},       RTF_VERTALC},
{{OOO_STRING_SVTOOLS_RTF_VERTALJ},       RTF_VERTALJ},
{{OOO_STRING_SVTOOLS_RTF_COLS},          RTF_COLS},
{{OOO_STRING_SVTOOLS_RTF_COLSX},         RTF_COLSX},
{{OOO_STRING_SVTOOLS_RTF_COLNO},			RTF_COLNO},
{{OOO_STRING_SVTOOLS_RTF_COLSR},			RTF_COLSR},
{{OOO_STRING_SVTOOLS_RTF_COLW},			RTF_COLW},
{{OOO_STRING_SVTOOLS_RTF_LINEBETCOL},    RTF_LINEBETCOL},
{{OOO_STRING_SVTOOLS_RTF_ENDNHERE},      RTF_ENDNHERE},
{{OOO_STRING_SVTOOLS_RTF_TITLEPG},       RTF_TITLEPG},
{{OOO_STRING_SVTOOLS_RTF_PARD},          RTF_PARD},
{{OOO_STRING_SVTOOLS_RTF_S},             RTF_S},
{{OOO_STRING_SVTOOLS_RTF_QL},            RTF_QL},
{{OOO_STRING_SVTOOLS_RTF_QR},            RTF_QR},
{{OOO_STRING_SVTOOLS_RTF_QJ},            RTF_QJ},
{{OOO_STRING_SVTOOLS_RTF_QC},            RTF_QC},
{{OOO_STRING_SVTOOLS_RTF_FI},            RTF_FI},
{{OOO_STRING_SVTOOLS_RTF_LI},            RTF_LI},
{{OOO_STRING_SVTOOLS_RTF_LIN},           RTF_LIN},
{{OOO_STRING_SVTOOLS_RTF_RI},            RTF_RI},
{{OOO_STRING_SVTOOLS_RTF_RIN},           RTF_RIN},
{{OOO_STRING_SVTOOLS_RTF_SB},            RTF_SB},
{{OOO_STRING_SVTOOLS_RTF_SA},            RTF_SA},
{{OOO_STRING_SVTOOLS_RTF_SL},            RTF_SL},
{{OOO_STRING_SVTOOLS_RTF_INTBL},         RTF_INTBL},
{{OOO_STRING_SVTOOLS_RTF_KEEP},          RTF_KEEP},
{{OOO_STRING_SVTOOLS_RTF_KEEPN},         RTF_KEEPN},
{{OOO_STRING_SVTOOLS_RTF_LEVEL},			RTF_LEVEL},
{{OOO_STRING_SVTOOLS_RTF_SBYS},          RTF_SBYS},
{{OOO_STRING_SVTOOLS_RTF_PAGEBB},        RTF_PAGEBB},
{{OOO_STRING_SVTOOLS_RTF_NOLINE},        RTF_NOLINE},
{{OOO_STRING_SVTOOLS_RTF_TX},            RTF_TX},
{{OOO_STRING_SVTOOLS_RTF_TQL},           RTF_TQL},
{{OOO_STRING_SVTOOLS_RTF_TQR},           RTF_TQR},
{{OOO_STRING_SVTOOLS_RTF_TQC},           RTF_TQC},
{{OOO_STRING_SVTOOLS_RTF_TQDEC},         RTF_TQDEC},
{{OOO_STRING_SVTOOLS_RTF_TB},            RTF_TB},
{{OOO_STRING_SVTOOLS_RTF_BRDRT},         RTF_BRDRT},
{{OOO_STRING_SVTOOLS_RTF_BRDRB},         RTF_BRDRB},
{{OOO_STRING_SVTOOLS_RTF_BRDRL},         RTF_BRDRL},
{{OOO_STRING_SVTOOLS_RTF_BRDRR},         RTF_BRDRR},
{{OOO_STRING_SVTOOLS_RTF_BOX},           RTF_BOX},
{{OOO_STRING_SVTOOLS_RTF_BRDRS},         RTF_BRDRS},
{{OOO_STRING_SVTOOLS_RTF_BRDRTH},        RTF_BRDRTH},
{{OOO_STRING_SVTOOLS_RTF_BRDRSH},        RTF_BRDRSH},
{{OOO_STRING_SVTOOLS_RTF_BRDRDB},        RTF_BRDRDB},
{{OOO_STRING_SVTOOLS_RTF_BRDRDOT},       RTF_BRDRDOT},
{{OOO_STRING_SVTOOLS_RTF_BRDRHAIR},      RTF_BRDRHAIR},
{{OOO_STRING_SVTOOLS_RTF_BRSP},          RTF_BRSP},
{{OOO_STRING_SVTOOLS_RTF_TLDOT},         RTF_TLDOT},
{{OOO_STRING_SVTOOLS_RTF_TLHYPH},        RTF_TLHYPH},
{{OOO_STRING_SVTOOLS_RTF_TLUL},          RTF_TLUL},
{{OOO_STRING_SVTOOLS_RTF_TLTH},          RTF_TLTH},
{{OOO_STRING_SVTOOLS_RTF_POSX},          RTF_POSX},
{{OOO_STRING_SVTOOLS_RTF_POSXC},         RTF_POSXC},
{{OOO_STRING_SVTOOLS_RTF_POSXI},         RTF_POSXI},
{{OOO_STRING_SVTOOLS_RTF_POSXL},         RTF_POSXL},
{{OOO_STRING_SVTOOLS_RTF_POSXO},         RTF_POSXO},
{{OOO_STRING_SVTOOLS_RTF_POSXR},         RTF_POSXR},
{{OOO_STRING_SVTOOLS_RTF_POSY},          RTF_POSY},
{{OOO_STRING_SVTOOLS_RTF_POSYIL},        RTF_POSYIL},
{{OOO_STRING_SVTOOLS_RTF_POSYT},         RTF_POSYT},
{{OOO_STRING_SVTOOLS_RTF_POSYC},         RTF_POSYC},
{{OOO_STRING_SVTOOLS_RTF_POSYB},         RTF_POSYB},
{{OOO_STRING_SVTOOLS_RTF_ABSW},          RTF_ABSW},
{{OOO_STRING_SVTOOLS_RTF_DXFRTEXT},      RTF_DXFRTEXT},
{{OOO_STRING_SVTOOLS_RTF_PVMRG},         RTF_PVMRG},
{{OOO_STRING_SVTOOLS_RTF_PVPG},          RTF_PVPG},
{{OOO_STRING_SVTOOLS_RTF_PHMRG},         RTF_PHMRG},
{{OOO_STRING_SVTOOLS_RTF_PHPG},          RTF_PHPG},
{{OOO_STRING_SVTOOLS_RTF_PHCOL},         RTF_PHCOL},
{{OOO_STRING_SVTOOLS_RTF_CLBRDRB},       RTF_CLBRDRB},
{{OOO_STRING_SVTOOLS_RTF_CLBRDRT},       RTF_CLBRDRT},
{{OOO_STRING_SVTOOLS_RTF_CLBRDRL},       RTF_CLBRDRL},
{{OOO_STRING_SVTOOLS_RTF_CLBRDRR},       RTF_CLBRDRR},
{{OOO_STRING_SVTOOLS_RTF_CLPADL},        RTF_CLPADL},
{{OOO_STRING_SVTOOLS_RTF_CLPADT},        RTF_CLPADT},
{{OOO_STRING_SVTOOLS_RTF_CLPADB},        RTF_CLPADB},
{{OOO_STRING_SVTOOLS_RTF_CLPADR},        RTF_CLPADR},
{{OOO_STRING_SVTOOLS_RTF_CLPADFL},       RTF_CLPADFL},
{{OOO_STRING_SVTOOLS_RTF_CLPADFT},       RTF_CLPADFT},
{{OOO_STRING_SVTOOLS_RTF_CLPADFB},       RTF_CLPADFB},
{{OOO_STRING_SVTOOLS_RTF_CLPADFR},       RTF_CLPADFR},
{{OOO_STRING_SVTOOLS_RTF_TROWD},         RTF_TROWD},
{{OOO_STRING_SVTOOLS_RTF_TRQL},          RTF_TRQL},
{{OOO_STRING_SVTOOLS_RTF_TRQR},          RTF_TRQR},
{{OOO_STRING_SVTOOLS_RTF_TRQC},          RTF_TRQC},
{{OOO_STRING_SVTOOLS_RTF_TRGAPH},        RTF_TRGAPH},
{{OOO_STRING_SVTOOLS_RTF_TRRH},          RTF_TRRH},
{{OOO_STRING_SVTOOLS_RTF_TRLEFT},        RTF_TRLEFT},
{{OOO_STRING_SVTOOLS_RTF_CELLX},         RTF_CELLX},
{{OOO_STRING_SVTOOLS_RTF_CLMGF},         RTF_CLMGF},
{{OOO_STRING_SVTOOLS_RTF_CLMRG},         RTF_CLMRG},
{{OOO_STRING_SVTOOLS_RTF_PLAIN},         RTF_PLAIN},
{{OOO_STRING_SVTOOLS_RTF_B},             RTF_B},
{{OOO_STRING_SVTOOLS_RTF_I},             RTF_I},
{{OOO_STRING_SVTOOLS_RTF_STRIKE},        RTF_STRIKE},
{{OOO_STRING_SVTOOLS_RTF_OUTL},          RTF_OUTL},
{{OOO_STRING_SVTOOLS_RTF_SHAD},          RTF_SHAD},
{{OOO_STRING_SVTOOLS_RTF_SCAPS},         RTF_SCAPS},
{{OOO_STRING_SVTOOLS_RTF_CAPS},          RTF_CAPS},
{{OOO_STRING_SVTOOLS_RTF_V},             RTF_V},
{{OOO_STRING_SVTOOLS_RTF_F},             RTF_F},
{{OOO_STRING_SVTOOLS_RTF_FS},            RTF_FS},
{{OOO_STRING_SVTOOLS_RTF_EXPND},         RTF_EXPND},
{{OOO_STRING_SVTOOLS_RTF_EXPNDTW},       RTF_EXPNDTW},
{{OOO_STRING_SVTOOLS_RTF_KERNING},       RTF_KERNING},
{{OOO_STRING_SVTOOLS_RTF_UL},            RTF_UL},
{{OOO_STRING_SVTOOLS_RTF_ULW},           RTF_ULW},
{{OOO_STRING_SVTOOLS_RTF_ULD},           RTF_ULD},
{{OOO_STRING_SVTOOLS_RTF_ULDB},          RTF_ULDB},
{{OOO_STRING_SVTOOLS_RTF_ULNONE},        RTF_ULNONE},
{{OOO_STRING_SVTOOLS_RTF_UP},            RTF_UP},
{{OOO_STRING_SVTOOLS_RTF_DN},            RTF_DN},
{{OOO_STRING_SVTOOLS_RTF_REVISED},       RTF_REVISED},
{{OOO_STRING_SVTOOLS_RTF_SUB},			RTF_SUB},
{{OOO_STRING_SVTOOLS_RTF_NOSUPERSUB},	RTF_NOSUPERSUB},
{{OOO_STRING_SVTOOLS_RTF_SUPER},			RTF_SUPER},
{{OOO_STRING_SVTOOLS_RTF_CHDATE},        RTF_CHDATE},
{{OOO_STRING_SVTOOLS_RTF_CHTIME},        RTF_CHTIME},
{{OOO_STRING_SVTOOLS_RTF_CHPGN},         RTF_CHPGN},
{{OOO_STRING_SVTOOLS_RTF_CHFTN},         RTF_CHFTN},
{{OOO_STRING_SVTOOLS_RTF_CHATN},         RTF_CHATN},
{{OOO_STRING_SVTOOLS_RTF_CHFTNSEP},      RTF_CHFTNSEP},
{{OOO_STRING_SVTOOLS_RTF_CHFTNSEPC},     RTF_CHFTNSEPC},
{{OOO_STRING_SVTOOLS_RTF_FORMULA},       RTF_FORMULA},
{{OOO_STRING_SVTOOLS_RTF_NOBREAK},       RTF_NONBREAKINGSPACE},
{{OOO_STRING_SVTOOLS_RTF_OPTHYPH},       RTF_OPTIONALHYPHEN},
{{OOO_STRING_SVTOOLS_RTF_NOBRKHYPH},     RTF_NONBREAKINGHYPHEN},
{{OOO_STRING_SVTOOLS_RTF_HEXCHAR},       RTF_HEX},
{{OOO_STRING_SVTOOLS_RTF_CELL},          RTF_CELL},
{{OOO_STRING_SVTOOLS_RTF_ROW},           RTF_ROW},
{{OOO_STRING_SVTOOLS_RTF_PAR},           RTF_PAR},
{{OOO_STRING_SVTOOLS_RTF_SECT},          RTF_SECT},
{{OOO_STRING_SVTOOLS_RTF_PAGE},          RTF_PAGE},
{{OOO_STRING_SVTOOLS_RTF_COLUMN},        RTF_COLUM},
{{OOO_STRING_SVTOOLS_RTF_LINE},          RTF_LINE},
{{OOO_STRING_SVTOOLS_RTF_TAB},           RTF_TAB},
{{OOO_STRING_SVTOOLS_RTF_SUBENTRY},      RTF_SUBENTRYINDEX},

{{OOO_STRING_SVTOOLS_RTF_DEFLANG},       RTF_DEFLANG},
{{OOO_STRING_SVTOOLS_RTF_LANG},          RTF_LANG},
{{OOO_STRING_SVTOOLS_RTF_PMMETAFILE},    RTF_OSMETAFILE},
{{OOO_STRING_SVTOOLS_RTF_DIBITMAP},      RTF_DIBITMAP},
{{OOO_STRING_SVTOOLS_RTF_KEYCODE},       RTF_KEYCODE},
{{OOO_STRING_SVTOOLS_RTF_FN},            RTF_FNKEY},
{{OOO_STRING_SVTOOLS_RTF_ALT},           RTF_ALTKEY},
{{OOO_STRING_SVTOOLS_RTF_SHIFT},         RTF_SHIFTKEY},
{{OOO_STRING_SVTOOLS_RTF_CTRL},          RTF_CTRLKEY},
{{OOO_STRING_SVTOOLS_RTF_CHDPL},         RTF_CHDATEL},
{{OOO_STRING_SVTOOLS_RTF_CHDPA},         RTF_CHDATEA},
{{OOO_STRING_SVTOOLS_RTF_EMDASH},        RTF_EMDASH},
{{OOO_STRING_SVTOOLS_RTF_ENDASH},        RTF_ENDASH},
{{OOO_STRING_SVTOOLS_RTF_BULLET},        RTF_BULLET},
{{OOO_STRING_SVTOOLS_RTF_LQUOTE},        RTF_LQUOTE},
{{OOO_STRING_SVTOOLS_RTF_RQUOTE},        RTF_RQUOTE},
{{OOO_STRING_SVTOOLS_RTF_LDBLQUOTE},     RTF_LDBLQUOTE},
{{OOO_STRING_SVTOOLS_RTF_RDBLQUOTE},     RTF_RDBLQUOTE},

{{OOO_STRING_SVTOOLS_RTF_BKMKCOLF},      RTF_BKMKCOLF},
{{OOO_STRING_SVTOOLS_RTF_BKMKCOLL},      RTF_BKMKCOLL},
{{OOO_STRING_SVTOOLS_RTF_PSOVER},        RTF_PSOVER},
{{OOO_STRING_SVTOOLS_RTF_DOCTEMP},       RTF_DOCTEMP},
{{OOO_STRING_SVTOOLS_RTF_BINFSXN},       RTF_BINFSXN},
{{OOO_STRING_SVTOOLS_RTF_BINSXN},        RTF_BINSXN},
{{OOO_STRING_SVTOOLS_RTF_PGWSXN},        RTF_PGWSXN},
{{OOO_STRING_SVTOOLS_RTF_PGHSXN},        RTF_PGHSXN},
{{OOO_STRING_SVTOOLS_RTF_MARGLSXN},      RTF_MARGLSXN},
{{OOO_STRING_SVTOOLS_RTF_MARGRSXN},      RTF_MARGRSXN},
{{OOO_STRING_SVTOOLS_RTF_MARGTSXN},      RTF_MARGTSXN},
{{OOO_STRING_SVTOOLS_RTF_MARGBSXN},      RTF_MARGBSXN},
{{OOO_STRING_SVTOOLS_RTF_GUTTERSXN},     RTF_GUTTERSXN},
{{OOO_STRING_SVTOOLS_RTF_LNDSCPSXN},     RTF_LNDSCPSXN},
{{OOO_STRING_SVTOOLS_RTF_FACPGSXN},      RTF_FACPGSXN},
{{OOO_STRING_SVTOOLS_RTF_TLEQ},          RTF_TLEQ},
{{OOO_STRING_SVTOOLS_RTF_BRDRBTW},       RTF_BRDRBTW},
{{OOO_STRING_SVTOOLS_RTF_BRDRBAR},       RTF_BRDRBAR},
{{OOO_STRING_SVTOOLS_RTF_BRDRW},         RTF_BRDRW},
{{OOO_STRING_SVTOOLS_RTF_BRDRCF},        RTF_BRDRCF},
{{OOO_STRING_SVTOOLS_RTF_ABSH},          RTF_ABSH},
{{OOO_STRING_SVTOOLS_RTF_PVPARA},        RTF_PVPARA},
{{OOO_STRING_SVTOOLS_RTF_NOWRAP},        RTF_NOWRAP},
{{OOO_STRING_SVTOOLS_RTF_DFRMTXTX},      RTF_DFRMTXTX},
{{OOO_STRING_SVTOOLS_RTF_DFRMTXTY},      RTF_DFRMTXTY},
{{OOO_STRING_SVTOOLS_RTF_DROPCAPLI},     RTF_DROPCAPLI},
{{OOO_STRING_SVTOOLS_RTF_DROPCAPT},      RTF_DROPCAPT},
{{OOO_STRING_SVTOOLS_RTF_ABSNOOVRLP},    RTF_ABSNOOVRLP},
{{OOO_STRING_SVTOOLS_RTF_POSNEGX},       RTF_POSNEGX},
{{OOO_STRING_SVTOOLS_RTF_POSNEGY},       RTF_POSNEGY},
{{OOO_STRING_SVTOOLS_RTF_DELETED},       RTF_DELETED},

{{OOO_STRING_SVTOOLS_RTF_SHADING},       RTF_SHADING},
{{OOO_STRING_SVTOOLS_RTF_BGHORIZ},       RTF_BGHORIZ},
{{OOO_STRING_SVTOOLS_RTF_BGVERT},        RTF_BGVERT},
{{OOO_STRING_SVTOOLS_RTF_BGFDIAG},       RTF_BGFDIAG},
{{OOO_STRING_SVTOOLS_RTF_BGBDIAG},       RTF_BGBDIAG},
{{OOO_STRING_SVTOOLS_RTF_BGCROSS},       RTF_BGCROSS},
{{OOO_STRING_SVTOOLS_RTF_BGDCROSS},      RTF_BGDCROSS},
{{OOO_STRING_SVTOOLS_RTF_BGDKHORIZ},     RTF_BGDKHORIZ},
{{OOO_STRING_SVTOOLS_RTF_BGDKVERT},      RTF_BGDKVERT},
{{OOO_STRING_SVTOOLS_RTF_BGDKFDIAG},     RTF_BGDKFDIAG},
{{OOO_STRING_SVTOOLS_RTF_BGDKBDIAG},     RTF_BGDKBDIAG},
{{OOO_STRING_SVTOOLS_RTF_BGDKCROSS},     RTF_BGDKCROSS},
{{OOO_STRING_SVTOOLS_RTF_BGDKDCROSS},    RTF_BGDKDCROSS},
{{OOO_STRING_SVTOOLS_RTF_CFPAT},         RTF_CFPAT},
{{OOO_STRING_SVTOOLS_RTF_CBPAT},         RTF_CBPAT},

{{OOO_STRING_SVTOOLS_RTF_CLSHDNG},       RTF_CLSHDNG},
{{OOO_STRING_SVTOOLS_RTF_CLBGHORIZ},     RTF_CLBGHORIZ},
{{OOO_STRING_SVTOOLS_RTF_CLBGVERT},      RTF_CLBGVERT},
{{OOO_STRING_SVTOOLS_RTF_CLBGFDIAG},     RTF_CLBGFDIAG},
{{OOO_STRING_SVTOOLS_RTF_CLBGBDIAG},     RTF_CLBGBDIAG},
{{OOO_STRING_SVTOOLS_RTF_CLBGCROSS},     RTF_CLBGCROSS},
{{OOO_STRING_SVTOOLS_RTF_CLBGDCROSS},    RTF_CLBGDCROSS},
{{OOO_STRING_SVTOOLS_RTF_CLBGDKHOR},   	RTF_CLBGDKHOR},
{{OOO_STRING_SVTOOLS_RTF_CLBGDKVERT},    RTF_CLBGDKVERT},
{{OOO_STRING_SVTOOLS_RTF_CLBGDKFDIAG},   RTF_CLBGDKFDIAG},
{{OOO_STRING_SVTOOLS_RTF_CLBGDKBDIAG},   RTF_CLBGDKBDIAG},
{{OOO_STRING_SVTOOLS_RTF_CLBGDKCROSS},   RTF_CLBGDKCROSS},
{{OOO_STRING_SVTOOLS_RTF_CLBGDKDCROSS},  RTF_CLBGDKDCROSS},
{{OOO_STRING_SVTOOLS_RTF_CLCFPAT},       RTF_CLCFPAT},
{{OOO_STRING_SVTOOLS_RTF_CLCBPAT},       RTF_CLCBPAT},

{{OOO_STRING_SVTOOLS_RTF_AB},			RTF_AB},
{{OOO_STRING_SVTOOLS_RTF_ACAPS},			RTF_ACAPS},
{{OOO_STRING_SVTOOLS_RTF_ACF},			RTF_ACF},
{{OOO_STRING_SVTOOLS_RTF_ADDITIVE},		RTF_ADDITIVE},
{{OOO_STRING_SVTOOLS_RTF_ADN},			RTF_ADN},
{{OOO_STRING_SVTOOLS_RTF_AENDDOC},		RTF_AENDDOC},
{{OOO_STRING_SVTOOLS_RTF_AENDNOTES},		RTF_AENDNOTES},
{{OOO_STRING_SVTOOLS_RTF_AEXPND},		RTF_AEXPND},
{{OOO_STRING_SVTOOLS_RTF_AF},			RTF_AF},
{{OOO_STRING_SVTOOLS_RTF_AFS},			RTF_AFS},
{{OOO_STRING_SVTOOLS_RTF_AFTNBJ},		RTF_AFTNBJ},
{{OOO_STRING_SVTOOLS_RTF_AFTNCN},		RTF_AFTNCN},
{{OOO_STRING_SVTOOLS_RTF_AFTNNALC},		RTF_AFTNNALC},
{{OOO_STRING_SVTOOLS_RTF_AFTNNAR},		RTF_AFTNNAR},
{{OOO_STRING_SVTOOLS_RTF_AFTNNAUC},		RTF_AFTNNAUC},
{{OOO_STRING_SVTOOLS_RTF_AFTNNCHI},		RTF_AFTNNCHI},
{{OOO_STRING_SVTOOLS_RTF_AFTNNRLC},		RTF_AFTNNRLC},
{{OOO_STRING_SVTOOLS_RTF_AFTNNRUC},		RTF_AFTNNRUC},
{{OOO_STRING_SVTOOLS_RTF_AFTNRESTART},	RTF_AFTNRESTART},
{{OOO_STRING_SVTOOLS_RTF_AFTNRSTCONT},	RTF_AFTNRSTCONT},
{{OOO_STRING_SVTOOLS_RTF_AFTNSEP},		RTF_AFTNSEP},
{{OOO_STRING_SVTOOLS_RTF_AFTNSEPC},		RTF_AFTNSEPC},
{{OOO_STRING_SVTOOLS_RTF_AFTNSTART},		RTF_AFTNSTART},
{{OOO_STRING_SVTOOLS_RTF_AFTNTJ},		RTF_AFTNTJ},
{{OOO_STRING_SVTOOLS_RTF_AI},			RTF_AI},
{{OOO_STRING_SVTOOLS_RTF_ALANG},			RTF_ALANG},
{{OOO_STRING_SVTOOLS_RTF_ALLPROT},		RTF_ALLPROT},
{{OOO_STRING_SVTOOLS_RTF_ANNOTPROT},		RTF_ANNOTPROT},
{{OOO_STRING_SVTOOLS_RTF_AOUTL},			RTF_AOUTL},
{{OOO_STRING_SVTOOLS_RTF_ASCAPS},		RTF_ASCAPS},
{{OOO_STRING_SVTOOLS_RTF_ASHAD},			RTF_ASHAD},
{{OOO_STRING_SVTOOLS_RTF_ASTRIKE},		RTF_ASTRIKE},
{{OOO_STRING_SVTOOLS_RTF_ATNAUTHOR},		RTF_ATNAUTHOR},
{{OOO_STRING_SVTOOLS_RTF_ATNICN},		RTF_ATNICN},
{{OOO_STRING_SVTOOLS_RTF_ATNREF},		RTF_ATNREF},
{{OOO_STRING_SVTOOLS_RTF_ATNTIME},		RTF_ATNTIME},
{{OOO_STRING_SVTOOLS_RTF_ATRFEND},		RTF_ATRFEND},
{{OOO_STRING_SVTOOLS_RTF_ATRFSTART},		RTF_ATRFSTART},
{{OOO_STRING_SVTOOLS_RTF_AUL},			RTF_AUL},
{{OOO_STRING_SVTOOLS_RTF_AULD},			RTF_AULD},
{{OOO_STRING_SVTOOLS_RTF_AULDB},			RTF_AULDB},
{{OOO_STRING_SVTOOLS_RTF_AULNONE},		RTF_AULNONE},
{{OOO_STRING_SVTOOLS_RTF_AULW},			RTF_AULW},
{{OOO_STRING_SVTOOLS_RTF_AUP},			RTF_AUP},
{{OOO_STRING_SVTOOLS_RTF_BKMKPUB},		RTF_BKMKPUB},
{{OOO_STRING_SVTOOLS_RTF_BRDRDASH},		RTF_BRDRDASH},
{{OOO_STRING_SVTOOLS_RTF_BRKFRM},		RTF_BRKFRM},
{{OOO_STRING_SVTOOLS_RTF_CCHS},			RTF_CCHS},
{{OOO_STRING_SVTOOLS_RTF_CPG},			RTF_CPG},
{{OOO_STRING_SVTOOLS_RTF_CS},			RTF_CS},
{{OOO_STRING_SVTOOLS_RTF_CVMME},			RTF_CVMME},
{{OOO_STRING_SVTOOLS_RTF_DATAFIELD},		RTF_DATAFIELD},
{{OOO_STRING_SVTOOLS_RTF_DO},			RTF_DO},
{{OOO_STRING_SVTOOLS_RTF_DOBXCOLUMN},	RTF_DOBXCOLUMN},
{{OOO_STRING_SVTOOLS_RTF_DOBXMARGIN},	RTF_DOBXMARGIN},
{{OOO_STRING_SVTOOLS_RTF_DOBXPAGE},		RTF_DOBXPAGE},
{{OOO_STRING_SVTOOLS_RTF_DOBYMARGIN},	RTF_DOBYMARGIN},
{{OOO_STRING_SVTOOLS_RTF_DOBYPAGE},		RTF_DOBYPAGE},
{{OOO_STRING_SVTOOLS_RTF_DOBYPARA},		RTF_DOBYPARA},
{{OOO_STRING_SVTOOLS_RTF_DODHGT},		RTF_DODHGT},
{{OOO_STRING_SVTOOLS_RTF_DOLOCK},		RTF_DOLOCK},
{{OOO_STRING_SVTOOLS_RTF_DPAENDHOL},		RTF_DPAENDHOL},
{{OOO_STRING_SVTOOLS_RTF_DPAENDL},		RTF_DPAENDL},
{{OOO_STRING_SVTOOLS_RTF_DPAENDSOL},		RTF_DPAENDSOL},
{{OOO_STRING_SVTOOLS_RTF_DPAENDW},		RTF_DPAENDW},
{{OOO_STRING_SVTOOLS_RTF_DPARC},			RTF_DPARC},
{{OOO_STRING_SVTOOLS_RTF_DPARCFLIPX},	RTF_DPARCFLIPX},
{{OOO_STRING_SVTOOLS_RTF_DPARCFLIPY},	RTF_DPARCFLIPY},
{{OOO_STRING_SVTOOLS_RTF_DPASTARTHOL},	RTF_DPASTARTHOL},
{{OOO_STRING_SVTOOLS_RTF_DPASTARTL},		RTF_DPASTARTL},
{{OOO_STRING_SVTOOLS_RTF_DPASTARTSOL},	RTF_DPASTARTSOL},
{{OOO_STRING_SVTOOLS_RTF_DPASTARTW},		RTF_DPASTARTW},
{{OOO_STRING_SVTOOLS_RTF_DPCALLOUT},		RTF_DPCALLOUT},
{{OOO_STRING_SVTOOLS_RTF_DPCOA},			RTF_DPCOA},
{{OOO_STRING_SVTOOLS_RTF_DPCOACCENT},	RTF_DPCOACCENT},
{{OOO_STRING_SVTOOLS_RTF_DPCOBESTFIT},	RTF_DPCOBESTFIT},
{{OOO_STRING_SVTOOLS_RTF_DPCOBORDER},	RTF_DPCOBORDER},
{{OOO_STRING_SVTOOLS_RTF_DPCODABS},		RTF_DPCODABS},
{{OOO_STRING_SVTOOLS_RTF_DPCODBOTTOM},	RTF_DPCODBOTTOM},
{{OOO_STRING_SVTOOLS_RTF_DPCODCENTER},	RTF_DPCODCENTER},
{{OOO_STRING_SVTOOLS_RTF_DPCODTOP},		RTF_DPCODTOP},
{{OOO_STRING_SVTOOLS_RTF_DPCOLENGTH},	RTF_DPCOLENGTH},
{{OOO_STRING_SVTOOLS_RTF_DPCOMINUSX},	RTF_DPCOMINUSX},
{{OOO_STRING_SVTOOLS_RTF_DPCOMINUSY},	RTF_DPCOMINUSY},
{{OOO_STRING_SVTOOLS_RTF_DPCOOFFSET},	RTF_DPCOOFFSET},
{{OOO_STRING_SVTOOLS_RTF_DPCOSMARTA},	RTF_DPCOSMARTA},
{{OOO_STRING_SVTOOLS_RTF_DPCOTDOUBLE},	RTF_DPCOTDOUBLE},
{{OOO_STRING_SVTOOLS_RTF_DPCOTRIGHT},	RTF_DPCOTRIGHT},
{{OOO_STRING_SVTOOLS_RTF_DPCOTSINGLE},	RTF_DPCOTSINGLE},
{{OOO_STRING_SVTOOLS_RTF_DPCOTTRIPLE},	RTF_DPCOTTRIPLE},
{{OOO_STRING_SVTOOLS_RTF_DPCOUNT},		RTF_DPCOUNT},
{{OOO_STRING_SVTOOLS_RTF_DPELLIPSE},		RTF_DPELLIPSE},
{{OOO_STRING_SVTOOLS_RTF_DPENDGROUP},	RTF_DPENDGROUP},
{{OOO_STRING_SVTOOLS_RTF_DPFILLBGCB},	RTF_DPFILLBGCB},
{{OOO_STRING_SVTOOLS_RTF_DPFILLBGCG},	RTF_DPFILLBGCG},
{{OOO_STRING_SVTOOLS_RTF_DPFILLBGCR},	RTF_DPFILLBGCR},
{{OOO_STRING_SVTOOLS_RTF_DPFILLBGGRAY},	RTF_DPFILLBGGRAY},
{{OOO_STRING_SVTOOLS_RTF_DPFILLBGPAL},	RTF_DPFILLBGPAL},
{{OOO_STRING_SVTOOLS_RTF_DPFILLFGCB},	RTF_DPFILLFGCB},
{{OOO_STRING_SVTOOLS_RTF_DPFILLFGCG},	RTF_DPFILLFGCG},
{{OOO_STRING_SVTOOLS_RTF_DPFILLFGCR},	RTF_DPFILLFGCR},
{{OOO_STRING_SVTOOLS_RTF_DPFILLFGGRAY},	RTF_DPFILLFGGRAY},
{{OOO_STRING_SVTOOLS_RTF_DPFILLFGPAL},	RTF_DPFILLFGPAL},
{{OOO_STRING_SVTOOLS_RTF_DPFILLPAT},		RTF_DPFILLPAT},
{{OOO_STRING_SVTOOLS_RTF_DPGROUP},		RTF_DPGROUP},
{{OOO_STRING_SVTOOLS_RTF_DPLINE},		RTF_DPLINE},
{{OOO_STRING_SVTOOLS_RTF_DPLINECOB},		RTF_DPLINECOB},
{{OOO_STRING_SVTOOLS_RTF_DPLINECOG},		RTF_DPLINECOG},
{{OOO_STRING_SVTOOLS_RTF_DPLINECOR},		RTF_DPLINECOR},
{{OOO_STRING_SVTOOLS_RTF_DPLINEDADO},	RTF_DPLINEDADO},
{{OOO_STRING_SVTOOLS_RTF_DPLINEDADODO},	RTF_DPLINEDADODO},
{{OOO_STRING_SVTOOLS_RTF_DPLINEDASH},	RTF_DPLINEDASH},
{{OOO_STRING_SVTOOLS_RTF_DPLINEDOT},		RTF_DPLINEDOT},
{{OOO_STRING_SVTOOLS_RTF_DPLINEGRAY},	RTF_DPLINEGRAY},
{{OOO_STRING_SVTOOLS_RTF_DPLINEHOLLOW},	RTF_DPLINEHOLLOW},
{{OOO_STRING_SVTOOLS_RTF_DPLINEPAL},		RTF_DPLINEPAL},
{{OOO_STRING_SVTOOLS_RTF_DPLINESOLID},	RTF_DPLINESOLID},
{{OOO_STRING_SVTOOLS_RTF_DPLINEW},		RTF_DPLINEW},
{{OOO_STRING_SVTOOLS_RTF_DPPOLYCOUNT},	RTF_DPPOLYCOUNT},
{{OOO_STRING_SVTOOLS_RTF_DPPOLYGON},		RTF_DPPOLYGON},
{{OOO_STRING_SVTOOLS_RTF_DPPOLYLINE},	RTF_DPPOLYLINE},
{{OOO_STRING_SVTOOLS_RTF_DPPTX},			RTF_DPPTX},
{{OOO_STRING_SVTOOLS_RTF_DPPTY},			RTF_DPPTY},
{{OOO_STRING_SVTOOLS_RTF_DPRECT},		RTF_DPRECT},
{{OOO_STRING_SVTOOLS_RTF_DPROUNDR},		RTF_DPROUNDR},
{{OOO_STRING_SVTOOLS_RTF_DPSHADOW},		RTF_DPSHADOW},
{{OOO_STRING_SVTOOLS_RTF_DPSHADX},		RTF_DPSHADX},
{{OOO_STRING_SVTOOLS_RTF_DPSHADY},		RTF_DPSHADY},
{{OOO_STRING_SVTOOLS_RTF_DPTXBX},		RTF_DPTXBX},
{{OOO_STRING_SVTOOLS_RTF_DPTXBXMAR},		RTF_DPTXBXMAR},
{{OOO_STRING_SVTOOLS_RTF_DPTXBXTEXT},	RTF_DPTXBXTEXT},
{{OOO_STRING_SVTOOLS_RTF_DPX},			RTF_DPX},
{{OOO_STRING_SVTOOLS_RTF_DPXSIZE},		RTF_DPXSIZE},
{{OOO_STRING_SVTOOLS_RTF_DPY},			RTF_DPY},
{{OOO_STRING_SVTOOLS_RTF_DPYSIZE},		RTF_DPYSIZE},
{{OOO_STRING_SVTOOLS_RTF_DS},			RTF_DS},
{{OOO_STRING_SVTOOLS_RTF_EMSPACE},		RTF_EMSPACE},
{{OOO_STRING_SVTOOLS_RTF_ENSPACE},		RTF_ENSPACE},
{{OOO_STRING_SVTOOLS_RTF_FBIDI},			RTF_FBIDI},
{{OOO_STRING_SVTOOLS_RTF_FET},			RTF_FET},
{{OOO_STRING_SVTOOLS_RTF_FID},			RTF_FID},
{{OOO_STRING_SVTOOLS_RTF_FILE},			RTF_FILE},
{{OOO_STRING_SVTOOLS_RTF_FILETBL},		RTF_FILETBL},
{{OOO_STRING_SVTOOLS_RTF_FLDALT},		RTF_FLDALT},
{{OOO_STRING_SVTOOLS_RTF_FNETWORK},		RTF_FNETWORK},
{{OOO_STRING_SVTOOLS_RTF_FONTEMB},		RTF_FONTEMB},
{{OOO_STRING_SVTOOLS_RTF_FONTFILE},		RTF_FONTFILE},
{{OOO_STRING_SVTOOLS_RTF_FORMDISP},		RTF_FORMDISP},
{{OOO_STRING_SVTOOLS_RTF_FORMPROT},		RTF_FORMPROT},
{{OOO_STRING_SVTOOLS_RTF_FORMSHADE},		RTF_FORMSHADE},
{{OOO_STRING_SVTOOLS_RTF_FOSNUM},		RTF_FOSNUM},
{{OOO_STRING_SVTOOLS_RTF_FRELATIVE},		RTF_FRELATIVE},
{{OOO_STRING_SVTOOLS_RTF_FTNALT},		RTF_FTNALT},
{{OOO_STRING_SVTOOLS_RTF_FTNIL},			RTF_FTNIL},
{{OOO_STRING_SVTOOLS_RTF_FTNNALC},		RTF_FTNNALC},
{{OOO_STRING_SVTOOLS_RTF_FTNNAR},		RTF_FTNNAR},
{{OOO_STRING_SVTOOLS_RTF_FTNNAUC},		RTF_FTNNAUC},
{{OOO_STRING_SVTOOLS_RTF_FTNNCHI},		RTF_FTNNCHI},
{{OOO_STRING_SVTOOLS_RTF_FTNNRLC},		RTF_FTNNRLC},
{{OOO_STRING_SVTOOLS_RTF_FTNNRUC},		RTF_FTNNRUC},
{{OOO_STRING_SVTOOLS_RTF_FTNRSTCONT},	RTF_FTNRSTCONT},
{{OOO_STRING_SVTOOLS_RTF_FTNRSTPG},		RTF_FTNRSTPG},
{{OOO_STRING_SVTOOLS_RTF_FTTRUETYPE},	RTF_FTTRUETYPE},
{{OOO_STRING_SVTOOLS_RTF_FVALIDDOS},		RTF_FVALIDDOS},
{{OOO_STRING_SVTOOLS_RTF_FVALIDHPFS},	RTF_FVALIDHPFS},
{{OOO_STRING_SVTOOLS_RTF_FVALIDMAC},		RTF_FVALIDMAC},
{{OOO_STRING_SVTOOLS_RTF_FVALIDNTFS},	RTF_FVALIDNTFS},
{{OOO_STRING_SVTOOLS_RTF_HYPHAUTO},		RTF_HYPHAUTO},
{{OOO_STRING_SVTOOLS_RTF_HYPHCAPS},		RTF_HYPHCAPS},
{{OOO_STRING_SVTOOLS_RTF_HYPHCONSEC},	RTF_HYPHCONSEC},
{{OOO_STRING_SVTOOLS_RTF_HYPHPAR},		RTF_HYPHPAR},
{{OOO_STRING_SVTOOLS_RTF_LINKSELF},		RTF_LINKSELF},
{{OOO_STRING_SVTOOLS_RTF_LINKSTYLES},	RTF_LINKSTYLES},
{{OOO_STRING_SVTOOLS_RTF_LTRCH},			RTF_LTRCH},
{{OOO_STRING_SVTOOLS_RTF_LTRDOC},		RTF_LTRDOC},
{{OOO_STRING_SVTOOLS_RTF_LTRMARK},		RTF_LTRMARK},
{{OOO_STRING_SVTOOLS_RTF_LTRPAR},		RTF_LTRPAR},
{{OOO_STRING_SVTOOLS_RTF_LTRROW},		RTF_LTRROW},
{{OOO_STRING_SVTOOLS_RTF_LTRSECT},		RTF_LTRSECT},
{{OOO_STRING_SVTOOLS_RTF_NOCOLBAL},		RTF_NOCOLBAL},
{{OOO_STRING_SVTOOLS_RTF_NOEXTRASPRL},	RTF_NOEXTRASPRL},
{{OOO_STRING_SVTOOLS_RTF_NOTABIND},		RTF_NOTABIND},
{{OOO_STRING_SVTOOLS_RTF_NOWIDCTLPAR},	RTF_NOWIDCTLPAR},
{{OOO_STRING_SVTOOLS_RTF_OBJALIAS},		RTF_OBJALIAS},
{{OOO_STRING_SVTOOLS_RTF_OBJALIGN},		RTF_OBJALIGN},
{{OOO_STRING_SVTOOLS_RTF_OBJAUTLINK},	RTF_OBJAUTLINK},
{{OOO_STRING_SVTOOLS_RTF_OBJCLASS},		RTF_OBJCLASS},
{{OOO_STRING_SVTOOLS_RTF_OBJCROPB},		RTF_OBJCROPB},
{{OOO_STRING_SVTOOLS_RTF_OBJCROPL},		RTF_OBJCROPL},
{{OOO_STRING_SVTOOLS_RTF_OBJCROPR},		RTF_OBJCROPR},
{{OOO_STRING_SVTOOLS_RTF_OBJCROPT},		RTF_OBJCROPT},
{{OOO_STRING_SVTOOLS_RTF_OBJDATA},		RTF_OBJDATA},
{{OOO_STRING_SVTOOLS_RTF_OBJECT},		RTF_OBJECT},
{{OOO_STRING_SVTOOLS_RTF_OBJEMB},		RTF_OBJEMB},
{{OOO_STRING_SVTOOLS_RTF_OBJH},			RTF_OBJH},
{{OOO_STRING_SVTOOLS_RTF_OBJICEMB},		RTF_OBJICEMB},
{{OOO_STRING_SVTOOLS_RTF_OBJLINK},		RTF_OBJLINK},
{{OOO_STRING_SVTOOLS_RTF_OBJLOCK},		RTF_OBJLOCK},
{{OOO_STRING_SVTOOLS_RTF_OBJNAME},		RTF_OBJNAME},
{{OOO_STRING_SVTOOLS_RTF_OBJPUB},		RTF_OBJPUB},
{{OOO_STRING_SVTOOLS_RTF_OBJSCALEX},		RTF_OBJSCALEX},
{{OOO_STRING_SVTOOLS_RTF_OBJSCALEY},		RTF_OBJSCALEY},
{{OOO_STRING_SVTOOLS_RTF_OBJSECT},		RTF_OBJSECT},
{{OOO_STRING_SVTOOLS_RTF_OBJSETSIZE},	RTF_OBJSETSIZE},
{{OOO_STRING_SVTOOLS_RTF_OBJSUB},		RTF_OBJSUB},
{{OOO_STRING_SVTOOLS_RTF_OBJTIME},		RTF_OBJTIME},
{{OOO_STRING_SVTOOLS_RTF_OBJTRANSY},		RTF_OBJTRANSY},
{{OOO_STRING_SVTOOLS_RTF_OBJUPDATE},		RTF_OBJUPDATE},
{{OOO_STRING_SVTOOLS_RTF_OBJW},			RTF_OBJW},
{{OOO_STRING_SVTOOLS_RTF_OTBLRUL},		RTF_OTBLRUL},
{{OOO_STRING_SVTOOLS_RTF_PGNHN},			RTF_PGNHN},
{{OOO_STRING_SVTOOLS_RTF_PGNHNSC},		RTF_PGNHNSC},
{{OOO_STRING_SVTOOLS_RTF_PGNHNSH},		RTF_PGNHNSH},
{{OOO_STRING_SVTOOLS_RTF_PGNHNSM},		RTF_PGNHNSM},
{{OOO_STRING_SVTOOLS_RTF_PGNHNSN},		RTF_PGNHNSN},
{{OOO_STRING_SVTOOLS_RTF_PGNHNSP},		RTF_PGNHNSP},
{{OOO_STRING_SVTOOLS_RTF_PICBMP},		RTF_PICBMP},
{{OOO_STRING_SVTOOLS_RTF_PICBPP},		RTF_PICBPP},
{{OOO_STRING_SVTOOLS_RTF_PN},			RTF_PN},
{{OOO_STRING_SVTOOLS_RTF_PNACROSS},		RTF_PNACROSS},
{{OOO_STRING_SVTOOLS_RTF_PNB},			RTF_PNB},
{{OOO_STRING_SVTOOLS_RTF_PNCAPS},		RTF_PNCAPS},
{{OOO_STRING_SVTOOLS_RTF_PNCARD},		RTF_PNCARD},
{{OOO_STRING_SVTOOLS_RTF_PNCF},			RTF_PNCF},
{{OOO_STRING_SVTOOLS_RTF_PNDEC},			RTF_PNDEC},
{{OOO_STRING_SVTOOLS_RTF_PNF},			RTF_PNF},
{{OOO_STRING_SVTOOLS_RTF_PNFS},			RTF_PNFS},
{{OOO_STRING_SVTOOLS_RTF_PNHANG},		RTF_PNHANG},
{{OOO_STRING_SVTOOLS_RTF_PNI},			RTF_PNI},
{{OOO_STRING_SVTOOLS_RTF_PNINDENT},		RTF_PNINDENT},
{{OOO_STRING_SVTOOLS_RTF_PNLCLTR},		RTF_PNLCLTR},
{{OOO_STRING_SVTOOLS_RTF_PNLCRM},		RTF_PNLCRM},
{{OOO_STRING_SVTOOLS_RTF_PNLVL},			RTF_PNLVL},
{{OOO_STRING_SVTOOLS_RTF_PNLVLBLT},		RTF_PNLVLBLT},
{{OOO_STRING_SVTOOLS_RTF_PNLVLBODY},		RTF_PNLVLBODY},
{{OOO_STRING_SVTOOLS_RTF_PNLVLCONT},		RTF_PNLVLCONT},
{{OOO_STRING_SVTOOLS_RTF_PNNUMONCE},		RTF_PNNUMONCE},
{{OOO_STRING_SVTOOLS_RTF_PNORD},			RTF_PNORD},
{{OOO_STRING_SVTOOLS_RTF_PNORDT},		RTF_PNORDT},
{{OOO_STRING_SVTOOLS_RTF_PNPREV},		RTF_PNPREV},
{{OOO_STRING_SVTOOLS_RTF_PNQC},			RTF_PNQC},
{{OOO_STRING_SVTOOLS_RTF_PNQL},			RTF_PNQL},
{{OOO_STRING_SVTOOLS_RTF_PNQR},			RTF_PNQR},
{{OOO_STRING_SVTOOLS_RTF_PNRESTART},		RTF_PNRESTART},
{{OOO_STRING_SVTOOLS_RTF_PNSCAPS},		RTF_PNSCAPS},
{{OOO_STRING_SVTOOLS_RTF_PNSECLVL},		RTF_PNSECLVL},
{{OOO_STRING_SVTOOLS_RTF_PNSP},			RTF_PNSP},
{{OOO_STRING_SVTOOLS_RTF_PNSTART},		RTF_PNSTART},
{{OOO_STRING_SVTOOLS_RTF_PNSTRIKE},		RTF_PNSTRIKE},
{{OOO_STRING_SVTOOLS_RTF_PNTEXT},		RTF_PNTEXT},
{{OOO_STRING_SVTOOLS_RTF_PNTXTA},		RTF_PNTXTA},
{{OOO_STRING_SVTOOLS_RTF_PNTXTB},		RTF_PNTXTB},
{{OOO_STRING_SVTOOLS_RTF_PNUCLTR},		RTF_PNUCLTR},
{{OOO_STRING_SVTOOLS_RTF_PNUCRM},		RTF_PNUCRM},
{{OOO_STRING_SVTOOLS_RTF_PNUL},			RTF_PNUL},
{{OOO_STRING_SVTOOLS_RTF_PNULD},			RTF_PNULD},
{{OOO_STRING_SVTOOLS_RTF_PNULDB},		RTF_PNULDB},
{{OOO_STRING_SVTOOLS_RTF_PNULNONE},		RTF_PNULNONE},
{{OOO_STRING_SVTOOLS_RTF_PNULW},			RTF_PNULW},
{{OOO_STRING_SVTOOLS_RTF_PRCOLBL},		RTF_PRCOLBL},
{{OOO_STRING_SVTOOLS_RTF_PRINTDATA},		RTF_PRINTDATA},
{{OOO_STRING_SVTOOLS_RTF_PSZ},			RTF_PSZ},
{{OOO_STRING_SVTOOLS_RTF_PUBAUTO},		RTF_PUBAUTO},
{{OOO_STRING_SVTOOLS_RTF_RESULT},		RTF_RESULT},
{{OOO_STRING_SVTOOLS_RTF_REVAUTH},		RTF_REVAUTH},
{{OOO_STRING_SVTOOLS_RTF_REVDTTM},		RTF_REVDTTM},
{{OOO_STRING_SVTOOLS_RTF_REVPROT},		RTF_REVPROT},
{{OOO_STRING_SVTOOLS_RTF_REVTBL},		RTF_REVTBL},
{{OOO_STRING_SVTOOLS_RTF_RSLTBMP},		RTF_RSLTBMP},
{{OOO_STRING_SVTOOLS_RTF_RSLTMERGE},		RTF_RSLTMERGE},
{{OOO_STRING_SVTOOLS_RTF_RSLTPICT},		RTF_RSLTPICT},
{{OOO_STRING_SVTOOLS_RTF_RSLTRTF},		RTF_RSLTRTF},
{{OOO_STRING_SVTOOLS_RTF_RSLTTXT},		RTF_RSLTTXT},
{{OOO_STRING_SVTOOLS_RTF_RTLCH},			RTF_RTLCH},
{{OOO_STRING_SVTOOLS_RTF_RTLDOC},		RTF_RTLDOC},
{{OOO_STRING_SVTOOLS_RTF_RTLMARK},		RTF_RTLMARK},
{{OOO_STRING_SVTOOLS_RTF_RTLPAR},		RTF_RTLPAR},
{{OOO_STRING_SVTOOLS_RTF_RTLROW},		RTF_RTLROW},
{{OOO_STRING_SVTOOLS_RTF_RTLSECT},		RTF_RTLSECT},
{{OOO_STRING_SVTOOLS_RTF_SEC},			RTF_SEC},
{{OOO_STRING_SVTOOLS_RTF_SECTNUM},		RTF_SECTNUM},
{{OOO_STRING_SVTOOLS_RTF_SECTUNLOCKED},	RTF_SECTUNLOCKED},
{{OOO_STRING_SVTOOLS_RTF_SLMULT},		RTF_SLMULT},
{{OOO_STRING_SVTOOLS_RTF_SOFTCOL},		RTF_SOFTCOL},
{{OOO_STRING_SVTOOLS_RTF_SOFTLHEIGHT},	RTF_SOFTLHEIGHT},
{{OOO_STRING_SVTOOLS_RTF_SOFTLINE},		RTF_SOFTLINE},
{{OOO_STRING_SVTOOLS_RTF_SOFTPAGE},		RTF_SOFTPAGE},
{{OOO_STRING_SVTOOLS_RTF_SPRSSPBF},		RTF_SPRSSPBF},
{{OOO_STRING_SVTOOLS_RTF_SPRSTSP},		RTF_SPRSTSP},
{{OOO_STRING_SVTOOLS_RTF_SUBDOCUMENT},	RTF_SUBDOCUMENT},
{{OOO_STRING_SVTOOLS_RTF_SWPBDR},		RTF_SWPBDR},
{{OOO_STRING_SVTOOLS_RTF_TCN},			RTF_TCN},
{{OOO_STRING_SVTOOLS_RTF_TRANSMF},		RTF_TRANSMF},
{{OOO_STRING_SVTOOLS_RTF_TRBRDRB},		RTF_TRBRDRB},
{{OOO_STRING_SVTOOLS_RTF_TRBRDRH},		RTF_TRBRDRH},
{{OOO_STRING_SVTOOLS_RTF_TRBRDRL},		RTF_TRBRDRL},
{{OOO_STRING_SVTOOLS_RTF_TRBRDRR},		RTF_TRBRDRR},
{{OOO_STRING_SVTOOLS_RTF_TRBRDRT},		RTF_TRBRDRT},
{{OOO_STRING_SVTOOLS_RTF_TRBRDRV},		RTF_TRBRDRV},
{{OOO_STRING_SVTOOLS_RTF_TRHDR},			RTF_TRHDR},
{{OOO_STRING_SVTOOLS_RTF_TRKEEP},		RTF_TRKEEP},
{{OOO_STRING_SVTOOLS_RTF_TRPADDB},      RTF_TRPADDB},
{{OOO_STRING_SVTOOLS_RTF_TRPADDL},      RTF_TRPADDL},
{{OOO_STRING_SVTOOLS_RTF_TRPADDR},      RTF_TRPADDR},
{{OOO_STRING_SVTOOLS_RTF_TRPADDT},      RTF_TRPADDT},
{{OOO_STRING_SVTOOLS_RTF_TRPADDFB},      RTF_TRPADDFB},
{{OOO_STRING_SVTOOLS_RTF_TRPADDFL},      RTF_TRPADDFL},
{{OOO_STRING_SVTOOLS_RTF_TRPADDFR},      RTF_TRPADDFR},
{{OOO_STRING_SVTOOLS_RTF_TRPADDFT},      RTF_TRPADDFT},


{{OOO_STRING_SVTOOLS_RTF_WRAPTRSP},		RTF_WRAPTRSP},
{{OOO_STRING_SVTOOLS_RTF_XEF},			RTF_XEF},
{{OOO_STRING_SVTOOLS_RTF_ZWJ},			RTF_ZWJ},
{{OOO_STRING_SVTOOLS_RTF_ZWNJ},			RTF_ZWNJ},


{{OOO_STRING_SVTOOLS_RTF_ABSLOCK},		RTF_ABSLOCK},
{{OOO_STRING_SVTOOLS_RTF_ADJUSTRIGHT},	RTF_ADJUSTRIGHT},
{{OOO_STRING_SVTOOLS_RTF_AFTNNCHOSUNG},	RTF_AFTNNCHOSUNG},
{{OOO_STRING_SVTOOLS_RTF_AFTNNCNUM},		RTF_AFTNNCNUM},
{{OOO_STRING_SVTOOLS_RTF_AFTNNDBAR},		RTF_AFTNNDBAR},
{{OOO_STRING_SVTOOLS_RTF_AFTNNDBNUM},	RTF_AFTNNDBNUM},
{{OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMD},	RTF_AFTNNDBNUMD},
{{OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMK},	RTF_AFTNNDBNUMK},
{{OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMT},	RTF_AFTNNDBNUMT},
{{OOO_STRING_SVTOOLS_RTF_AFTNNGANADA},	RTF_AFTNNGANADA},
{{OOO_STRING_SVTOOLS_RTF_AFTNNGBNUM},	RTF_AFTNNGBNUM},
{{OOO_STRING_SVTOOLS_RTF_AFTNNGBNUMD},	RTF_AFTNNGBNUMD},
{{OOO_STRING_SVTOOLS_RTF_AFTNNGBNUMK},	RTF_AFTNNGBNUMK},
{{OOO_STRING_SVTOOLS_RTF_AFTNNGBNUML},	RTF_AFTNNGBNUML},
{{OOO_STRING_SVTOOLS_RTF_AFTNNZODIAC},	RTF_AFTNNZODIAC},
{{OOO_STRING_SVTOOLS_RTF_AFTNNZODIACD},	RTF_AFTNNZODIACD},
{{OOO_STRING_SVTOOLS_RTF_AFTNNZODIACL},	RTF_AFTNNZODIACL},
{{OOO_STRING_SVTOOLS_RTF_ANIMTEXT},		RTF_ANIMTEXT},
{{OOO_STRING_SVTOOLS_RTF_ANSICPG},		RTF_ANSICPG},
{{OOO_STRING_SVTOOLS_RTF_BACKGROUND},	RTF_BACKGROUND},
{{OOO_STRING_SVTOOLS_RTF_BDBFHDR},		RTF_BDBFHDR},
{{OOO_STRING_SVTOOLS_RTF_BLIPTAG},		RTF_BLIPTAG},
{{OOO_STRING_SVTOOLS_RTF_BLIPUID},		RTF_BLIPUID},
{{OOO_STRING_SVTOOLS_RTF_BLIPUPI},		RTF_BLIPUPI},
{{OOO_STRING_SVTOOLS_RTF_BRDRART},		RTF_BRDRART},
{{OOO_STRING_SVTOOLS_RTF_BRDRDASHD},		RTF_BRDRDASHD},
{{OOO_STRING_SVTOOLS_RTF_BRDRDASHDD},	RTF_BRDRDASHDD},
{{OOO_STRING_SVTOOLS_RTF_BRDRDASHDOTSTR},RTF_BRDRDASHDOTSTR},
{{OOO_STRING_SVTOOLS_RTF_BRDRDASHSM},	RTF_BRDRDASHSM},
{{OOO_STRING_SVTOOLS_RTF_BRDREMBOSS},	RTF_BRDREMBOSS},
{{OOO_STRING_SVTOOLS_RTF_BRDRENGRAVE},	RTF_BRDRENGRAVE},
{{OOO_STRING_SVTOOLS_RTF_BRDRFRAME},		RTF_BRDRFRAME},
{{OOO_STRING_SVTOOLS_RTF_BRDRTHTNLG},	RTF_BRDRTHTNLG},
{{OOO_STRING_SVTOOLS_RTF_BRDRTHTNMG},	RTF_BRDRTHTNMG},
{{OOO_STRING_SVTOOLS_RTF_BRDRTHTNSG},	RTF_BRDRTHTNSG},
{{OOO_STRING_SVTOOLS_RTF_BRDRTNTHLG},	RTF_BRDRTNTHLG},
{{OOO_STRING_SVTOOLS_RTF_BRDRTNTHMG},	RTF_BRDRTNTHMG},
{{OOO_STRING_SVTOOLS_RTF_BRDRTNTHSG},	RTF_BRDRTNTHSG},
{{OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNLG},	RTF_BRDRTNTHTNLG},
{{OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNMG},	RTF_BRDRTNTHTNMG},
{{OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNSG},	RTF_BRDRTNTHTNSG},
{{OOO_STRING_SVTOOLS_RTF_BRDRTRIPLE},	RTF_BRDRTRIPLE},
{{OOO_STRING_SVTOOLS_RTF_BRDRWAVY},		RTF_BRDRWAVY},
{{OOO_STRING_SVTOOLS_RTF_BRDRWAVYDB},	RTF_BRDRWAVYDB},
{{OOO_STRING_SVTOOLS_RTF_CATEGORY},		RTF_CATEGORY},
{{OOO_STRING_SVTOOLS_RTF_CGRID},			RTF_CGRID},
{{OOO_STRING_SVTOOLS_RTF_CHARSCALEX},	RTF_CHARSCALEX},
{{OOO_STRING_SVTOOLS_RTF_CHBGBDIAG},		RTF_CHBGBDIAG},
{{OOO_STRING_SVTOOLS_RTF_CHBGCROSS},		RTF_CHBGCROSS},
{{OOO_STRING_SVTOOLS_RTF_CHBGDCROSS},	RTF_CHBGDCROSS},
{{OOO_STRING_SVTOOLS_RTF_CHBGDKBDIAG},	RTF_CHBGDKBDIAG},
{{OOO_STRING_SVTOOLS_RTF_CHBGDKCROSS},	RTF_CHBGDKCROSS},
{{OOO_STRING_SVTOOLS_RTF_CHBGDKDCROSS},	RTF_CHBGDKDCROSS},
{{OOO_STRING_SVTOOLS_RTF_CHBGDKFDIAG},	RTF_CHBGDKFDIAG},
{{OOO_STRING_SVTOOLS_RTF_CHBGDKHORIZ},	RTF_CHBGDKHORIZ},
{{OOO_STRING_SVTOOLS_RTF_CHBGDKVERT},	RTF_CHBGDKVERT},
{{OOO_STRING_SVTOOLS_RTF_CHBGFDIAG},		RTF_CHBGFDIAG},
{{OOO_STRING_SVTOOLS_RTF_CHBGHORIZ},		RTF_CHBGHORIZ},
{{OOO_STRING_SVTOOLS_RTF_CHBGVERT},		RTF_CHBGVERT},
{{OOO_STRING_SVTOOLS_RTF_CHBRDR},		RTF_CHBRDR},
{{OOO_STRING_SVTOOLS_RTF_CHCBPAT},		RTF_CHCBPAT},
{{OOO_STRING_SVTOOLS_RTF_CHCFPAT},		RTF_CHCFPAT},
{{OOO_STRING_SVTOOLS_RTF_CHSHDNG},		RTF_CHSHDNG},
{{OOO_STRING_SVTOOLS_RTF_CLTXLRTB},		RTF_CLTXLRTB},
{{OOO_STRING_SVTOOLS_RTF_CLTXTBRL},		RTF_CLTXTBRL},
{{OOO_STRING_SVTOOLS_RTF_CLVERTALB},		RTF_CLVERTALB},
{{OOO_STRING_SVTOOLS_RTF_CLVERTALC},		RTF_CLVERTALC},
{{OOO_STRING_SVTOOLS_RTF_CLVERTALT},		RTF_CLVERTALT},
{{OOO_STRING_SVTOOLS_RTF_CLVMGF},		RTF_CLVMGF},
{{OOO_STRING_SVTOOLS_RTF_CLVMRG},		RTF_CLVMRG},
{{OOO_STRING_SVTOOLS_RTF_CLTXTBRLV}, 	RTF_CLTXTBRLV},
{{OOO_STRING_SVTOOLS_RTF_CLTXBTLR}, 		RTF_CLTXBTLR},
{{OOO_STRING_SVTOOLS_RTF_CLTXLRTBV},		RTF_CLTXLRTBV},
{{OOO_STRING_SVTOOLS_RTF_COMPANY},		RTF_COMPANY},
{{OOO_STRING_SVTOOLS_RTF_CRAUTH},		RTF_CRAUTH},
{{OOO_STRING_SVTOOLS_RTF_CRDATE},		RTF_CRDATE},
{{OOO_STRING_SVTOOLS_RTF_DATE},			RTF_DATE},
{{OOO_STRING_SVTOOLS_RTF_DEFLANGFE},		RTF_DEFLANGFE},
{{OOO_STRING_SVTOOLS_RTF_DFRAUTH},		RTF_DFRAUTH},
{{OOO_STRING_SVTOOLS_RTF_DFRDATE},		RTF_DFRDATE},
{{OOO_STRING_SVTOOLS_RTF_DFRSTART},		RTF_DFRSTART},
{{OOO_STRING_SVTOOLS_RTF_DFRSTOP},		RTF_DFRSTOP},
{{OOO_STRING_SVTOOLS_RTF_DFRXST},		RTF_DFRXST},
{{OOO_STRING_SVTOOLS_RTF_DGMARGIN},		RTF_DGMARGIN},
{{OOO_STRING_SVTOOLS_RTF_DNTBLNSBDB},	RTF_DNTBLNSBDB},
{{OOO_STRING_SVTOOLS_RTF_DOCTYPE},		RTF_DOCTYPE},
{{OOO_STRING_SVTOOLS_RTF_DOCVAR},		RTF_DOCVAR},
{{OOO_STRING_SVTOOLS_RTF_DPCODESCENT},	RTF_DPCODESCENT},
{{OOO_STRING_SVTOOLS_RTF_EMBO},			RTF_EMBO},
{{OOO_STRING_SVTOOLS_RTF_EMFBLIP},		RTF_EMFBLIP},
{{OOO_STRING_SVTOOLS_RTF_EXPSHRTN},		RTF_EXPSHRTN},
{{OOO_STRING_SVTOOLS_RTF_FAAUTO},		RTF_FAAUTO},
{{OOO_STRING_SVTOOLS_RTF_FBIAS},			RTF_FBIAS},
{{OOO_STRING_SVTOOLS_RTF_FFDEFRES},		RTF_FFDEFRES},
{{OOO_STRING_SVTOOLS_RTF_FFDEFTEXT},		RTF_FFDEFTEXT},
{{OOO_STRING_SVTOOLS_RTF_FFENTRYMCR},	RTF_FFENTRYMCR},
{{OOO_STRING_SVTOOLS_RTF_FFEXITMCR},		RTF_FFEXITMCR},
{{OOO_STRING_SVTOOLS_RTF_FFFORMAT},		RTF_FFFORMAT},
{{OOO_STRING_SVTOOLS_RTF_FFHASLISTBOX},	RTF_FFHASLISTBOX},
{{OOO_STRING_SVTOOLS_RTF_FFHELPTEXT},	RTF_FFHELPTEXT},
{{OOO_STRING_SVTOOLS_RTF_FFHPS},			RTF_FFHPS},
{{OOO_STRING_SVTOOLS_RTF_FFL},			RTF_FFL},
{{OOO_STRING_SVTOOLS_RTF_FFMAXLEN},		RTF_FFMAXLEN},
{{OOO_STRING_SVTOOLS_RTF_FFNAME},		RTF_FFNAME},
{{OOO_STRING_SVTOOLS_RTF_FFOWNHELP},		RTF_FFOWNHELP},
{{OOO_STRING_SVTOOLS_RTF_FFOWNSTAT},		RTF_FFOWNSTAT},
{{OOO_STRING_SVTOOLS_RTF_FFPROT},		RTF_FFPROT},
{{OOO_STRING_SVTOOLS_RTF_FFRECALC},		RTF_FFRECALC},
{{OOO_STRING_SVTOOLS_RTF_FFRES},			RTF_FFRES},
{{OOO_STRING_SVTOOLS_RTF_FFSIZE},		RTF_FFSIZE},
{{OOO_STRING_SVTOOLS_RTF_FFSTATTEXT},	RTF_FFSTATTEXT},
{{OOO_STRING_SVTOOLS_RTF_FFTYPE},		RTF_FFTYPE},
{{OOO_STRING_SVTOOLS_RTF_FFTYPETXT},		RTF_FFTYPETXT},
{{OOO_STRING_SVTOOLS_RTF_FLDTYPE},		RTF_FLDTYPE},
{{OOO_STRING_SVTOOLS_RTF_FNAME},			RTF_FNAME},
{{OOO_STRING_SVTOOLS_RTF_FORMFIELD},		RTF_FORMFIELD},
{{OOO_STRING_SVTOOLS_RTF_FROMTEXT},		RTF_FROMTEXT},
{{OOO_STRING_SVTOOLS_RTF_FTNNCHOSUNG},	RTF_FTNNCHOSUNG},
{{OOO_STRING_SVTOOLS_RTF_FTNNCNUM},		RTF_FTNNCNUM},
{{OOO_STRING_SVTOOLS_RTF_FTNNDBAR},		RTF_FTNNDBAR},
{{OOO_STRING_SVTOOLS_RTF_FTNNDBNUM},		RTF_FTNNDBNUM},
{{OOO_STRING_SVTOOLS_RTF_FTNNDBNUMD},	RTF_FTNNDBNUMD},
{{OOO_STRING_SVTOOLS_RTF_FTNNDBNUMK},	RTF_FTNNDBNUMK},
{{OOO_STRING_SVTOOLS_RTF_FTNNDBNUMT},	RTF_FTNNDBNUMT},
{{OOO_STRING_SVTOOLS_RTF_FTNNGANADA},	RTF_FTNNGANADA},
{{OOO_STRING_SVTOOLS_RTF_FTNNGBNUM},		RTF_FTNNGBNUM},
{{OOO_STRING_SVTOOLS_RTF_FTNNGBNUMD},	RTF_FTNNGBNUMD},
{{OOO_STRING_SVTOOLS_RTF_FTNNGBNUMK},	RTF_FTNNGBNUMK},
{{OOO_STRING_SVTOOLS_RTF_FTNNGBNUML},	RTF_FTNNGBNUML},
{{OOO_STRING_SVTOOLS_RTF_FTNNZODIAC},	RTF_FTNNZODIAC},
{{OOO_STRING_SVTOOLS_RTF_FTNNZODIACD},	RTF_FTNNZODIACD},
{{OOO_STRING_SVTOOLS_RTF_FTNNZODIACL},	RTF_FTNNZODIACL},
{{OOO_STRING_SVTOOLS_RTF_G},				RTF_G},
{{OOO_STRING_SVTOOLS_RTF_GCW},			RTF_GCW},
{{OOO_STRING_SVTOOLS_RTF_GRIDTBL},		RTF_GRIDTBL},
{{OOO_STRING_SVTOOLS_RTF_HIGHLIGHT},		RTF_HIGHLIGHT},
{{OOO_STRING_SVTOOLS_RTF_HLFR},			RTF_HLFR},
{{OOO_STRING_SVTOOLS_RTF_HLINKBASE},		RTF_HLINKBASE},
{{OOO_STRING_SVTOOLS_RTF_HLLOC},			RTF_HLLOC},
{{OOO_STRING_SVTOOLS_RTF_HLSRC},			RTF_HLSRC},
{{OOO_STRING_SVTOOLS_RTF_ILVL},			RTF_ILVL},
{{OOO_STRING_SVTOOLS_RTF_IMPR},			RTF_IMPR},
{{OOO_STRING_SVTOOLS_RTF_JPEGBLIP},		RTF_JPEGBLIP},
{{OOO_STRING_SVTOOLS_RTF_LEVELFOLLOW},	RTF_LEVELFOLLOW},
{{OOO_STRING_SVTOOLS_RTF_LEVELINDENT},	RTF_LEVELINDENT},
{{OOO_STRING_SVTOOLS_RTF_LEVELJC},		RTF_LEVELJC},
{{OOO_STRING_SVTOOLS_RTF_LEVELLEGAL},	RTF_LEVELLEGAL},
{{OOO_STRING_SVTOOLS_RTF_LEVELNFC},		RTF_LEVELNFC},
{{OOO_STRING_SVTOOLS_RTF_LEVELNORESTART},RTF_LEVELNORESTART},
{{OOO_STRING_SVTOOLS_RTF_LEVELNUMBERS},	RTF_LEVELNUMBERS},
{{OOO_STRING_SVTOOLS_RTF_LEVELOLD},		RTF_LEVELOLD},
{{OOO_STRING_SVTOOLS_RTF_LEVELPREV},		RTF_LEVELPREV},
{{OOO_STRING_SVTOOLS_RTF_LEVELPREVSPACE},RTF_LEVELPREVSPACE},
{{OOO_STRING_SVTOOLS_RTF_LEVELSPACE},	RTF_LEVELSPACE},
{{OOO_STRING_SVTOOLS_RTF_LEVELSTARTAT},	RTF_LEVELSTARTAT},
{{OOO_STRING_SVTOOLS_RTF_LEVELTEXT},		RTF_LEVELTEXT},
{{OOO_STRING_SVTOOLS_RTF_LINKVAL},		RTF_LINKVAL},
{{OOO_STRING_SVTOOLS_RTF_LIST},			RTF_LIST},
{{OOO_STRING_SVTOOLS_RTF_LISTID},		RTF_LISTID},
{{OOO_STRING_SVTOOLS_RTF_LISTLEVEL},     RTF_LISTLEVEL},
{{OOO_STRING_SVTOOLS_RTF_LISTNAME},		RTF_LISTNAME},
{{OOO_STRING_SVTOOLS_RTF_LISTOVERRIDE},	RTF_LISTOVERRIDE},
{{OOO_STRING_SVTOOLS_RTF_LISTOVERRIDECOUNT},		RTF_LISTOVERRIDECOUNT},
{{OOO_STRING_SVTOOLS_RTF_LISTOVERRIDEFORMAT},	RTF_LISTOVERRIDEFORMAT},
{{OOO_STRING_SVTOOLS_RTF_LISTOVERRIDESTART},		RTF_LISTOVERRIDESTART},
{{OOO_STRING_SVTOOLS_RTF_LISTOVERRIDETABLE},		RTF_LISTOVERRIDETABLE},
{{OOO_STRING_SVTOOLS_RTF_LISTRESTARTHDN},RTF_LISTRESTARTHDN},
{{OOO_STRING_SVTOOLS_RTF_LISTSIMPLE},	RTF_LISTSIMPLE},
{{OOO_STRING_SVTOOLS_RTF_LISTTABLE},		RTF_LISTTABLE},
{{OOO_STRING_SVTOOLS_RTF_LISTTEMPLATEID},RTF_LISTTEMPLATEID},
{{OOO_STRING_SVTOOLS_RTF_LISTTEXT},		RTF_LISTTEXT},
{{OOO_STRING_SVTOOLS_RTF_LS},			RTF_LS},
{{OOO_STRING_SVTOOLS_RTF_LYTEXCTTP},		RTF_LYTEXCTTP},
{{OOO_STRING_SVTOOLS_RTF_LYTPRTMET},		RTF_LYTPRTMET},
{{OOO_STRING_SVTOOLS_RTF_MANAGER},		RTF_MANAGER},
{{OOO_STRING_SVTOOLS_RTF_MSMCAP},		RTF_MSMCAP},
{{OOO_STRING_SVTOOLS_RTF_NOFCHARSWS},	RTF_NOFCHARSWS},
{{OOO_STRING_SVTOOLS_RTF_NOLEAD},		RTF_NOLEAD},
{{OOO_STRING_SVTOOLS_RTF_NONSHPPICT},	RTF_NONSHPPICT},
{{OOO_STRING_SVTOOLS_RTF_NOSECTEXPAND},	RTF_NOSECTEXPAND},
{{OOO_STRING_SVTOOLS_RTF_NOSNAPLINEGRID},RTF_NOSNAPLINEGRID},
{{OOO_STRING_SVTOOLS_RTF_NOSPACEFORUL},	RTF_NOSPACEFORUL},
{{OOO_STRING_SVTOOLS_RTF_NOULTRLSPC},	RTF_NOULTRLSPC},
{{OOO_STRING_SVTOOLS_RTF_NOXLATTOYEN},	RTF_NOXLATTOYEN},
{{OOO_STRING_SVTOOLS_RTF_OBJATTPH},		RTF_OBJATTPH},
{{OOO_STRING_SVTOOLS_RTF_OBJHTML},		RTF_OBJHTML},
{{OOO_STRING_SVTOOLS_RTF_OBJOCX},		RTF_OBJOCX},
{{OOO_STRING_SVTOOLS_RTF_OLDLINEWRAP},	RTF_OLDLINEWRAP},
{{OOO_STRING_SVTOOLS_RTF_OUTLINELEVEL},	RTF_OUTLINELEVEL},
{{OOO_STRING_SVTOOLS_RTF_OVERLAY},		RTF_OVERLAY},
{{OOO_STRING_SVTOOLS_RTF_PANOSE},		RTF_PANOSE},
{{OOO_STRING_SVTOOLS_RTF_PGBRDRB},		RTF_PGBRDRB},
{{OOO_STRING_SVTOOLS_RTF_PGBRDRFOOT},	RTF_PGBRDRFOOT},
{{OOO_STRING_SVTOOLS_RTF_PGBRDRHEAD},	RTF_PGBRDRHEAD},
{{OOO_STRING_SVTOOLS_RTF_PGBRDRL},		RTF_PGBRDRL},
{{OOO_STRING_SVTOOLS_RTF_PGBRDROPT},		RTF_PGBRDROPT},
{{OOO_STRING_SVTOOLS_RTF_PGBRDRR},		RTF_PGBRDRR},
{{OOO_STRING_SVTOOLS_RTF_PGBRDRSNAP},	RTF_PGBRDRSNAP},
{{OOO_STRING_SVTOOLS_RTF_PGBRDRT},		RTF_PGBRDRT},
{{OOO_STRING_SVTOOLS_RTF_PGNCHOSUNG},	RTF_PGNCHOSUNG},
{{OOO_STRING_SVTOOLS_RTF_PGNCNUM},		RTF_PGNCNUM},
{{OOO_STRING_SVTOOLS_RTF_PGNDBNUMK},		RTF_PGNDBNUMK},
{{OOO_STRING_SVTOOLS_RTF_PGNDBNUMT},		RTF_PGNDBNUMT},
{{OOO_STRING_SVTOOLS_RTF_PGNGANADA},		RTF_PGNGANADA},
{{OOO_STRING_SVTOOLS_RTF_PGNGBNUM},		RTF_PGNGBNUM},
{{OOO_STRING_SVTOOLS_RTF_PGNGBNUMD},		RTF_PGNGBNUMD},
{{OOO_STRING_SVTOOLS_RTF_PGNGBNUMK},		RTF_PGNGBNUMK},
{{OOO_STRING_SVTOOLS_RTF_PGNGBNUML},		RTF_PGNGBNUML},
{{OOO_STRING_SVTOOLS_RTF_PGNZODIAC},		RTF_PGNZODIAC},
{{OOO_STRING_SVTOOLS_RTF_PGNZODIACD},	RTF_PGNZODIACD},
{{OOO_STRING_SVTOOLS_RTF_PGNZODIACL},	RTF_PGNZODIACL},
{{OOO_STRING_SVTOOLS_RTF_PICPROP},		RTF_PICPROP},
{{OOO_STRING_SVTOOLS_RTF_PNAIUEO},		RTF_PNAIUEO},
{{OOO_STRING_SVTOOLS_RTF_PNAIUEOD},		RTF_PNAIUEOD},
{{OOO_STRING_SVTOOLS_RTF_PNCHOSUNG},		RTF_PNCHOSUNG},
{{OOO_STRING_SVTOOLS_RTF_PNDBNUMD},		RTF_PNDBNUMD},
{{OOO_STRING_SVTOOLS_RTF_PNDBNUMK},		RTF_PNDBNUMK},
{{OOO_STRING_SVTOOLS_RTF_PNDBNUML},		RTF_PNDBNUML},
{{OOO_STRING_SVTOOLS_RTF_PNDBNUMT},		RTF_PNDBNUMT},
{{OOO_STRING_SVTOOLS_RTF_PNGANADA},		RTF_PNGANADA},
{{OOO_STRING_SVTOOLS_RTF_PNGBLIP},		RTF_PNGBLIP},
{{OOO_STRING_SVTOOLS_RTF_PNGBNUM},		RTF_PNGBNUM},
{{OOO_STRING_SVTOOLS_RTF_PNGBNUMD},		RTF_PNGBNUMD},
{{OOO_STRING_SVTOOLS_RTF_PNGBNUMK},		RTF_PNGBNUMK},
{{OOO_STRING_SVTOOLS_RTF_PNGBNUML},		RTF_PNGBNUML},
{{OOO_STRING_SVTOOLS_RTF_PNRAUTH},		RTF_PNRAUTH},
{{OOO_STRING_SVTOOLS_RTF_PNRDATE},		RTF_PNRDATE},
{{OOO_STRING_SVTOOLS_RTF_PNRNFC},		RTF_PNRNFC},
{{OOO_STRING_SVTOOLS_RTF_PNRNOT},		RTF_PNRNOT},
{{OOO_STRING_SVTOOLS_RTF_PNRPNBR},		RTF_PNRPNBR},
{{OOO_STRING_SVTOOLS_RTF_PNRRGB},		RTF_PNRRGB},
{{OOO_STRING_SVTOOLS_RTF_PNRSTART},		RTF_PNRSTART},
{{OOO_STRING_SVTOOLS_RTF_PNRSTOP},		RTF_PNRSTOP},
{{OOO_STRING_SVTOOLS_RTF_PNRXST},		RTF_PNRXST},
{{OOO_STRING_SVTOOLS_RTF_PNZODIAC},		RTF_PNZODIAC},
{{OOO_STRING_SVTOOLS_RTF_PNZODIACD},		RTF_PNZODIACD},
{{OOO_STRING_SVTOOLS_RTF_PNZODIACL},		RTF_PNZODIACL},
{{OOO_STRING_SVTOOLS_RTF_LFOLEVEL},		RTF_LFOLEVEL},
{{OOO_STRING_SVTOOLS_RTF_POSYIN},		RTF_POSYIN},
{{OOO_STRING_SVTOOLS_RTF_POSYOUT},		RTF_POSYOUT},
{{OOO_STRING_SVTOOLS_RTF_PRIVATE},		RTF_PRIVATE},
{{OOO_STRING_SVTOOLS_RTF_PROPNAME},		RTF_PROPNAME},
{{OOO_STRING_SVTOOLS_RTF_PROPTYPE},		RTF_PROPTYPE},
{{OOO_STRING_SVTOOLS_RTF_REVAUTHDEL},	RTF_REVAUTHDEL},
{{OOO_STRING_SVTOOLS_RTF_REVDTTMDEL},	RTF_REVDTTMDEL},
{{OOO_STRING_SVTOOLS_RTF_SAUTOUPD},		RTF_SAUTOUPD},
{{OOO_STRING_SVTOOLS_RTF_SECTDEFAULTCL},	RTF_SECTDEFAULTCL},
{{OOO_STRING_SVTOOLS_RTF_SECTEXPAND},	RTF_SECTEXPAND},
{{OOO_STRING_SVTOOLS_RTF_SECTLINEGRID},	RTF_SECTLINEGRID},
{{OOO_STRING_SVTOOLS_RTF_SECTSPECIFYCL},	RTF_SECTSPECIFYCL},
{{OOO_STRING_SVTOOLS_RTF_SECTSPECIFYL},	RTF_SECTSPECIFYL},
{{OOO_STRING_SVTOOLS_RTF_SHIDDEN},		RTF_SHIDDEN},
{{OOO_STRING_SVTOOLS_RTF_SHPBOTTOM},		RTF_SHPBOTTOM},
{{OOO_STRING_SVTOOLS_RTF_SHPBXCOLUMN},	RTF_SHPBXCOLUMN},
{{OOO_STRING_SVTOOLS_RTF_SHPBXMARGIN},	RTF_SHPBXMARGIN},
{{OOO_STRING_SVTOOLS_RTF_SHPBXPAGE},		RTF_SHPBXPAGE},
{{OOO_STRING_SVTOOLS_RTF_SHPBYMARGIN},	RTF_SHPBYMARGIN},
{{OOO_STRING_SVTOOLS_RTF_SHPBYPAGE},		RTF_SHPBYPAGE},
{{OOO_STRING_SVTOOLS_RTF_SHPBYPARA},		RTF_SHPBYPARA},
{{OOO_STRING_SVTOOLS_RTF_SHPFBLWTXT},	RTF_SHPFBLWTXT},
{{OOO_STRING_SVTOOLS_RTF_SHPFHDR},		RTF_SHPFHDR},
{{OOO_STRING_SVTOOLS_RTF_SHPGRP},		RTF_SHPGRP},
{{OOO_STRING_SVTOOLS_RTF_SHPLEFT},		RTF_SHPLEFT},
{{OOO_STRING_SVTOOLS_RTF_SHPLID},		RTF_SHPLID},
{{OOO_STRING_SVTOOLS_RTF_SHPLOCKANCHOR},	RTF_SHPLOCKANCHOR},
{{OOO_STRING_SVTOOLS_RTF_SHPPICT},		RTF_SHPPICT},
{{OOO_STRING_SVTOOLS_RTF_SHPRIGHT},		RTF_SHPRIGHT},
{{OOO_STRING_SVTOOLS_RTF_SHPRSLT},		RTF_SHPRSLT},
{{OOO_STRING_SVTOOLS_RTF_SHPTOP},		RTF_SHPTOP},
{{OOO_STRING_SVTOOLS_RTF_SHPTXT},		RTF_SHPTXT},
{{OOO_STRING_SVTOOLS_RTF_SHPWRK},		RTF_SHPWRK},
{{OOO_STRING_SVTOOLS_RTF_SHPWR},			RTF_SHPWR},
{{OOO_STRING_SVTOOLS_RTF_SHPZ},			RTF_SHPZ},
{{OOO_STRING_SVTOOLS_RTF_SPRSBSP},		RTF_SPRSBSP},
{{OOO_STRING_SVTOOLS_RTF_SPRSLNSP},		RTF_SPRSLNSP},
{{OOO_STRING_SVTOOLS_RTF_SPRSTSM},		RTF_SPRSTSM},
{{OOO_STRING_SVTOOLS_RTF_STATICVAL},		RTF_STATICVAL},
{{OOO_STRING_SVTOOLS_RTF_STEXTFLOW},		RTF_STEXTFLOW},
{{OOO_STRING_SVTOOLS_RTF_STRIKED},		RTF_STRIKED},
{{OOO_STRING_SVTOOLS_RTF_SUBFONTBYSIZE},	RTF_SUBFONTBYSIZE},
{{OOO_STRING_SVTOOLS_RTF_TCELLD},		RTF_TCELLD},
{{OOO_STRING_SVTOOLS_RTF_TIME},			RTF_TIME},
{{OOO_STRING_SVTOOLS_RTF_TRUNCATEFONTHEIGHT},	RTF_TRUNCATEFONTHEIGHT},
{{OOO_STRING_SVTOOLS_RTF_UC},			RTF_UC},
{{OOO_STRING_SVTOOLS_RTF_UD},			RTF_UD},
{{OOO_STRING_SVTOOLS_RTF_ULDASH},		RTF_ULDASH},
{{OOO_STRING_SVTOOLS_RTF_ULDASHD},		RTF_ULDASHD},
{{OOO_STRING_SVTOOLS_RTF_ULDASHDD},		RTF_ULDASHDD},
{{OOO_STRING_SVTOOLS_RTF_ULTH},			RTF_ULTH},
{{OOO_STRING_SVTOOLS_RTF_ULWAVE},		RTF_ULWAVE},
{{OOO_STRING_SVTOOLS_RTF_ULC},			RTF_ULC},
{{OOO_STRING_SVTOOLS_RTF_U},				RTF_U},
{{OOO_STRING_SVTOOLS_RTF_UPR},			RTF_UPR},
{{OOO_STRING_SVTOOLS_RTF_USERPROPS},		RTF_USERPROPS},
{{OOO_STRING_SVTOOLS_RTF_VIEWKIND},		RTF_VIEWKIND},
{{OOO_STRING_SVTOOLS_RTF_VIEWSCALE},		RTF_VIEWSCALE},
{{OOO_STRING_SVTOOLS_RTF_VIEWZK},		RTF_VIEWZK},
{{OOO_STRING_SVTOOLS_RTF_WIDCTLPAR},		RTF_WIDCTLPAR},
{{OOO_STRING_SVTOOLS_RTF_WINDOWCAPTION},	RTF_WINDOWCAPTION},
{{OOO_STRING_SVTOOLS_RTF_WPEQN},			RTF_WPEQN},
{{OOO_STRING_SVTOOLS_RTF_WPJST},			RTF_WPJST},
{{OOO_STRING_SVTOOLS_RTF_WPSP},			RTF_WPSP},
{{OOO_STRING_SVTOOLS_RTF_YXE},			RTF_YXE},
{{OOO_STRING_SVTOOLS_RTF_FRMTXLRTB},    RTF_FRMTXLRTB},
{{OOO_STRING_SVTOOLS_RTF_FRMTXTBRL},    RTF_FRMTXTBRL},
{{OOO_STRING_SVTOOLS_RTF_FRMTXBTLR},    RTF_FRMTXBTLR},
{{OOO_STRING_SVTOOLS_RTF_FRMTXLRTBV},   RTF_FRMTXLRTBV},
{{OOO_STRING_SVTOOLS_RTF_FRMTXTBRLV},   RTF_FRMTXTBRLV},

// MS-2000 Tokens
		{{OOO_STRING_SVTOOLS_RTF_ULTHD},         RTF_ULTHD},
		{{OOO_STRING_SVTOOLS_RTF_ULTHDASH},      RTF_ULTHDASH},
		{{OOO_STRING_SVTOOLS_RTF_ULLDASH},       RTF_ULLDASH},
		{{OOO_STRING_SVTOOLS_RTF_ULTHLDASH},     RTF_ULTHLDASH},
		{{OOO_STRING_SVTOOLS_RTF_ULTHDASHD},     RTF_ULTHDASHD},
		{{OOO_STRING_SVTOOLS_RTF_ULTHDASHDD},    RTF_ULTHDASHDD},
		{{OOO_STRING_SVTOOLS_RTF_ULHWAVE},       RTF_ULHWAVE},
		{{OOO_STRING_SVTOOLS_RTF_ULULDBWAVE},    RTF_ULULDBWAVE},

		{{OOO_STRING_SVTOOLS_RTF_LOCH},    		RTF_LOCH},
		{{OOO_STRING_SVTOOLS_RTF_HICH},    		RTF_HICH},
		{{OOO_STRING_SVTOOLS_RTF_DBCH},    		RTF_DBCH},
		{{OOO_STRING_SVTOOLS_RTF_LANGFE},    	RTF_LANGFE},
		{{OOO_STRING_SVTOOLS_RTF_ADEFLANG},		RTF_ADEFLANG},
		{{OOO_STRING_SVTOOLS_RTF_ADEFF},			RTF_ADEFF},
		{{OOO_STRING_SVTOOLS_RTF_ACCNONE},		RTF_ACCNONE},
		{{OOO_STRING_SVTOOLS_RTF_ACCDOT},		RTF_ACCDOT},
		{{OOO_STRING_SVTOOLS_RTF_ACCCOMMA},		RTF_ACCCOMMA},
		{{OOO_STRING_SVTOOLS_RTF_TWOINONE},		RTF_TWOINONE},
		{{OOO_STRING_SVTOOLS_RTF_HORZVERT},		RTF_HORZVERT},
		{{OOO_STRING_SVTOOLS_RTF_FAHANG},		RTF_FAHANG},
		{{OOO_STRING_SVTOOLS_RTF_FAVAR},			RTF_FAVAR},
		{{OOO_STRING_SVTOOLS_RTF_FACENTER},		RTF_FACENTER},
		{{OOO_STRING_SVTOOLS_RTF_FAROMAN},		RTF_FAROMAN},
		{{OOO_STRING_SVTOOLS_RTF_FAFIXED},		RTF_FAFIXED},
		{{OOO_STRING_SVTOOLS_RTF_NOCWRAP},       RTF_NOCWRAP},
		{{OOO_STRING_SVTOOLS_RTF_NOOVERFLOW},    RTF_NOOVERFLOW},
		{{OOO_STRING_SVTOOLS_RTF_ASPALPHA},      RTF_ASPALPHA},

// SWG spezifische Attribute
		{{OOO_STRING_SVTOOLS_RTF_GRFALIGNV},     RTF_GRF_ALIGNV},
		{{OOO_STRING_SVTOOLS_RTF_GRFALIGNH},     RTF_GRF_ALIGNH},
		{{OOO_STRING_SVTOOLS_RTF_GRFMIRROR},     RTF_GRF_MIRROR},
		{{OOO_STRING_SVTOOLS_RTF_HEADERYB},      RTF_HEADER_YB},
		{{OOO_STRING_SVTOOLS_RTF_HEADERXL},      RTF_HEADER_XL},
		{{OOO_STRING_SVTOOLS_RTF_HEADERXR},      RTF_HEADER_XR},
		{{OOO_STRING_SVTOOLS_RTF_FOOTERYT},      RTF_FOOTER_YT},
		{{OOO_STRING_SVTOOLS_RTF_FOOTERXL},      RTF_FOOTER_XL},
		{{OOO_STRING_SVTOOLS_RTF_FOOTERXR},      RTF_FOOTER_XR},
		{{OOO_STRING_SVTOOLS_RTF_HEADERYH},      RTF_HEADER_YH},
		{{OOO_STRING_SVTOOLS_RTF_FOOTERYH},      RTF_FOOTER_YH},
		{{OOO_STRING_SVTOOLS_RTF_BALANCEDCOLUMN},RTF_BALANCED_COLUMN},
		{{OOO_STRING_SVTOOLS_RTF_UPDNPROP},      RTF_SWG_ESCPROP},
		{{OOO_STRING_SVTOOLS_RTF_PRTDATA},       RTF_SWG_PRTDATA},
		{{OOO_STRING_SVTOOLS_RTF_BKMKKEY},       RTF_BKMK_KEY},

// Attribute fuer die freifliegenden Rahmen
		{{OOO_STRING_SVTOOLS_RTF_FLYPRINT},      RTF_FLYPRINT},
		{{OOO_STRING_SVTOOLS_RTF_FLYOPAQUE},     RTF_FLYOPAQUE},
		{{OOO_STRING_SVTOOLS_RTF_FLYPRTCTD},     RTF_FLYPRTCTD},
		{{OOO_STRING_SVTOOLS_RTF_FLYMAINCNT},    RTF_FLYMAINCNT},
		{{OOO_STRING_SVTOOLS_RTF_FLYVERT},       RTF_FLYVERT},
		{{OOO_STRING_SVTOOLS_RTF_FLYHORZ},       RTF_FLYHORZ},
		{{OOO_STRING_SVTOOLS_RTF_DFRMTXTL},      RTF_FLYOUTLEFT},
		{{OOO_STRING_SVTOOLS_RTF_DFRMTXTR},      RTF_FLYOUTRIGHT},
		{{OOO_STRING_SVTOOLS_RTF_DFRMTXTU},      RTF_FLYOUTUPPER},
		{{OOO_STRING_SVTOOLS_RTF_DFRMTXTW},      RTF_FLYOUTLOWER},
		{{OOO_STRING_SVTOOLS_RTF_FLYANCHOR},     RTF_FLYANCHOR},
		{{OOO_STRING_SVTOOLS_RTF_FLYCNTNT},      RTF_FLY_CNTNT},
		{{OOO_STRING_SVTOOLS_RTF_FLYCOLUMN},     RTF_FLY_COLUMN},
		{{OOO_STRING_SVTOOLS_RTF_FLYPAGE},       RTF_FLY_PAGE},

		{{OOO_STRING_SVTOOLS_RTF_BRDBOX},        RTF_BRDBOX},
		{{OOO_STRING_SVTOOLS_RTF_BRDLNCOL},      RTF_BRDLINE_COL},
		{{OOO_STRING_SVTOOLS_RTF_BRDLNIN},       RTF_BRDLINE_IN},
		{{OOO_STRING_SVTOOLS_RTF_BRDLNOUT},      RTF_BRDLINE_OUT},
		{{OOO_STRING_SVTOOLS_RTF_BRDLNDIST},     RTF_BRDLINE_DIST},

		{{OOO_STRING_SVTOOLS_RTF_SHADOW},        RTF_SHADOW},
		{{OOO_STRING_SVTOOLS_RTF_SHDWDIST},      RTF_SHDW_DIST},
		{{OOO_STRING_SVTOOLS_RTF_SHDWSTYLE},     RTF_SHDW_STYLE},
		{{OOO_STRING_SVTOOLS_RTF_SHDWCOL},       RTF_SHDW_COL},
		{{OOO_STRING_SVTOOLS_RTF_SHDWFCOL},      RTF_SHDW_FCOL},

		{{OOO_STRING_SVTOOLS_RTF_FLYINPARA},     RTF_FLY_INPARA},

		{{OOO_STRING_SVTOOLS_RTF_PGDSCTBL},      RTF_PGDSCTBL},
		{{OOO_STRING_SVTOOLS_RTF_PGDSC},         RTF_PGDSC},
		{{OOO_STRING_SVTOOLS_RTF_PGDSCUSE},      RTF_PGDSCUSE},
		{{OOO_STRING_SVTOOLS_RTF_PGDSCNXT},      RTF_PGDSCNXT},

		{{OOO_STRING_SVTOOLS_RTF_HYPHEN},        RTF_HYPHEN},
		{{OOO_STRING_SVTOOLS_RTF_HYPHLEAD},      RTF_HYPHLEAD},
		{{OOO_STRING_SVTOOLS_RTF_HYPHTRAIL},     RTF_HYPHTRAIL},
		{{OOO_STRING_SVTOOLS_RTF_HYPHMAX},       RTF_HYPHMAX},

		{{OOO_STRING_SVTOOLS_RTF_TLSWG},         RTF_TLSWG},
		{{OOO_STRING_SVTOOLS_RTF_PGBRK},         RTF_PGBRK},

		{{OOO_STRING_SVTOOLS_RTF_PGDSCNO},       RTF_PGDSCNO},
		{{OOO_STRING_SVTOOLS_RTF_SOUTLVL},       RTF_SOUTLVL},

		{{OOO_STRING_SVTOOLS_RTF_SHP},       RTF_SHP},
		/*
		{{OOO_STRING_SVTOOLS_RTF_SHPLEFT},       RTF_SHPLEFT}
		{{OOO_STRING_SVTOOLS_RTF_SHPTOP},       RTF_SHPTOP}
		{{OOO_STRING_SVTOOLS_RTF_SHPBOTTOM},       RTF_SHPBOTTOM}
		{{OOO_STRING_SVTOOLS_RTF_SHPRIGHT},       RTF_SHPRIGHT}
		*/
		{{OOO_STRING_SVTOOLS_RTF_SN},       RTF_SN},
		{{OOO_STRING_SVTOOLS_RTF_SV},       RTF_SV},

// Support for overline attributes
		{{OOO_STRING_SVTOOLS_RTF_OL}, 			RTF_OL},
		{{OOO_STRING_SVTOOLS_RTF_OLW},			RTF_OLW},
		{{OOO_STRING_SVTOOLS_RTF_OLD},			RTF_OLD},
		{{OOO_STRING_SVTOOLS_RTF_OLDB},			RTF_OLDB},
		{{OOO_STRING_SVTOOLS_RTF_OLNONE}, 		RTF_OLNONE},
		{{OOO_STRING_SVTOOLS_RTF_OLDASH}, 		RTF_OLDASH},
		{{OOO_STRING_SVTOOLS_RTF_OLDASHD},		RTF_OLDASHD},
		{{OOO_STRING_SVTOOLS_RTF_OLDASHDD},		RTF_OLDASHDD},
		{{OOO_STRING_SVTOOLS_RTF_OLTH},			RTF_OLTH},
		{{OOO_STRING_SVTOOLS_RTF_OLWAVE}, 		RTF_OLWAVE},
		{{OOO_STRING_SVTOOLS_RTF_OLC},			RTF_OLC},
		{{OOO_STRING_SVTOOLS_RTF_OLTHD},			RTF_OLTHD},
		{{OOO_STRING_SVTOOLS_RTF_OLTHDASH},		RTF_OLTHDASH},
		{{OOO_STRING_SVTOOLS_RTF_OLLDASH},		RTF_OLLDASH},
		{{OOO_STRING_SVTOOLS_RTF_OLTHLDASH},		RTF_OLTHLDASH},
		{{OOO_STRING_SVTOOLS_RTF_OLTHDASHD},		RTF_OLTHDASHD},
		{{OOO_STRING_SVTOOLS_RTF_OLTHDASHDD}, 	RTF_OLTHDASHDD},
		{{OOO_STRING_SVTOOLS_RTF_OLHWAVE},		RTF_OLHWAVE},
		{{OOO_STRING_SVTOOLS_RTF_OLOLDBWAVE}, 	RTF_OLOLDBWAVE}
};


extern "C" {
static int
#if defined( WNT )
 __cdecl
#endif
#if defined( ICC ) && defined( OS2 )
_Optlink
#endif
	RTFKeyCompare( const void *pFirst, const void *pSecond)
{
    int nRet = 0;
    if( -1 == ((RTF_TokenEntry*)pFirst)->nToken )
    {
        if( -1 == ((RTF_TokenEntry*)pSecond)->nToken )
            nRet = ((RTF_TokenEntry*)pFirst)->pUToken->CompareTo(
                            *((RTF_TokenEntry*)pSecond)->pUToken );
        else
            nRet = ((RTF_TokenEntry*)pFirst)->pUToken->CompareToAscii(
                            ((RTF_TokenEntry*)pSecond)->sToken );
    }
    else
    {
        if( -1 == ((RTF_TokenEntry*)pSecond)->nToken )
            nRet = -1 * ((RTF_TokenEntry*)pSecond)->pUToken->CompareToAscii(
                            ((RTF_TokenEntry*)pFirst)->sToken );
        else
            nRet = strcmp( ((RTF_TokenEntry*)pFirst)->sToken,
                            ((RTF_TokenEntry*)pSecond)->sToken );
    }

    return nRet;
}

}

int GetRTFToken( const String& rSearch )
{
	if( !bSortKeyWords )
	{
		qsort( (void*) aRTFTokenTab,
				sizeof( aRTFTokenTab ) / sizeof( RTF_TokenEntry ),
				sizeof( RTF_TokenEntry ),
				RTFKeyCompare );
		bSortKeyWords = TRUE;
	}

	int nRet = 0;
	void* pFound;
	RTF_TokenEntry aSrch;
	aSrch.pUToken = &rSearch;
	aSrch.nToken = -1;

	if( 0 != ( pFound = bsearch( (char *) &aSrch,
						(void*) aRTFTokenTab,
						sizeof( aRTFTokenTab ) / sizeof( RTF_TokenEntry ),
						sizeof( RTF_TokenEntry ),
						RTFKeyCompare )))
		nRet = ((RTF_TokenEntry*)pFound)->nToken;
	return nRet;
}

/* vi:set tabstop=4 shiftwidth=4 expandtab: */
